/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.metric.agent.input;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.metric.MetricDefinition;
import org.thingsboard.trendz.domain.metric.ai.MetricDefinitionAiLite;
import org.thingsboard.trendz.domain.metric.assistance.MetricCodeAssistanceContext;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.metric.agent.MetricExplorerAiService;
import org.thingsboard.trendz.service.metric.agent.input.domain.MetricBusinessAnalystExpertResponse;
import org.thingsboard.trendz.service.metric.agent.input.domain.MetricBusinessAnalystExpertResult;

@Service
public class MetricBusinessAnalystExpertAgent {
    private final MetricExplorerAiService metricExplorerAiService;

    @Autowired
    public MetricBusinessAnalystExpertAgent(MetricExplorerAiService metricExplorerAiService) {
        this.metricExplorerAiService = metricExplorerAiService;
    }

    public MetricBusinessAnalystExpertResult analyze(MetricCodeAssistanceContext context, String topologyDetails, String itemDetails, String mainTask) {
        MetricDefinition metricDefinition = context.getMetricDefinition();
        JwtSecurityUser user = context.getUser();
        MetricBusinessAnalystExpertResponse metricBusinessAnalystExpertResponse = this.metricExplorerAiService.analyze(user, context.getAgentMetadataContainer(), itemDetails, topologyDetails, mainTask, metricDefinition, context.getCode());
        MetricDefinition newMetricDefinition = this.createNewMetricDefinition(metricDefinition, context.getCode(), metricBusinessAnalystExpertResponse);
        return MetricBusinessAnalystExpertResult.builder().newMetricDefinition(newMetricDefinition).isCodeChangeRequired(metricBusinessAnalystExpertResponse.isCodeChangeRequired()).isMetricDefinitionChangeRequired(metricBusinessAnalystExpertResponse.isMetricDefinitionChangeRequired()).useRelations(metricBusinessAnalystExpertResponse.isUseRelations()).reviewNotes(metricBusinessAnalystExpertResponse.getReviewNotes()).build();
    }

    private MetricDefinition createNewMetricDefinition(MetricDefinition old, String code, MetricBusinessAnalystExpertResponse inputResponse) {
        MetricDefinition newMetricDefinition = new MetricDefinition(old);
        newMetricDefinition.setCode(code);
        newMetricDefinition.setAdvancedMode(inputResponse.isUseRelations());
        if (!inputResponse.isMetricDefinitionChangeRequired()) {
            return newMetricDefinition;
        }
        MetricDefinitionAiLite metricDefinitionAiLite = inputResponse.getMergedMetricDefinition();
        if (metricDefinitionAiLite.getDescription() != null) {
            newMetricDefinition.setDescription(metricDefinitionAiLite.getDescription());
        }
        if (metricDefinitionAiLite.getHowToCalculate() != null) {
            newMetricDefinition.setHowToCalculate(metricDefinitionAiLite.getHowToCalculate());
        }
        return newMetricDefinition;
    }
}

