/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.metric;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.dao.metric.MetricExplorationDao;
import org.thingsboard.trendz.domain.metric.exploration.MetricExploration;
import org.thingsboard.trendz.domain.metric.exploration.MetricExplorationFilteringField;
import org.thingsboard.trendz.domain.metric.exploration.MetricExplorationSaveRequest;
import org.thingsboard.trendz.domain.metric.exploration.MetricExplorationSortingField;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;

@Service
public class MetricExplorationService {
    private final MetricExplorationDao metricExplorationDao;

    @Autowired
    public MetricExplorationService(MetricExplorationDao metricExplorationDao) {
        this.metricExplorationDao = metricExplorationDao;
    }

    public void saveExploration(JwtSecurityUser user, MetricExplorationSaveRequest request) {
        MetricExploration metricExploration = MetricExploration.builder().id(UUID.randomUUID()).itemId(request.getItemId()).itemName(request.getItemName()).tenantId(user.getTenantId()).customerId(user.getCustomerId()).businessEntityId(request.getBusinessEntityId()).businessEntityFieldId(Optional.ofNullable(request.getBusinessEntityFieldId()).orElse(EntityId.NULL_UUID)).metricDefinitionId(Optional.ofNullable(request.getMetricDefinitionId()).orElse(EntityId.NULL_UUID)).explorationTs(System.currentTimeMillis()).build();
        this.metricExplorationDao.upsert(metricExploration);
    }

    public Page<MetricExploration> getAllMetricExplorations(int page, int pageSize, JwtSecurityUser user, List<MetricExplorationFilteringField> filteringFields, List<MetricExplorationSortingField> sortingFields) {
        return this.metricExplorationDao.getAllMetricExplorations(page, pageSize, user, filteringFields, sortingFields);
    }
}

