/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.install;

import java.sql.Connection;
import java.sql.DriverManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.service.install.EntityDatabaseSchemaService;

@Profile(value={"install"})
@Service
public class TrendzSyncResetService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TrendzSyncResetService.class);
    private final String dbUrl;
    private final String dbUserName;
    private final String dbPassword;
    private final EntityDatabaseSchemaService entityDatabaseSchemaService;

    @Autowired
    public TrendzSyncResetService(@Value(value="${spring.datasource.url}") String dbUrl, @Value(value="${spring.datasource.username}") String dbUserName, @Value(value="${spring.datasource.password}") String dbPassword, EntityDatabaseSchemaService entityDatabaseSchemaService) {
        this.dbUrl = dbUrl;
        this.dbUserName = dbUserName;
        this.dbPassword = dbPassword;
        this.entityDatabaseSchemaService = entityDatabaseSchemaService;
    }

    public void performSyncReset() throws Exception {
        try (Connection connection = DriverManager.getConnection(this.dbUrl, this.dbUserName, this.dbPassword);){
            this.entityDatabaseSchemaService.resetSync(connection);
        }
    }
}

