/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.install;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Scanner;
import lombok.Generated;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.util.TriConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Profile(value={"install"})
@Service
public class InstallSettingsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstallSettingsService.class);
    private static final String TRENDZ_CONFIG_FILE_PATH = "/etc/trendz/conf/trendz.conf";
    @Value(value="${spring.datasource.url}")
    private String envDbUrl;
    @Value(value="${spring.datasource.username}")
    private String envDbUserName;
    @Value(value="${spring.datasource.password}")
    private String envDbPassword;

    public void installTrendzSettings(TriConsumer<String, String, String> updateConnectionInfoCallback) {
        try {
            String isDockerInstallation = System.getenv("TRENDZ_DOCKER_VERSION");
            log.info("Is docker image = {}", (Object)(isDockerInstallation != null ? 1 : 0));
            if ("true".equals(isDockerInstallation)) {
                log.info("Docker version of Trendz always uses ENVs therefore there is no need to edit config file.");
                return;
            }
            if (!SystemUtils.IS_OS_LINUX) {
                log.info("Auto installing Trendz settings is only available for Linux systems.");
                return;
            }
            Scanner inputStream = new Scanner(System.in);
            String dbUrl = this.envDbUrl;
            String dbUser = this.envDbUserName;
            String dbPassword = this.envDbPassword;
            System.out.println("* Welcome to Trendz Analytics installation!");
            System.out.println("Please, enter necessary info or leave empty value and default value will be used (in brackets).");
            if (!System.getenv().containsKey("SPRING_DATASOURCE_URL")) {
                System.out.print("Enter your Postgres url [" + dbUrl + "]: ");
                dbUrl = this.returnNonEmptyString(inputStream, dbUrl);
            }
            if (!System.getenv().containsKey("SPRING_DATASOURCE_USERNAME")) {
                System.out.print("Enter your Postgres user [" + dbUser + "]: ");
                dbUser = this.returnNonEmptyString(inputStream, dbUser);
            }
            if (!System.getenv().containsKey("SPRING_DATASOURCE_PASSWORD")) {
                System.out.print("Enter your Postgres password [" + dbPassword + "]: ");
                dbPassword = this.returnNonEmptyString(inputStream, dbPassword);
            }
            System.out.println("Applying given configs....");
            Path trendzConfigFilePath = Path.of(TRENDZ_CONFIG_FILE_PATH, new String[0]);
            String content = Files.readString(trendzConfigFilePath);
            if (!System.getenv().containsKey("SPRING_DATASOURCE_URL")) {
                content = content.replaceAll("[# ]{0,2}export SPRING_DATASOURCE_URL=[^\\n]*\\n", "export SPRING_DATASOURCE_URL=" + dbUrl + "\n");
            }
            if (!System.getenv().containsKey("SPRING_DATASOURCE_USERNAME")) {
                content = content.replaceAll("[# ]{0,2}export SPRING_DATASOURCE_USERNAME=[^\\n]*\\n", "export SPRING_DATASOURCE_USERNAME=" + dbUser + "\n");
            }
            if (!System.getenv().containsKey("SPRING_DATASOURCE_PASSWORD")) {
                content = content.replaceAll("[# ]{0,2}export SPRING_DATASOURCE_PASSWORD=[^\\n]*\\n", "export SPRING_DATASOURCE_PASSWORD=" + dbPassword + "\n");
            }
            Files.writeString(trendzConfigFilePath, (CharSequence)content, new OpenOption[0]);
            updateConnectionInfoCallback.accept((Object)dbUrl, (Object)dbUser, (Object)dbPassword);
        }
        catch (Exception e) {
            log.error("Installing Trendz Settings was failed. Please, check configurations manually.", (Throwable)e);
        }
    }

    private String returnNonEmptyString(Scanner inputStream, String defaultValue) {
        String buffer = inputStream.nextLine();
        if (buffer == null || buffer.isEmpty()) {
            return defaultValue;
        }
        return buffer;
    }
}

