/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.install;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.dao.TimeStampUUIDGenerator;
import org.thingsboard.trendz.dao.calculation.CalculationFieldTaskDataDto;
import org.thingsboard.trendz.dao.task.TaskDto;
import org.thingsboard.trendz.dao.task.TaskSchedulingStateRecordDto;
import org.thingsboard.trendz.dao.task.TaskState;
import org.thingsboard.trendz.domain.assistance.agent.AiAgentType;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationUnit;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.service.task.job.AnomalyModelBuildJob;
import org.thingsboard.trendz.service.task.job.AnomalyModelRefreshJob;
import org.thingsboard.trendz.service.task.job.AnomalyModelReprocessJob;
import org.thingsboard.trendz.service.task.job.CacheRefreshJob;
import org.thingsboard.trendz.service.task.job.FilterRequestJob;
import org.thingsboard.trendz.service.task.job.SaveTelemetryToTbJob;
import org.thingsboard.trendz.service.task.job.ViewReportBuildJob;
import org.thingsboard.trendz.service.task.model.TaskJobType;
import org.thingsboard.trendz.service.task.model.TaskReference;
import org.thingsboard.trendz.service.task.model.TaskReferencedEntityType;
import org.thingsboard.trendz.service.task.model.TaskRetryPolicy;
import org.thingsboard.trendz.service.task.model.TaskSchedule;
import org.thingsboard.trendz.service.task.model.TaskScheduleType;
import org.thingsboard.trendz.service.task.model.TaskTimeoutConfig;
import org.thingsboard.trendz.tools.json.JsonUtils;

@Service
@Profile(value={"install"})
public class EntityDatabaseSchemaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntityDatabaseSchemaService.class);
    private static final String SQL_DIR = "sql-install";
    private static final String PROMPTS_DIR = "prompts";
    private static final String UPGRADE_DIR = "sql-upgrade";
    private static final String schemaSql = "schema-entities.sql";
    private static final String schemaIdxSql = "schema-entities-idx.sql";
    private static final String initialDataSql = "initial-data.sql";
    private static final String schemaUpdateSql = "schema_update.sql";
    private final String dataDir;

    @Autowired
    public EntityDatabaseSchemaService(@Value(value="${install.data_dir:}") String dataDir) {
        if (StringUtils.isBlank((CharSequence)dataDir)) {
            throw new RuntimeException("data_dir is blank");
        }
        this.dataDir = dataDir;
    }

    public void createDatabaseSchema(Connection connection) throws Exception {
        log.info("Installing DataBase schema for entities...");
        log.info("Installing SQL DataBase schema part: schema-entities.sql");
        Path schemaFile = Paths.get(this.dataDir, SQL_DIR, schemaSql);
        String schemaScript = this.loadFileContent(schemaFile);
        this.launchScript(connection, schemaScript);
        log.info("Installing SQL DataBase schema indexes part: schema-entities-idx.sql");
        Path schemaIdxFile = Paths.get(this.dataDir, SQL_DIR, schemaIdxSql);
        String schemaIdxScript = this.loadFileContent(schemaIdxFile);
        this.launchScript(connection, schemaIdxScript);
        log.info("Installing initial data by script: initial-data.sql");
        Path initialDataFile = Paths.get(this.dataDir, SQL_DIR, initialDataSql);
        String initialDataScript = this.loadFileContent(initialDataFile);
        this.launchScript(connection, initialDataScript);
    }

    public void upgradeDatabase(Connection connection, String fromVersion) {
        log.info("DB update started ...");
        try {
            switch (fromVersion) {
                case "1.7.0": {
                    this.upgradeDatabase_1_7_0(connection);
                    break;
                }
                case "1.8.0": {
                    this.upgradeDatabase_1_8_0(connection);
                    break;
                }
                case "1.9.0": {
                    this.upgradeDatabase_1_9_0(connection);
                    break;
                }
                case "1.9.1": {
                    this.upgradeDatabase_1_9_1(connection);
                    break;
                }
                case "1.9.2": {
                    this.upgradeDatabase_1_9_2(connection);
                    break;
                }
                case "1.10.0": {
                    this.upgradeDatabase_1_10_0(connection);
                    break;
                }
                case "1.10.1": {
                    this.upgradeDatabase_1_10_1(connection);
                    break;
                }
                case "1.10.2": {
                    this.upgradeDatabase_1_10_2(connection);
                    break;
                }
                case "1.10.3": {
                    this.upgradeDatabase_1_10_3(connection);
                    break;
                }
                case "1.11.0": {
                    this.upgradeDatabase_1_11_0(connection);
                    break;
                }
                case "1.11.1": {
                    this.upgradeDatabase_1_11_1(connection);
                    break;
                }
                case "1.11.2": {
                    this.upgradeDatabase_1_11_2(connection);
                    break;
                }
                case "1.12.0": {
                    this.upgradeDatabase_1_12_0(connection);
                    break;
                }
                case "1.12.1": {
                    this.upgradeDatabase_1_12_1(connection);
                    break;
                }
                case "1.12.2": {
                    this.upgradeDatabase_1_12_2(connection);
                    break;
                }
                case "1.12.3": {
                    this.upgradeDatabase_1_12_3(connection);
                    break;
                }
                case "1.13.0": {
                    this.upgradeDatabase_1_13_0(connection);
                    break;
                }
                case "1.13.1": {
                    this.upgradeDatabase_1_13_1(connection);
                    break;
                }
                case "1.13.2": {
                    this.upgradeDatabase_1_13_2(connection);
                    break;
                }
                case "1.13.3": {
                    this.upgradeDatabase_1_13_3(connection);
                    break;
                }
                case "1.14.0": {
                    this.upgradeDatabase_1_14_0(connection);
                    break;
                }
                case "1.15.0": {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported version for DB upgrade: " + fromVersion);
                }
            }
        }
        catch (Exception e) {
            log.error("Error during upgrading the database!", (Throwable)e);
            throw new IllegalStateException("Error during upgrading the database!", e);
        }
        log.info("DB update finished!");
    }

    public Optional<String> readDatabaseVersion(Connection connection) {
        try {
            String sql = "SELECT property_value FROM trendz_system_property WHERE property_key = 'database_version';";
            ResultSet resultset = connection.createStatement().executeQuery(sql);
            boolean one = false;
            String value = null;
            while (resultset.next()) {
                if (one) {
                    throw new IllegalStateException("DS is inconsistent, 'database_version' key repeats.");
                }
                one = true;
                value = resultset.getString("property_value");
            }
            return Optional.ofNullable(value);
        }
        catch (Exception e) {
            log.warn("The database version is not defined in the current DB.");
            return Optional.empty();
        }
    }

    public void writeDatabaseVersion(Connection connection, String version) {
        Optional databaseVersion = this.readDatabaseVersion(connection);
        try {
            String sql = databaseVersion.isPresent() ? "UPDATE trendz_system_property SET property_value = '" + version + "' WHERE property_key = 'database_version';" : "INSERT INTO trendz_system_property (property_key, property_value) VALUES ('database_version', '" + version + "');";
            connection.createStatement().execute(sql);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cant update database version.", e);
        }
    }

    public void installPgCrypto(Connection connection) throws SQLException {
        this.launchScript(connection, "DO\n$$\nBEGIN\n  IF EXISTS (\n    SELECT 1\n      FROM pg_available_extensions\n     WHERE name = 'pgcrypto'\n  ) THEN\n    CREATE EXTENSION IF NOT EXISTS pgcrypto;\n  END IF;\nEND;\n$$;\n");
    }

    public void installAiAssistantPrompts(Connection connection) throws IOException, SQLException {
        log.info("Installing AI Assistant Prompts is started!");
        HashMap<String, String> nameToPromptMap = new HashMap<String, String>();
        for (AiAgentType aiAgentType : AiAgentType.values()) {
            String filename = "%s.txt".formatted(aiAgentType.name());
            Path path = Paths.get(this.dataDir, PROMPTS_DIR, filename);
            String prompt = this.loadFileContent(path);
            nameToPromptMap.put(aiAgentType.name(), prompt.replace('\'', '\"'));
        }
        String initData = nameToPromptMap.entrySet().stream().map(entry -> "('%s', '%s')".formatted(entry.getKey(), entry.getValue())).collect(Collectors.joining(", "));
        String script = "INSERT INTO agent_ai (id, agent_type, system_message, version)\nSELECT gen_random_uuid() AS id, agent_type, system_message, COALESCE((SELECT MAX(version) FROM agent_ai WHERE agent_type = agent_list.agent_type), 0) + 1 AS version\nFROM (VALUES %s) AS agent_list(agent_type, system_message)\nWHERE NOT EXISTS (\n    SELECT 1\n    FROM agent_ai aa\n    WHERE aa.agent_type = agent_list.agent_type\n        AND aa.system_message = agent_list.system_message\n);\n".formatted(initData);
        this.launchScript(connection, script);
        log.info("Installing AI Assistant Prompts is finished!");
    }

    public void resetSync(Connection connection) throws SQLException {
        log.info("Trendz sync reset is started!");
        String script = "DELETE FROM trendz_system_property\nWHERE property_key = 'tb_configuration';\n";
        this.launchScript(connection, script);
        log.info("Trendz sync reset is finished!");
    }

    private void upgradeDatabase_1_7_0(Connection connection) throws SQLException, IOException {
        this.applyUpdateScriptFromVersion(connection, "1.7.0");
    }

    private void upgradeDatabase_1_8_0(Connection connection) throws SQLException, IOException {
        this.applyUpdateScriptFromVersion(connection, "1.8.0");
        this.launchClearCacheScript(connection);
    }

    private void upgradeDatabase_1_9_0(Connection connection) throws SQLException, IOException {
        this.applyUpdateScriptFromVersion(connection, "1.9.0");
        this.fixDeltaAggregation(connection);
        this.launchClearCacheScript(connection);
    }

    private void upgradeDatabase_1_9_1(Connection connection) throws SQLException, IOException {
        this.applyUpdateScriptFromVersion(connection, "1.9.1");
        this.setBeIdToDatasetConfig(connection);
        this.launchClearCacheScript(connection);
    }

    private void upgradeDatabase_1_9_2(Connection connection) throws SQLException, IOException {
        this.applyUpdateScriptFromVersion(connection, "1.9.2");
        this.launchClearCacheScript(connection);
    }

    private void upgradeDatabase_1_10_0(Connection connection) throws SQLException, IOException {
        this.applyUpdateScriptFromVersion(connection, "1.10.0");
        this.launchClearCacheScript(connection);
    }

    private void upgradeDatabase_1_10_1(Connection connection) throws SQLException, IOException {
        this.applyUpdateScriptFromVersion(connection, "1.10.1");
        this.launchClearCacheScript(connection);
    }

    private void upgradeDatabase_1_10_2(Connection connection) throws SQLException, IOException {
        this.applyUpdateScriptFromVersion(connection, "1.10.2");
        this.launchClearCacheScript(connection);
    }

    private void upgradeDatabase_1_10_3(Connection connection) throws SQLException, IOException {
        this.applyUpdateScriptFromVersion(connection, "1.10.3");
        this.createTasks(connection);
        this.launchClearCacheScript(connection);
    }

    private void upgradeDatabase_1_11_0(Connection connection) throws SQLException, IOException {
        this.applyUpdateScriptFromVersion(connection, "1.11.0");
        this.launchClearCacheScript(connection);
    }

    private void upgradeDatabase_1_11_1(Connection connection) throws SQLException, IOException {
        this.applyUpdateScriptFromVersion(connection, "1.11.1");
        this.launchClearCacheScript(connection);
    }

    private void upgradeDatabase_1_11_2(Connection connection) throws SQLException, IOException {
        this.applyUpdateScriptFromVersion(connection, "1.11.2");
        this.fixCalculationFieldTaskData(connection);
        this.fixCalculationFieldScheduledJob(connection);
        this.launchClearCacheScript(connection);
        this.launchClearTaskExecutions(connection);
    }

    private void upgradeDatabase_1_12_0(Connection connection) throws SQLException, IOException {
        this.applyUpdateScriptFromVersion(connection, "1.12.0");
    }

    private void upgradeDatabase_1_12_1(Connection connection) throws SQLException, IOException {
        this.applyUpdateScriptFromVersion(connection, "1.12.1");
    }

    private void upgradeDatabase_1_12_2(Connection connection) throws SQLException, IOException {
        this.applyUpdateScriptFromVersion(connection, "1.12.2");
    }

    private void upgradeDatabase_1_12_3(Connection connection) throws SQLException, IOException {
        this.applyUpdateScriptFromVersion(connection, "1.12.3");
    }

    private void upgradeDatabase_1_13_0(Connection connection) throws SQLException, IOException {
        this.applyUpdateScriptFromVersion(connection, "1.13.0");
    }

    private void upgradeDatabase_1_13_1(Connection connection) throws IOException, SQLException {
        this.applyUpdateScriptFromVersion(connection, "1.13.1");
    }

    private void upgradeDatabase_1_13_2(Connection connection) throws IOException, SQLException {
        this.applyUpdateScriptFromVersion(connection, "1.13.2");
    }

    private void upgradeDatabase_1_13_3(Connection connection) throws IOException, SQLException {
        this.applyUpdateScriptFromVersion(connection, "1.13.3");
    }

    private void upgradeDatabase_1_14_0(Connection connection) throws IOException, SQLException {
        this.applyUpdateScriptFromVersion(connection, "1.14.0");
    }

    private void applyUpdateScriptFromVersion(Connection connection, String fromVersion) throws IOException, SQLException {
        log.info("DB schema update started ...");
        Path schemaUpdateFile = Paths.get(this.dataDir, UPGRADE_DIR, fromVersion, schemaUpdateSql);
        String schemaUpdateScript = this.loadFileContent(schemaUpdateFile);
        this.launchScript(connection, schemaUpdateScript);
        log.info("DB schema update finished!");
    }

    private void launchClearCacheScript(Connection connection) throws SQLException {
        log.info("Deleting DB telemetry caches...");
        this.launchScript(connection, "DELETE FROM cached_telemetry_point;");
        this.launchScript(connection, "DELETE FROM cached_telemetry;");
        log.info("Deleting DB telemetry caches is finished!");
    }

    private void launchClearTaskExecutions(Connection connection) throws SQLException {
        log.info("Deleting old task executions...");
        this.launchScript(connection, "DELETE FROM trendz_task_execution te WHERE te.status <> 'CREATED' AND te.status <> 'RUNNING';");
        log.info("Deleting old task executions is finished!");
    }

    private void fixDeltaAggregation(Connection connection) throws SQLException {
        log.info("Fixing delta aggregation...");
        Pattern deltaPattern = Pattern.compile("delta\\([\\w\\s\\-]+\\.[\\w\\s\\-]+\\)");
        String usedAggregation = "sum";
        List pairs = this.loadAllViewFieldIdsWithCode(connection);
        int allFieldsCount = pairs.size();
        int fixedFieldsCount = 0;
        for (Pair pair : pairs) {
            String code = (String)pair.getRight();
            ArrayList<String> deltaSamples = new ArrayList<String>();
            Matcher matcherLine = deltaPattern.matcher(code);
            while (matcherLine.find()) {
                String sample = matcherLine.group();
                deltaSamples.add(sample);
            }
            if (deltaSamples.isEmpty()) continue;
            ++fixedFieldsCount;
            for (String deltaSample : deltaSamples) {
                String newSample = deltaSample.replaceAll("delta", usedAggregation);
                code = code.replace(deltaSample, newSample);
            }
            this.updateViewFieldCodeById(connection, pair);
        }
        log.info("Fixing delta aggregation finished! Fixes {} fields of general count {}", (Object)fixedFieldsCount, (Object)allFieldsCount);
    }

    private List<Pair<UUID, String>> loadAllViewFieldIdsWithCode(Connection connection) throws SQLException {
        ArrayList<Pair<UUID, String>> result = new ArrayList<Pair<UUID, String>>();
        String sql = "SELECT vf.id, vf.calc_function FROM view_field vf WHERE vf.calculated_field = true";
        ResultSet resultset = connection.createStatement().executeQuery(sql);
        while (resultset.next()) {
            UUID id = UUID.fromString(resultset.getString("id"));
            String code = resultset.getString("calc_function");
            result.add((Pair<UUID, String>)Pair.of((Object)id, (Object)code));
        }
        return result;
    }

    private void updateViewFieldCodeById(Connection connection, Pair<UUID, String> pair) throws SQLException {
        UUID id = (UUID)pair.getLeft();
        String code = (String)pair.getRight();
        String sql = "UPDATE view_field vf SET vf.calc_function = '" + code + "', vf.use_delta = true WHERE vf.id = '" + String.valueOf(id) + "';";
        connection.createStatement().execute(sql);
    }

    private void setBeIdToDatasetConfig(Connection connection) throws SQLException {
        log.info("Setting BE ID to dataset configs...");
        Set uuids = this.readAllDatasetConfigId(connection);
        for (UUID id : uuids) {
            this.setDatasetBeId(connection, id);
        }
        log.info("Setting BE ID finished! Count {}", (Object)uuids.size());
    }

    private Set<UUID> readAllDatasetConfigId(Connection connection) throws SQLException {
        HashSet<UUID> result = new HashSet<UUID>();
        String sql = "SELECT dc.id FROM dataset_config dc WHERE dc.id IN (SELECT cm.dataset_config_id FROM cluster_model cm WHERE cm.status = 'READY')";
        ResultSet resultset = connection.createStatement().executeQuery(sql);
        while (resultset.next()) {
            UUID id = UUID.fromString(resultset.getString("id"));
            result.add(id);
        }
        return result;
    }

    private void setDatasetBeId(Connection connection, UUID datasetId) throws SQLException {
        String sqlFind = "SELECT business_entity_id FROM view_field WHERE dataset_config_id = '" + String.valueOf(datasetId) + "'";
        ResultSet resultset = connection.createStatement().executeQuery(sqlFind);
        if (!resultset.next()) {
            throw new RuntimeException("No field was found for dataset, id = " + String.valueOf(datasetId));
        }
        UUID beId = UUID.fromString(resultset.getString("business_entity_id"));
        String sqlWrite = "UPDATE dataset_config SET business_entity_id = '" + String.valueOf(beId) + "' WHERE id = '" + String.valueOf(datasetId) + "'";
        connection.createStatement().execute(sqlWrite);
    }

    private void createTasks(Connection connection) throws SQLException {
        if (!this.checkTablesExistence(connection)) {
            return;
        }
        ArrayList result = new ArrayList();
        result.addAll(this.remakeScheduledTasks(connection));
        result.addAll(this.createViewConfigTasks(connection));
        result.addAll(this.createModelTasks(connection));
        this.writeNewTask(connection, result);
    }

    private boolean checkTablesExistence(Connection connection) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        String[] types = new String[]{"TABLE"};
        List<String> tableNames = Arrays.asList("scheduled_task", "scheduled_job");
        boolean allTablesExist = true;
        for (String tableName : tableNames) {
            ResultSet resultSet = metaData.getTables(null, null, tableName, types);
            try {
                if (resultSet.next()) continue;
                allTablesExist = false;
                log.warn("The table does not exist = {}, skip task creation.", (Object)tableName);
            }
            finally {
                if (resultSet == null) continue;
                resultSet.close();
            }
        }
        log.info("The old task tables exist, start task creation.");
        return allTablesExist;
    }

    private List<Pair<TaskDto, TaskSchedulingStateRecordDto>> remakeScheduledTasks(Connection connection) throws SQLException {
        List tasksRaw = this.getRawScheduledTasks(connection);
        return this.mapScheduledTasksToTasks(tasksRaw);
    }

    private List<Map<String, Object>> getRawScheduledTasks(Connection connection) throws SQLException {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        String sql = "SELECT st.id AS st_id, st.tenant_id AS st_tenant_id, st.customer_id AS st_customer_id, st.user_id AS st_user_id, st.enabled AS st_enabled, st.initial_delay AS st_initial_delay, st.regular_delay AS st_regular_delay, st.delay_time_unit AS st_delay_time_unit, st.status AS st_status, st.last_update_time AS st_last_update_time, sj.id AS sj_id, sj.task_id AS sj_task_id, sj.json_data AS sj_json_data FROM scheduled_task st JOIN scheduled_job sj ON st.id = sj.task_id";
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(sql);){
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            while (resultSet.next()) {
                HashMap<String, Object> rowMap = new HashMap<String, Object>();
                for (int i = 1; i <= columnCount; ++i) {
                    rowMap.put(metaData.getColumnLabel(i), resultSet.getObject(i));
                }
                resultList.add(rowMap);
            }
        }
        return resultList;
    }

    private List<Pair<TaskDto, TaskSchedulingStateRecordDto>> mapScheduledTasksToTasks(List<Map<String, Object>> tasks) {
        ArrayList<Pair<TaskDto, TaskSchedulingStateRecordDto>> result = new ArrayList<Pair<TaskDto, TaskSchedulingStateRecordDto>>();
        long now = System.currentTimeMillis();
        for (Map<String, Object> task : tasks) {
            TaskReferencedEntityType referenceType;
            AnomalyModelRefreshJob job;
            String jobType;
            String rawJob = (String)task.get("sj_json_data");
            JsonNode jobNode = JsonUtils.toNodeFromRaw((String)rawJob);
            String jobClassName = jobNode.get("@class").asText();
            String referenceId = switch (jobType = jobClassName.substring(jobClassName.lastIndexOf(46) + 1)) {
                case "TbDataSavingJob" -> {
                    UUID viewConfigIdSave = UUID.fromString(jobNode.get("viewConfigId").asText());
                    long lastExecutionTime = jobNode.get("lastExecutionTime").asLong();
                    job = SaveTelemetryToTbJob.builder().viewConfigId(viewConfigIdSave).lastExecutionTime(lastExecutionTime).build();
                    referenceType = TaskReferencedEntityType.VIEW_CONFIG_SAVE_TO_TB_TASK;
                    yield viewConfigIdSave.toString();
                }
                case "CacheRefreshJob" -> {
                    UUID viewConfigIdCache = UUID.fromString(jobNode.get("viewConfigId").asText());
                    long lastRefreshTime = jobNode.get("lastRefreshTime").asLong();
                    job = CacheRefreshJob.builder().viewConfigId(viewConfigIdCache).lastRefreshTime(lastRefreshTime).build();
                    referenceType = TaskReferencedEntityType.VIEW_CONFIG_CACHE_TASK;
                    yield viewConfigIdCache.toString();
                }
                case "AnomalyJob" -> {
                    UUID modelId = UUID.fromString(jobNode.get("modelId").asText());
                    job = AnomalyModelRefreshJob.builder().modelId(modelId).build();
                    referenceType = TaskReferencedEntityType.ANOMALY_MODEL_REPROCESS;
                    yield modelId.toString();
                }
                default -> throw new IllegalArgumentException("Unsupported job type: " + jobType);
            };
            long regularDelay = (Long)task.get("st_regular_delay");
            String timeUnit = (String)task.get("st_delay_time_unit");
            TaskSchedule schedule = this.getPeriodMs(regularDelay, timeUnit);
            ObjectNode node = JsonUtils.getObjectMapper().createObjectNode();
            node.set("timeoutConfig", JsonUtils.toNodeFromObject((Object)TaskTimeoutConfig.getDefault()));
            node.set("retryPolicy", JsonUtils.toNodeFromObject((Object)TaskRetryPolicy.getDefault()));
            String jsonConfigs = JsonUtils.fromNodeToRaw((JsonNode)node);
            TaskDto taskDto = TaskDto.builder().id((UUID)task.get("st_id")).tenantId((UUID)task.get("st_tenant_id")).customerId((UUID)task.get("st_customer_id")).userId((UUID)task.get("st_user_id")).createdTs(now).updatedTs(now).name("Migrated scheduled task: " + jobType).enabled(((Boolean)task.get("st_enabled")).booleanValue()).reference(new TaskReference(referenceType, referenceId)).jobType(job.getJobType()).jsonJob(JsonUtils.toJson((Object)job)).scheduleType(schedule.getType()).schedulePeriodTs(schedule.getPeriodMs()).schedulePlannedTs(schedule.getPlannedTs()).ttlEnabled(false).ttlDuration(0L).jsonConfigs(jsonConfigs).taskExecutions(null).build();
            TaskSchedulingStateRecordDto recordDto = TaskSchedulingStateRecordDto.builder().taskId((UUID)task.get("st_id")).state(TaskState.FREE).lastFinishTs(((Long)task.get("st_last_update_time")).longValue()).build();
            result.add((Pair<TaskDto, TaskSchedulingStateRecordDto>)Pair.of((Object)taskDto, (Object)recordDto));
        }
        return result;
    }

    private List<Pair<TaskDto, TaskSchedulingStateRecordDto>> createViewConfigTasks(Connection connection) throws SQLException {
        List viewConfigs = this.loadAllViewConfigs(connection);
        ArrayList<Pair<TaskDto, TaskSchedulingStateRecordDto>> result = new ArrayList<Pair<TaskDto, TaskSchedulingStateRecordDto>>();
        for (Map viewConfig : viewConfigs) {
            result.add((Pair<TaskDto, TaskSchedulingStateRecordDto>)this.createViewReportBuildTask(viewConfig));
            result.add((Pair<TaskDto, TaskSchedulingStateRecordDto>)this.createViewReportFilterOptionTask(viewConfig));
        }
        return result;
    }

    private List<Map<String, Object>> loadAllViewConfigs(Connection connection) throws SQLException {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        String sql = "SELECT vc.id , vc.name, vc.tenant_id, vc.customer_id FROM view_config vc";
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(sql);){
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            while (resultSet.next()) {
                HashMap<String, Object> rowMap = new HashMap<String, Object>();
                for (int i = 1; i <= columnCount; ++i) {
                    rowMap.put(metaData.getColumnLabel(i), resultSet.getObject(i));
                }
                resultList.add(rowMap);
            }
        }
        return resultList;
    }

    private Pair<TaskDto, TaskSchedulingStateRecordDto> createViewReportBuildTask(Map<String, Object> viewConfig) {
        long now = System.currentTimeMillis();
        UUID taskId = TimeStampUUIDGenerator.generateId();
        UUID viewConfigId = (UUID)viewConfig.get("id");
        String viewConfigName = (String)viewConfig.get("name");
        UUID tenantId = (UUID)viewConfig.get("tenant_id");
        UUID customerId = (UUID)viewConfig.get("customer_id");
        String name = "View config, build: " + viewConfigName;
        ObjectNode node = JsonUtils.getObjectMapper().createObjectNode();
        node.set("timeoutConfig", JsonUtils.toNodeFromObject((Object)TaskTimeoutConfig.getDefault()));
        node.set("retryPolicy", JsonUtils.toNodeFromObject((Object)TaskRetryPolicy.getDefault()));
        String jsonConfigs = JsonUtils.fromNodeToRaw((JsonNode)node);
        TaskDto taskDto = TaskDto.builder().id(taskId).tenantId(tenantId).customerId(customerId).userId(EntityId.NULL_UUID).createdTs(now).updatedTs(now).name(name).enabled(true).reference(new TaskReference(TaskReferencedEntityType.VIEW_CONFIG_BUILD_VIEW, viewConfigId.toString())).jobType(TaskJobType.VIEW_REPORT_BUILD).jsonJob(JsonUtils.toJson((Object)new ViewReportBuildJob())).scheduleType(TaskScheduleType.NONE).schedulePeriodTs(0L).schedulePlannedTs(0L).ttlEnabled(false).ttlDuration(0L).jsonConfigs(jsonConfigs).taskExecutions(null).build();
        TaskSchedulingStateRecordDto recordDto = TaskSchedulingStateRecordDto.builder().taskId(taskId).state(TaskState.FREE).lastFinishTs(0L).build();
        return Pair.of((Object)taskDto, (Object)recordDto);
    }

    private Pair<TaskDto, TaskSchedulingStateRecordDto> createViewReportFilterOptionTask(Map<String, Object> viewConfig) {
        long now = System.currentTimeMillis();
        UUID taskId = TimeStampUUIDGenerator.generateId();
        UUID viewConfigId = (UUID)viewConfig.get("id");
        String viewConfigName = (String)viewConfig.get("name");
        UUID tenantId = (UUID)viewConfig.get("tenant_id");
        UUID customerId = (UUID)viewConfig.get("customer_id");
        String name = "View config, filter: " + viewConfigName;
        ObjectNode node = JsonUtils.getObjectMapper().createObjectNode();
        node.set("timeoutConfig", JsonUtils.toNodeFromObject((Object)TaskTimeoutConfig.getDefault()));
        node.set("retryPolicy", JsonUtils.toNodeFromObject((Object)TaskRetryPolicy.getDefault()));
        String jsonConfigs = JsonUtils.fromNodeToRaw((JsonNode)node);
        TaskDto taskDto = TaskDto.builder().id(taskId).tenantId(tenantId).customerId(customerId).userId(EntityId.NULL_UUID).createdTs(now).updatedTs(now).name(name).enabled(true).reference(new TaskReference(TaskReferencedEntityType.VIEW_CONFIG_FILTER_REQUEST, viewConfigId.toString())).jobType(TaskJobType.FILTER_REQUEST).jsonJob(JsonUtils.toJson((Object)new FilterRequestJob())).scheduleType(TaskScheduleType.NONE).schedulePeriodTs(0L).schedulePlannedTs(0L).ttlEnabled(true).ttlDuration(60000L).jsonConfigs(jsonConfigs).taskExecutions(null).build();
        TaskSchedulingStateRecordDto recordDto = TaskSchedulingStateRecordDto.builder().taskId(taskId).state(TaskState.FREE).lastFinishTs(0L).build();
        return Pair.of((Object)taskDto, (Object)recordDto);
    }

    private List<Pair<TaskDto, TaskSchedulingStateRecordDto>> createModelTasks(Connection connection) throws SQLException {
        List models = this.loadAllModels(connection);
        ArrayList<Pair<TaskDto, TaskSchedulingStateRecordDto>> result = new ArrayList<Pair<TaskDto, TaskSchedulingStateRecordDto>>();
        for (Map model : models) {
            result.add((Pair<TaskDto, TaskSchedulingStateRecordDto>)this.createModelBuildTask(model));
            result.add((Pair<TaskDto, TaskSchedulingStateRecordDto>)this.createModelFindAnomalyTask(model));
            result.add((Pair<TaskDto, TaskSchedulingStateRecordDto>)this.createModelAutodiscoveryTask(model));
        }
        return result;
    }

    private List<Map<String, Object>> loadAllModels(Connection connection) throws SQLException {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        String sql = "SELECT cm.id , cm.name, cm.tenant_id, cm.customer_id FROM cluster_model cm";
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(sql);){
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            while (resultSet.next()) {
                HashMap<String, Object> rowMap = new HashMap<String, Object>();
                for (int i = 1; i <= columnCount; ++i) {
                    rowMap.put(metaData.getColumnLabel(i), resultSet.getObject(i));
                }
                resultList.add(rowMap);
            }
        }
        return resultList;
    }

    private Pair<TaskDto, TaskSchedulingStateRecordDto> createModelBuildTask(Map<String, Object> model) {
        long now = System.currentTimeMillis();
        UUID taskId = TimeStampUUIDGenerator.generateId();
        UUID modelId = (UUID)model.get("id");
        String modelName = (String)model.get("name");
        UUID tenantId = (UUID)model.get("tenant_id");
        UUID customerId = (UUID)model.get("customer_id");
        String name = "Anomaly, build model: " + modelName;
        ObjectNode node = JsonUtils.getObjectMapper().createObjectNode();
        node.set("timeoutConfig", JsonUtils.toNodeFromObject((Object)TaskTimeoutConfig.getDefault()));
        node.set("retryPolicy", JsonUtils.toNodeFromObject((Object)TaskRetryPolicy.getDefault()));
        String jsonConfigs = JsonUtils.fromNodeToRaw((JsonNode)node);
        TaskDto taskDto = TaskDto.builder().id(taskId).tenantId(tenantId).customerId(customerId).userId(EntityId.NULL_UUID).createdTs(now).updatedTs(now).name(name).enabled(true).reference(new TaskReference(TaskReferencedEntityType.ANOMALY_MODEL_BUILD, modelId.toString())).jobType(TaskJobType.ANOMALY_MODEL_BUILD).jsonJob(JsonUtils.toJson((Object)new AnomalyModelBuildJob())).scheduleType(TaskScheduleType.NONE).schedulePeriodTs(0L).schedulePlannedTs(0L).ttlEnabled(false).ttlDuration(0L).jsonConfigs(jsonConfigs).taskExecutions(null).build();
        TaskSchedulingStateRecordDto recordDto = TaskSchedulingStateRecordDto.builder().taskId(taskId).state(TaskState.FREE).lastFinishTs(0L).build();
        return Pair.of((Object)taskDto, (Object)recordDto);
    }

    private Pair<TaskDto, TaskSchedulingStateRecordDto> createModelFindAnomalyTask(Map<String, Object> model) {
        long now = System.currentTimeMillis();
        UUID taskId = TimeStampUUIDGenerator.generateId();
        UUID modelId = (UUID)model.get("id");
        String modelName = (String)model.get("name");
        UUID tenantId = (UUID)model.get("tenant_id");
        UUID customerId = (UUID)model.get("customer_id");
        String name = "Anomaly, find new anomalies: " + modelName;
        ObjectNode node = JsonUtils.getObjectMapper().createObjectNode();
        node.set("timeoutConfig", JsonUtils.toNodeFromObject((Object)TaskTimeoutConfig.getDefault()));
        node.set("retryPolicy", JsonUtils.toNodeFromObject((Object)TaskRetryPolicy.getDefault()));
        String jsonConfigs = JsonUtils.fromNodeToRaw((JsonNode)node);
        TaskDto taskDto = TaskDto.builder().id(taskId).tenantId(tenantId).customerId(customerId).userId(EntityId.NULL_UUID).createdTs(now).updatedTs(now).name(name).enabled(true).reference(new TaskReference(TaskReferencedEntityType.ANOMALY_MODEL_REPROCESS, modelId.toString())).jobType(TaskJobType.ANOMALY_MODEL_REPROCESS).jsonJob(JsonUtils.toJson((Object)new AnomalyModelReprocessJob())).scheduleType(TaskScheduleType.NONE).schedulePeriodTs(0L).schedulePlannedTs(0L).ttlEnabled(false).ttlDuration(0L).jsonConfigs(jsonConfigs).taskExecutions(null).build();
        TaskSchedulingStateRecordDto recordDto = TaskSchedulingStateRecordDto.builder().taskId(taskId).state(TaskState.FREE).lastFinishTs(0L).build();
        return Pair.of((Object)taskDto, (Object)recordDto);
    }

    private Pair<TaskDto, TaskSchedulingStateRecordDto> createModelAutodiscoveryTask(Map<String, Object> model) {
        long now = System.currentTimeMillis();
        UUID taskId = TimeStampUUIDGenerator.generateId();
        UUID modelId = (UUID)model.get("id");
        String modelName = (String)model.get("name");
        UUID tenantId = (UUID)model.get("tenant_id");
        UUID customerId = (UUID)model.get("customer_id");
        String name = "Anomaly, find new anomalies: " + modelName;
        ObjectNode node = JsonUtils.getObjectMapper().createObjectNode();
        node.set("timeoutConfig", JsonUtils.toNodeFromObject((Object)TaskTimeoutConfig.getDefault()));
        node.set("retryPolicy", JsonUtils.toNodeFromObject((Object)TaskRetryPolicy.getDefault()));
        String jsonConfigs = JsonUtils.fromNodeToRaw((JsonNode)node);
        TaskDto taskDto = TaskDto.builder().id(taskId).tenantId(tenantId).customerId(customerId).userId(EntityId.NULL_UUID).createdTs(now).updatedTs(now).name(name).enabled(false).reference(new TaskReference(TaskReferencedEntityType.ANOMALY_MODEL_REFRESH, modelId.toString())).jobType(TaskJobType.ANOMALY_MODEL_REFRESH).jsonJob(JsonUtils.toJson((Object)new AnomalyModelRefreshJob())).scheduleType(TaskScheduleType.PERIODIC).schedulePeriodTs(0L).schedulePlannedTs(0L).ttlEnabled(false).ttlDuration(0L).jsonConfigs(jsonConfigs).taskExecutions(null).build();
        TaskSchedulingStateRecordDto recordDto = TaskSchedulingStateRecordDto.builder().taskId(taskId).state(TaskState.FREE).lastFinishTs(0L).build();
        return Pair.of((Object)taskDto, (Object)recordDto);
    }

    private TaskSchedule getPeriodMs(long regularDelay, String delayTimeUnit) {
        TimeUnit timeUnit = TimeUnit.valueOf(delayTimeUnit);
        long periodMs = timeUnit.toMillis(regularDelay);
        return new TaskSchedule(TaskScheduleType.PERIODIC, periodMs, 0L, ChronoUnit.HOURS, 1, "UTC");
    }

    private boolean isTaskAlreadyExists(Connection connection, String referenceKey, TaskReferencedEntityType type) throws SQLException {
        ArrayList resultList = new ArrayList();
        String sql = String.format("SELECT tt.id FROM trendz_task tt WHERE tt.reference_key = '%s' AND tt.reference_type = '%s' ", referenceKey, type.name());
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(sql);){
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            while (resultSet.next()) {
                HashMap<String, Object> rowMap = new HashMap<String, Object>();
                for (int i = 1; i <= columnCount; ++i) {
                    rowMap.put(metaData.getColumnLabel(i), resultSet.getObject(i));
                }
                resultList.add(rowMap);
            }
        }
        return !resultList.isEmpty();
    }

    private void writeNewTask(Connection connection, List<Pair<TaskDto, TaskSchedulingStateRecordDto>> taskDtos) throws SQLException {
        for (Pair<TaskDto, TaskSchedulingStateRecordDto> taskDtoPair : taskDtos) {
            TaskDto taskDto = (TaskDto)taskDtoPair.getLeft();
            TaskSchedulingStateRecordDto recordDto = (TaskSchedulingStateRecordDto)taskDtoPair.getRight();
            if (this.isTaskAlreadyExists(connection, taskDto.getReference().getKey(), taskDto.getReference().getType())) continue;
            String sqlTask = String.format("INSERT INTO trendz_task (   id, tenant_id, customer_id, user_id, created_ts, updated_ts, name, enabled, reference_type,    reference_key, job_type, json_job, schedule_type, schedule_period_ts, schedule_planned_ts,    ttl_enabled, ttl_duration, json_configs) VALUES ('%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s'); ", taskDto.getId(), this.avoidNullUuid(taskDto.getTenantId()), this.avoidNullUuid(taskDto.getCustomerId()), this.avoidNullUuid(taskDto.getUserId()), taskDto.getCreatedTs(), taskDto.getUpdatedTs(), this.avoidFrenchLetter(taskDto.getName()), taskDto.isEnabled(), taskDto.getReference().getType(), taskDto.getReference().getKey(), taskDto.getJobType(), taskDto.getJsonJob(), taskDto.getScheduleType(), taskDto.getSchedulePeriodTs(), taskDto.getSchedulePlannedTs(), taskDto.isTtlEnabled(), taskDto.getTtlDuration(), taskDto.getJsonConfigs());
            String sqlTaskStateRecord = String.format("INSERT INTO trendz_task_scheduling_state_record (task_id, state, last_finish_ts) VALUES ('%s', '%s', '%s');", recordDto.getTaskId(), recordDto.getState(), recordDto.getLastFinishTs());
            connection.setAutoCommit(false);
            try {
                Statement statement = connection.createStatement();
                try {
                    statement.execute(sqlTask);
                    statement.execute(sqlTaskStateRecord);
                }
                finally {
                    if (statement == null) continue;
                    statement.close();
                }
            }
            catch (SQLException ex) {
                connection.rollback();
                throw ex;
            }
            finally {
                connection.setAutoCommit(true);
            }
        }
    }

    private UUID avoidNullUuid(UUID id) {
        return id == null ? EntityId.NULL_UUID : id;
    }

    private String avoidFrenchLetter(String name) {
        return name.replaceAll("'", "''");
    }

    private void fixCalculationFieldTaskData(Connection connection) throws SQLException {
        Set taskDataDtos = this.readAllCalculationFieldTaskDataDto(connection);
        this.modifyCalculationFieldTaskDataDtos(taskDataDtos);
        this.writeCalculationFieldTaskDataDtos(connection, taskDataDtos);
    }

    private Set<CalculationFieldTaskDataDto> readAllCalculationFieldTaskDataDto(Connection connection) throws SQLException {
        HashSet<CalculationFieldTaskDataDto> result = new HashSet<CalculationFieldTaskDataDto>();
        String sql = "SELECT td.* FROM calculation_field_task_data td WHERE json_item_set IS NULL";
        ResultSet resultset = connection.createStatement().executeQuery(sql);
        while (resultset.next()) {
            UUID id = UUID.fromString(resultset.getString("calculation_field_id"));
            boolean enabled = Boolean.parseBoolean(resultset.getString("enabled"));
            String tzName = resultset.getString("tz_name");
            String jsonItemNameSet = resultset.getString("json_item_name_set");
            String jsonReprocessDatePickerConfig = resultset.getString("json_reprocess_date_picker_config");
            DateAggregationUnit refreshTimeUnit = resultset.getString("refresh_time_unit") == null ? null : DateAggregationUnit.valueOf((String)resultset.getString("refresh_time_unit"));
            int refreshTimeUnitCount = Integer.parseInt(resultset.getString("refresh_time_unit_count"));
            CalculationFieldTaskDataDto taskDataDto = new CalculationFieldTaskDataDto(id, enabled, tzName, jsonItemNameSet, null, jsonReprocessDatePickerConfig, refreshTimeUnit, refreshTimeUnitCount, false);
            result.add(taskDataDto);
        }
        return result;
    }

    private void modifyCalculationFieldTaskDataDtos(Set<CalculationFieldTaskDataDto> taskDataDtos) {
        CollectionType type = JsonUtils.getObjectMapper().getTypeFactory().constructCollectionType(Set.class, String.class);
        for (CalculationFieldTaskDataDto taskDataDto : taskDataDtos) {
            Set itemNameSet = (Set)JsonUtils.fromJson((String)taskDataDto.getJsonItemNameSet(), (JavaType)type);
            Set itemSet = itemNameSet.stream().map(name -> new ItemLite(EntityId.NULL_UUID, name)).collect(Collectors.toSet());
            taskDataDto.setJsonItemSet(JsonUtils.toJson(itemSet));
        }
    }

    private void writeCalculationFieldTaskDataDtos(Connection connection, Set<CalculationFieldTaskDataDto> taskDataDtos) throws SQLException {
        for (CalculationFieldTaskDataDto taskDataDto : taskDataDtos) {
            String sqlUpdate = String.format("UPDATE calculation_field_task_data SET json_item_set='%s' WHERE calculation_field_id = '%s';", this.avoidFrenchLetter(taskDataDto.getJsonItemSet()), taskDataDto.getCalculationFieldId());
            log.debug("Query = {}", (Object)sqlUpdate);
            connection.setAutoCommit(false);
            try {
                Statement statement = connection.createStatement();
                try {
                    statement.execute(sqlUpdate);
                }
                finally {
                    if (statement == null) continue;
                    statement.close();
                }
            }
            catch (SQLException ex) {
                connection.rollback();
                throw ex;
            }
            finally {
                connection.setAutoCommit(true);
            }
        }
    }

    private void fixCalculationFieldScheduledJob(Connection connection) throws SQLException {
        Set jobDataSet = this.readCalculationFieldScheduledJob(connection);
        Set newJobDataSet = this.modifyCalculationFieldScheduledJobs(jobDataSet);
        this.writeCalculationFieldScheduledJobs(connection, newJobDataSet);
    }

    private Set<Pair<UUID, String>> readCalculationFieldScheduledJob(Connection connection) throws SQLException {
        HashSet<Pair<UUID, String>> result = new HashSet<Pair<UUID, String>>();
        String sql = "SELECT tt.id, tt.json_job FROM trendz_task tt WHERE tt.job_type = 'SAVE_CALCULATION_TO_TB'";
        ResultSet resultset = connection.createStatement().executeQuery(sql);
        while (resultset.next()) {
            UUID id = UUID.fromString(resultset.getString("id"));
            String job = resultset.getString("json_job");
            result.add((Pair<UUID, String>)Pair.of((Object)id, (Object)job));
        }
        return result;
    }

    private Set<Pair<UUID, String>> modifyCalculationFieldScheduledJobs(Set<Pair<UUID, String>> jobDataSet) {
        CollectionType type = JsonUtils.getObjectMapper().getTypeFactory().constructCollectionType(Set.class, String.class);
        HashSet<Pair<UUID, String>> result = new HashSet<Pair<UUID, String>>();
        for (Pair<UUID, String> jobData : jobDataSet) {
            UUID taskId = (UUID)jobData.getLeft();
            String jobJson = (String)jobData.getRight();
            ObjectNode jobJsonNode = (ObjectNode)JsonUtils.toNodeFromRaw((String)jobJson);
            if (jobJsonNode.get("filterNames") == null || jobJsonNode.get("filterNames").isNull() || jobJsonNode.get("filterItems") != null) continue;
            String filterNames = jobJsonNode.get("filterNames").toString();
            Set itemNameSet = (Set)JsonUtils.fromJson((String)filterNames, (JavaType)type);
            Set itemSet = itemNameSet.stream().map(name -> new ItemLite(EntityId.NULL_UUID, name)).collect(Collectors.toSet());
            JsonNode jsonItemSet = JsonUtils.toNodeFromObject(itemSet);
            jobJsonNode.set("filterItems", jsonItemSet);
            result.add((Pair<UUID, String>)Pair.of((Object)taskId, (Object)JsonUtils.fromNodeToRaw((JsonNode)jobJsonNode)));
        }
        return result;
    }

    private void writeCalculationFieldScheduledJobs(Connection connection, Set<Pair<UUID, String>> jobDataSet) throws SQLException {
        for (Pair<UUID, String> jobData : jobDataSet) {
            UUID taskId = (UUID)jobData.getLeft();
            String jobJson = (String)jobData.getRight();
            String sqlUpdate = String.format("UPDATE trendz_task SET json_job='%s' WHERE id = '%s';", this.avoidFrenchLetter(jobJson), taskId);
            log.debug("Query = {}", (Object)sqlUpdate);
            connection.setAutoCommit(false);
            try {
                Statement statement = connection.createStatement();
                try {
                    statement.execute(sqlUpdate);
                }
                finally {
                    if (statement == null) continue;
                    statement.close();
                }
            }
            catch (SQLException ex) {
                connection.rollback();
                throw ex;
            }
            finally {
                connection.setAutoCommit(true);
            }
        }
    }

    private String loadFileContent(Path pathToFile) throws IOException {
        return Files.readString(pathToFile);
    }

    private void launchScript(Connection connection, String script) throws SQLException {
        connection.createStatement().execute(script);
    }
}

