/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.definition;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.thingsboard.trendz.service.definition.ChangeEntityValidationInfo;
import org.thingsboard.trendz.service.definition.ChangeEntityValidationItem;
import org.thingsboard.trendz.service.definition.ChangeEntityValidationItemType;

public class ChangeEntityValidationInfo {
    private boolean depended;
    private List<String> dependedBusinessEntities;
    private List<String> dependedViewConfigNames;
    private List<String> dependedAnomalyModelNames;
    private List<String> dependedCalculationFieldNames;
    private List<String> dependedPredictionModelNames;

    public ChangeEntityValidationInfo(ChangeEntityValidationInfo that) {
        this.depended = that.depended;
        this.dependedBusinessEntities = that.dependedBusinessEntities == null ? null : new ArrayList(that.dependedBusinessEntities);
        this.dependedViewConfigNames = that.dependedViewConfigNames == null ? null : new ArrayList(that.dependedViewConfigNames);
        this.dependedAnomalyModelNames = that.dependedAnomalyModelNames == null ? null : new ArrayList(that.dependedAnomalyModelNames);
        this.dependedCalculationFieldNames = that.dependedCalculationFieldNames == null ? null : new ArrayList(that.dependedCalculationFieldNames);
        this.dependedPredictionModelNames = that.dependedPredictionModelNames == null ? null : new ArrayList(that.dependedPredictionModelNames);
    }

    public ChangeEntityValidationInfo(Set<ChangeEntityValidationItem> dependencyItemSet) {
        if (dependencyItemSet.isEmpty()) {
            this.depended = false;
        } else {
            Map typeToItemMap = dependencyItemSet.stream().collect(Collectors.groupingBy(ChangeEntityValidationItem::getType, Collectors.mapping(ChangeEntityValidationItem::getName, Collectors.toList())));
            this.depended = true;
            this.dependedBusinessEntities = typeToItemMap.get(ChangeEntityValidationItemType.BUSINESS_ENTITY);
            this.dependedViewConfigNames = typeToItemMap.get(ChangeEntityValidationItemType.VIEW_CONFIG);
            this.dependedAnomalyModelNames = typeToItemMap.get(ChangeEntityValidationItemType.ANOMALY_MODEL);
            this.dependedCalculationFieldNames = typeToItemMap.get(ChangeEntityValidationItemType.CALCULATION_FIELD);
            this.dependedPredictionModelNames = typeToItemMap.get(ChangeEntityValidationItemType.PREDICTION_MODEL);
        }
    }

    @Generated
    public static ChangeEntityValidationInfoBuilder builder() {
        return new ChangeEntityValidationInfoBuilder();
    }

    @Generated
    public boolean isDepended() {
        return this.depended;
    }

    @Generated
    public List<String> getDependedBusinessEntities() {
        return this.dependedBusinessEntities;
    }

    @Generated
    public List<String> getDependedViewConfigNames() {
        return this.dependedViewConfigNames;
    }

    @Generated
    public List<String> getDependedAnomalyModelNames() {
        return this.dependedAnomalyModelNames;
    }

    @Generated
    public List<String> getDependedCalculationFieldNames() {
        return this.dependedCalculationFieldNames;
    }

    @Generated
    public List<String> getDependedPredictionModelNames() {
        return this.dependedPredictionModelNames;
    }

    @Generated
    public void setDepended(boolean depended) {
        this.depended = depended;
    }

    @Generated
    public void setDependedBusinessEntities(List<String> dependedBusinessEntities) {
        this.dependedBusinessEntities = dependedBusinessEntities;
    }

    @Generated
    public void setDependedViewConfigNames(List<String> dependedViewConfigNames) {
        this.dependedViewConfigNames = dependedViewConfigNames;
    }

    @Generated
    public void setDependedAnomalyModelNames(List<String> dependedAnomalyModelNames) {
        this.dependedAnomalyModelNames = dependedAnomalyModelNames;
    }

    @Generated
    public void setDependedCalculationFieldNames(List<String> dependedCalculationFieldNames) {
        this.dependedCalculationFieldNames = dependedCalculationFieldNames;
    }

    @Generated
    public void setDependedPredictionModelNames(List<String> dependedPredictionModelNames) {
        this.dependedPredictionModelNames = dependedPredictionModelNames;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeEntityValidationInfo)) {
            return false;
        }
        ChangeEntityValidationInfo other = (ChangeEntityValidationInfo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isDepended() != other.isDepended()) {
            return false;
        }
        List this$dependedBusinessEntities = this.getDependedBusinessEntities();
        List other$dependedBusinessEntities = other.getDependedBusinessEntities();
        if (this$dependedBusinessEntities == null ? other$dependedBusinessEntities != null : !((Object)this$dependedBusinessEntities).equals(other$dependedBusinessEntities)) {
            return false;
        }
        List this$dependedViewConfigNames = this.getDependedViewConfigNames();
        List other$dependedViewConfigNames = other.getDependedViewConfigNames();
        if (this$dependedViewConfigNames == null ? other$dependedViewConfigNames != null : !((Object)this$dependedViewConfigNames).equals(other$dependedViewConfigNames)) {
            return false;
        }
        List this$dependedAnomalyModelNames = this.getDependedAnomalyModelNames();
        List other$dependedAnomalyModelNames = other.getDependedAnomalyModelNames();
        if (this$dependedAnomalyModelNames == null ? other$dependedAnomalyModelNames != null : !((Object)this$dependedAnomalyModelNames).equals(other$dependedAnomalyModelNames)) {
            return false;
        }
        List this$dependedCalculationFieldNames = this.getDependedCalculationFieldNames();
        List other$dependedCalculationFieldNames = other.getDependedCalculationFieldNames();
        if (this$dependedCalculationFieldNames == null ? other$dependedCalculationFieldNames != null : !((Object)this$dependedCalculationFieldNames).equals(other$dependedCalculationFieldNames)) {
            return false;
        }
        List this$dependedPredictionModelNames = this.getDependedPredictionModelNames();
        List other$dependedPredictionModelNames = other.getDependedPredictionModelNames();
        return !(this$dependedPredictionModelNames == null ? other$dependedPredictionModelNames != null : !((Object)this$dependedPredictionModelNames).equals(other$dependedPredictionModelNames));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChangeEntityValidationInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDepended() ? 79 : 97);
        List $dependedBusinessEntities = this.getDependedBusinessEntities();
        result = result * 59 + ($dependedBusinessEntities == null ? 43 : ((Object)$dependedBusinessEntities).hashCode());
        List $dependedViewConfigNames = this.getDependedViewConfigNames();
        result = result * 59 + ($dependedViewConfigNames == null ? 43 : ((Object)$dependedViewConfigNames).hashCode());
        List $dependedAnomalyModelNames = this.getDependedAnomalyModelNames();
        result = result * 59 + ($dependedAnomalyModelNames == null ? 43 : ((Object)$dependedAnomalyModelNames).hashCode());
        List $dependedCalculationFieldNames = this.getDependedCalculationFieldNames();
        result = result * 59 + ($dependedCalculationFieldNames == null ? 43 : ((Object)$dependedCalculationFieldNames).hashCode());
        List $dependedPredictionModelNames = this.getDependedPredictionModelNames();
        result = result * 59 + ($dependedPredictionModelNames == null ? 43 : ((Object)$dependedPredictionModelNames).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ChangeEntityValidationInfo(depended=" + this.isDepended() + ", dependedBusinessEntities=" + String.valueOf(this.getDependedBusinessEntities()) + ", dependedViewConfigNames=" + String.valueOf(this.getDependedViewConfigNames()) + ", dependedAnomalyModelNames=" + String.valueOf(this.getDependedAnomalyModelNames()) + ", dependedCalculationFieldNames=" + String.valueOf(this.getDependedCalculationFieldNames()) + ", dependedPredictionModelNames=" + String.valueOf(this.getDependedPredictionModelNames()) + ")";
    }

    @Generated
    public ChangeEntityValidationInfo(boolean depended, List<String> dependedBusinessEntities, List<String> dependedViewConfigNames, List<String> dependedAnomalyModelNames, List<String> dependedCalculationFieldNames, List<String> dependedPredictionModelNames) {
        this.depended = depended;
        this.dependedBusinessEntities = dependedBusinessEntities;
        this.dependedViewConfigNames = dependedViewConfigNames;
        this.dependedAnomalyModelNames = dependedAnomalyModelNames;
        this.dependedCalculationFieldNames = dependedCalculationFieldNames;
        this.dependedPredictionModelNames = dependedPredictionModelNames;
    }

    @Generated
    public ChangeEntityValidationInfo() {
    }
}

