/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.definition;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityFieldQuery;
import org.thingsboard.trendz.domain.definition.entity.request.BusinessEntityFieldUpdateRequest;
import org.thingsboard.trendz.domain.definition.entity.request.BusinessEntityFieldUpdateRequestItem;
import org.thingsboard.trendz.exception.TrendzInternalException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.definition.BusinessEntityService;

@Service
public class BusinessEntityClient {
    private final BusinessEntityService businessEntityService;

    @Autowired
    public BusinessEntityClient(BusinessEntityService businessEntityService) {
        this.businessEntityService = businessEntityService;
    }

    public void createBusinessEntityFields(JwtSecurityUser user, UUID businessEntityId, List<BusinessEntityField> businessEntityFields) {
        BusinessEntityFieldUpdateRequest request = BusinessEntityFieldUpdateRequest.builder().oldBusinessEntityId(businessEntityId).items(businessEntityFields.stream().map(businessEntityField -> new BusinessEntityFieldUpdateRequestItem(businessEntityField.getId(), null, null, businessEntityField)).toList()).build();
        this.updateBusinessEntityFields(user, request);
    }

    public void renameBusinessEntityFieldById(JwtSecurityUser user, UUID businessEntityId, UUID businessEntityFieldId, String newName) {
        this.businessEntityService.findEntityByIdAsOptional(user, businessEntityId).ifPresent(businessEntity -> businessEntity.getFields().stream().filter(field -> field.getId().equals(businessEntityFieldId)).findAny().ifPresent(field -> {
            field.setName(newName);
            BusinessEntity savedEntity = this.businessEntityService.saveEntity(user, businessEntity);
        }));
    }

    public void updateBusinessEntityFields(JwtSecurityUser user, BusinessEntityFieldUpdateRequest request) {
        BusinessEntity oldBusinessEntity = this.businessEntityService.findEntityById(user, request.getOldBusinessEntityId());
        BusinessEntity newBusinessEntity = request.getNewBusinessEntityId() == null ? oldBusinessEntity : this.businessEntityService.findEntityById(user, request.getNewBusinessEntityId());
        Map entityFieldRequests = request.getItems().stream().collect(Collectors.toMap(BusinessEntityFieldUpdateRequestItem::getEntityFieldId, Function.identity()));
        Map entityFieldToUpdate = entityFieldRequests.keySet().stream().map(id -> oldBusinessEntity.getFields().stream().filter(field -> field.getId().equals(id)).findAny().orElse(((BusinessEntityFieldUpdateRequestItem)entityFieldRequests.get(id)).getIfMissing())).collect(Collectors.toMap(BusinessEntityField::getId, Function.identity()));
        oldBusinessEntity.getFields().removeIf(businessEntityField -> entityFieldToUpdate.containsKey(businessEntityField.getId()));
        entityFieldRequests.values().forEach(changeRequest -> {
            BusinessEntityField businessEntityField = (BusinessEntityField)entityFieldToUpdate.get(changeRequest.getEntityFieldId());
            businessEntityField.setBusinessEntityId(newBusinessEntity.getId());
            if (changeRequest.getNewName() != null) {
                businessEntityField.setName(changeRequest.getNewName());
            }
            if (changeRequest.getNewTbKey() != null) {
                businessEntityField.getQuery().setKey(changeRequest.getNewTbKey());
            }
        });
        Set newTbKeys = entityFieldToUpdate.values().stream().map(BusinessEntityField::getQuery).map(BusinessEntityFieldQuery::getKey).collect(Collectors.toSet());
        Optional<String> duplicate = newBusinessEntity.getFields().stream().map(BusinessEntityField::getQuery).map(BusinessEntityFieldQuery::getKey).filter(newTbKeys::contains).findAny();
        if (duplicate.isPresent()) {
            throw new TrendzInternalException("Cannot update business entity field, duplicate was found in telemetry keys: " + duplicate.get());
        }
        newBusinessEntity.getFields().addAll(entityFieldToUpdate.values());
        this.businessEntityService.saveEntity(user, oldBusinessEntity);
        if (request.getNewBusinessEntityId() != null) {
            this.businessEntityService.saveEntity(user, newBusinessEntity);
        }
    }

    public void deleteBusinessEntityFieldById(JwtSecurityUser user, UUID businessEntityId, UUID businessEntityFieldId) {
        if (businessEntityFieldId == null) {
            return;
        }
        this.deleteBusinessEntityFieldsById(user, businessEntityId, Set.of(businessEntityFieldId));
    }

    public void deleteBusinessEntityFieldsById(JwtSecurityUser user, UUID businessEntityId, Set<UUID> businessEntityFieldIds) {
        this.businessEntityService.findEntityByIdAsOptional(user, businessEntityId).ifPresent(businessEntity -> {
            businessEntity.getFields().removeIf(field -> businessEntityFieldIds.stream().anyMatch(id -> field.getId().equals(id)));
            this.businessEntityService.saveEntity(user, businessEntity);
        });
    }
}

