/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.definition;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.system.ApplicationPropertyDao;
import org.thingsboard.trendz.domain.definition.ApplicationProperty;

@Service
public class ApplicationPropertyService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApplicationPropertyService.class);
    private final ApplicationPropertyDao applicationPropertyDao;

    @Autowired
    public ApplicationPropertyService(ApplicationPropertyDao applicationPropertyDao) {
        this.applicationPropertyDao = applicationPropertyDao;
    }

    public List<ApplicationProperty> getAllProperties() {
        return this.applicationPropertyDao.getAllProperties();
    }

    public Optional<String> getProperty(ApplicationProperty.Key key) {
        if (key == null) {
            return Optional.empty();
        }
        return this.applicationPropertyDao.getPropertyByKey(key.getStrValue()).map(ApplicationProperty::getValue);
    }

    public void setProperty(ApplicationProperty.Key key, String value) {
        this.applicationPropertyDao.saveProperty(new ApplicationProperty(key, value));
    }

    public void deleteProperty(ApplicationProperty.Key key) {
        this.applicationPropertyDao.deleteProperty(key.getStrValue());
    }
}

