/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.customize;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.transaction.Transactional;
import java.time.Duration;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.customize.UserRecordDao;
import org.thingsboard.trendz.dao.customize.UserRecordDtoId;
import org.thingsboard.trendz.domain.customize.UserRecord;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.service.AuthenticationService;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.provider.cache.CacheConfigurationName;
import org.thingsboard.trendz.service.provider.cache.CacheService;
import org.thingsboard.trendz.tools.DonReactive;
import org.thingsboard.trendz.tools.json.JsonUtils;
import reactor.core.publisher.Mono;

@Service
public class UserManagementService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserManagementService.class);
    private final UserRecordDao userRecordDao;
    private final AuthenticationService authenticationService;
    private final TbRestDataSource tbRestDataSource;
    private final Cache userTrackCache;
    private final Cache metricTenantNameCache;
    private final Cache metricCustomerNameCache;

    @Autowired
    public UserManagementService(UserRecordDao userRecordDao, AuthenticationService authenticationService, TbRestDataSource tbRestDataSource, CacheService cacheService) {
        this.userRecordDao = userRecordDao;
        this.authenticationService = authenticationService;
        this.tbRestDataSource = tbRestDataSource;
        this.userTrackCache = cacheService.getCache(CacheConfigurationName.userTrackCacheName);
        this.metricTenantNameCache = cacheService.getCache(CacheConfigurationName.metricTenantNameCacheName);
        this.metricCustomerNameCache = cacheService.getCache(CacheConfigurationName.metricCustomerNameCacheName);
    }

    public Optional<UserRecord> findRecordByUser(JwtSecurityUser user) {
        UserRecordDtoId id = UserRecordDtoId.fromUser((JwtSecurityUser)user);
        return this.userRecordDao.findById(id);
    }

    @Transactional
    public void trackUser(String username, JwtSecurityUser user) {
        this.findRecordByUser(user).ifPresentOrElse(record -> {
            long now = System.currentTimeMillis();
            String newUsername = Optional.ofNullable(username).orElse(record.getUsername());
            record.setUsername(newUsername);
            if (!record.isValid()) {
                record.setValid(true);
                record.setValidationLastTs(now);
                log.warn("An invalidated user was marked as VALID: {}", (Object)newUsername);
            }
            this.loadOrganizationData(user, record);
            record.setVisitLastTs(now);
            UserRecord saved = this.userRecordDao.save(record);
            log.debug("A user visit was recorded: {}", (Object)saved.getUsername());
        }, () -> {
            long now = System.currentTimeMillis();
            UserRecord record = UserRecord.builder().user(user).username(username).visitFirstTs(now).visitLastTs(now).valid(true).validationLastTs(now).subscription(null).tenantInfo(null).customerInfo(null).build();
            this.loadOrganizationData(user, record);
            UserRecord saved = this.userRecordDao.save(record);
            log.info("A new user was registered: {}", (Object)saved.getUsername());
        });
    }

    public Page<JwtSecurityUser> getAllUserIds(int page, int pageSize) {
        return this.userRecordDao.getAllUserIds(page, pageSize);
    }

    public Set<UUID> getAllTenantIds() {
        return this.userRecordDao.getAllTenantIds();
    }

    public Set<JwtSecurityUser> getAllFirstTenantUserIds() {
        return this.userRecordDao.getAllFirstTenantUserIds().stream().map(UserRecordDtoId::toUser).collect(Collectors.toSet());
    }

    public boolean validateUser(JwtSecurityUser user) {
        long now = System.currentTimeMillis();
        Optional opt = this.userRecordDao.findById(UserRecordDtoId.fromUser((JwtSecurityUser)user));
        if (opt.isEmpty()) {
            log.info("The user is not found, consider as INVALIDATED.");
            return false;
        }
        UserRecord record = (UserRecord)opt.get();
        boolean valid = this.authenticationService.validateUser(user).isValid();
        record.setValid(valid);
        record.setValidationLastTs(now);
        UserRecord saved = this.userRecordDao.save(record);
        this.userTrackCache.evict((Object)user);
        log.info("The user '{}' is {}.", (Object)saved.getUsername(), (Object)(valid ? "VALIDATED" : "INVALIDATED"));
        return valid;
    }

    public String getTenantName(UUID tenantId) {
        return (String)this.metricTenantNameCache.get((Object)tenantId.toString(), () -> this.findFirstTenantUserByTenantId(tenantId).map(UserRecord::getUsername).orElse("Unknown tenant: " + String.valueOf(tenantId)));
    }

    public String getCustomerName(JwtSecurityUser user) {
        return (String)this.metricCustomerNameCache.get((Object)String.format("%s + %s", user.getTenantId(), user.getCustomerId()), () -> {
            if (user.isTenantUser()) {
                return "None";
            }
            return (String)DonReactive.block((Mono)this.tbRestDataSource.loadCustomerTitleByApi(user).onErrorResume(throwable -> Mono.just((Object)("Unknown customer: " + String.valueOf(user.getCustomerId())))));
        });
    }

    public void assignLicenceInfo(JwtSecurityUser user, JsonNode subscription) {
        this.findRecordByUser(user).ifPresent(record -> {
            record.setSubscriptionUpdateTs(Long.valueOf(System.currentTimeMillis()));
            record.setSubscription(subscription.toPrettyString());
            UserRecord saved = this.userRecordDao.save(record);
            log.debug("The licence info is assigned for user {}.", (Object)saved.getUsername());
        });
    }

    public Optional<UserRecord> findFirstTenantUserByTenantId(UUID tenantId) {
        return this.userRecordDao.findFirstTenantUserByTenantId(tenantId);
    }

    public Page<JwtSecurityUser> findAllTenantUserByTenantId(UUID tenantId, int page, int pageSize) {
        return this.userRecordDao.findAllTenantUserByTenantId(tenantId, page, pageSize);
    }

    private void loadOrganizationData(JwtSecurityUser user, UserRecord record) {
        try {
            if (user.isCustomerUser()) {
                String customer = (String)DonReactive.block((Mono)this.tbRestDataSource.loadCustomerByApi(user, null).onErrorResume(throwable -> Mono.just((Object)this.makeDefaultOrgData(false))), (Duration)Duration.ofSeconds(10L));
                record.setCustomerInfo(customer);
            } else {
                String tenant = (String)DonReactive.block((Mono)this.tbRestDataSource.loadTenantByApi(user, null).onErrorResume(throwable -> Mono.just((Object)this.makeDefaultOrgData(true))), (Duration)Duration.ofSeconds(10L));
                record.setTenantInfo(tenant);
            }
        }
        catch (Exception e) {
            log.warn("Can not load tenant/customer data for user management", (Throwable)e);
        }
    }

    private String makeDefaultOrgData(boolean tenant) {
        String key = tenant ? "tenantInfo" : "customerInfo";
        ObjectNode objectNode = JsonUtils.getObjectMapper().createObjectNode();
        objectNode.put(key, "error");
        log.warn("Error during org data loading!");
        return objectNode.toPrettyString();
    }
}

