/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.chat;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.assistance.chat.ChatDao;
import org.thingsboard.trendz.domain.chat.Chat;
import org.thingsboard.trendz.domain.chat.ChatAvailableTopology;
import org.thingsboard.trendz.domain.chat.ChatConfig;
import org.thingsboard.trendz.domain.chat.ChatFilteringField;
import org.thingsboard.trendz.domain.chat.ChatInitRequest;
import org.thingsboard.trendz.domain.chat.ChatLite;
import org.thingsboard.trendz.domain.chat.ChatMessage;
import org.thingsboard.trendz.domain.chat.ChatMessageLite;
import org.thingsboard.trendz.domain.chat.ChatMessagePostRequest;
import org.thingsboard.trendz.domain.chat.ChatMessageProcessResponse;
import org.thingsboard.trendz.domain.chat.ChatMessageSortingField;
import org.thingsboard.trendz.domain.chat.ChatQuotaResult;
import org.thingsboard.trendz.domain.chat.ChatRequest;
import org.thingsboard.trendz.domain.chat.ChatSortingField;
import org.thingsboard.trendz.domain.chat.ChatType;
import org.thingsboard.trendz.domain.metric.assistance.MetricCodeAssistanceResponse;
import org.thingsboard.trendz.domain.summary.TrendzSimpleEntityUsage;
import org.thingsboard.trendz.exception.TrendzInternalException;
import org.thingsboard.trendz.exception.chat.ChatException;
import org.thingsboard.trendz.exception.chat.ChatNotFoundException;
import org.thingsboard.trendz.exception.chat.ChatQuotaLimitException;
import org.thingsboard.trendz.exception.task.TaskNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceResponse;
import org.thingsboard.trendz.service.assistance.llm.LlmService;
import org.thingsboard.trendz.service.chat.ChatQuotaService;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskManagementService;
import org.thingsboard.trendz.service.task.TaskService;
import org.thingsboard.trendz.service.task.job.ChatAssistance;
import org.thingsboard.trendz.service.task.model.Task;
import org.thingsboard.trendz.service.task.model.TaskReference;
import org.thingsboard.trendz.service.task.model.TaskReferencedEntityType;
import org.thingsboard.trendz.tools.UUIDUtils;

@Service
public class ChatService {
    private final ChatDao chatDao;
    private final ChatQuotaService chatQuotaService;
    private final TaskService taskService;
    private final TaskManagementService taskManagementService;
    private final LlmService llmService;

    @Autowired
    public ChatService(ChatDao chatDao, TaskService taskService, ChatQuotaService chatQuotaService, TaskManagementService taskManagementService, LlmService llmService) {
        this.chatDao = chatDao;
        this.taskService = taskService;
        this.chatQuotaService = chatQuotaService;
        this.taskManagementService = taskManagementService;
        this.llmService = llmService;
    }

    public Page<ChatLite> getAllChatLite(int page, int pageSize, JwtSecurityUser user, List<ChatFilteringField> filteringFields, List<ChatSortingField> sortingFields) {
        return this.chatDao.getAllChatLite(page, pageSize, user, filteringFields, sortingFields);
    }

    public ChatMessageProcessResponse initChat(ChatInitRequest chatInitRequest, JwtSecurityUser user) {
        ChatType chatType = ChatType.valueOf((String)chatInitRequest.getInitData().getChatType());
        this.llmService.validateChatTypeForUser(user, chatType);
        this.validateChatQuota(user);
        this.validateChatConfig(chatInitRequest.getInitData());
        if (chatType == ChatType.VIEW_ASSISTANT) {
            this.populateChatConfig(chatInitRequest.getInitData().getViewAssistantChatConfig());
        }
        ChatLite chatLite = this.chatDao.initChat(chatInitRequest, user);
        this.createMessageProcessTask(user, chatLite.getId());
        UUID executionId = this.runChatMessageProcessTask(user, chatLite, chatInitRequest.getMessageData());
        return new ChatMessageProcessResponse(chatLite, executionId);
    }

    public ChatMessageProcessResponse postNewMessage(UUID chatId, ChatMessagePostRequest postRequest, JwtSecurityUser user) {
        ChatLite chat = this.getChatLite(chatId, user);
        this.llmService.validateChatTypeForUser(user, chat.getType());
        this.validateChatQuota(user);
        ChatLite chatLite = this.chatDao.postNewMessage(chatId, postRequest, user);
        UUID executionId = this.runChatMessageProcessTask(user, chatLite, postRequest);
        return new ChatMessageProcessResponse(chatLite, executionId);
    }

    public ChatMessageProcessResponse editLastMessage(UUID chatId, ChatMessagePostRequest postRequest, JwtSecurityUser user) {
        ChatLite chat = this.getChatLite(chatId, user);
        this.llmService.validateChatTypeForUser(user, chat.getType());
        this.validateChatQuota(user);
        ChatLite chatLite = this.chatDao.editLastMessage(chatId, postRequest.getQuestion(), user);
        UUID executionId = this.runChatMessageProcessTask(user, chatLite, postRequest);
        return new ChatMessageProcessResponse(chatLite, executionId);
    }

    public ChatLite getChatLite(UUID chatId, JwtSecurityUser user) {
        return (ChatLite)this.chatDao.getChatLiteByIdAndUser(chatId, user).orElseThrow(() -> new ChatNotFoundException(chatId));
    }

    public Page<ChatMessageLite> getAllChatMessageLite(UUID chatId, int page, int pageSize, JwtSecurityUser securityUser, List<ChatMessageSortingField> sortingFields) {
        return this.chatDao.getAllChatMessageLite(chatId, page, pageSize, securityUser, sortingFields);
    }

    public List<ChatMessageLite> getAllChatMessageLite(UUID chatId, JwtSecurityUser user) {
        return this.chatDao.getAllChatMessageLite(chatId, user);
    }

    public ChatMessage getChatMessage(UUID chatId, UUID messageId, JwtSecurityUser user) {
        return this.chatDao.getChatMessage(chatId, messageId, user);
    }

    public void populateChatMessageJsonJobResponse(UUID messageId, ViewAssistanceResponse jsonJobResponse) {
        String aiMemory = jsonJobResponse.getViewAssistanceState() == null ? null : jsonJobResponse.getViewAssistanceState().getAiMemory();
        this.chatDao.populateChatMessageJsonJobResponse(messageId, (Object)jsonJobResponse, jsonJobResponse.getErrorMetadata(), aiMemory);
    }

    public void populateChatMessageJsonJobResponse(UUID messageId, MetricCodeAssistanceResponse jsonJobResponse) {
        this.chatDao.populateChatMessageJsonJobResponse(messageId, (Object)jsonJobResponse, jsonJobResponse.getErrorMetadata(), jsonJobResponse.getTask());
    }

    public void populateChatSummary(UUID chatId, String chatSummary) {
        this.chatDao.populateChatSummary(chatId, chatSummary);
    }

    public void deleteChat(UUID chatId, JwtSecurityUser user) {
        this.chatDao.deleteChat(chatId, user);
        this.taskManagementService.deleteByTaskReference(user, new TaskReference(TaskReferencedEntityType.CHAT_MESSAGE_PROCESS_TASK, chatId.toString()));
    }

    public ChatLite updateChat(UUID chatId, ChatConfig chatConfig, JwtSecurityUser user) {
        this.validateChatConfig(chatConfig);
        this.populateChatConfig(chatConfig.getViewAssistantChatConfig());
        return this.chatDao.updateChat(chatId, chatConfig.getViewAssistantChatConfig(), user);
    }

    public List<Chat> getAllChats(JwtSecurityUser user) {
        return this.chatDao.exportAllChats(user);
    }

    public List<ChatMessage> getAllChatMessages(JwtSecurityUser user) {
        return this.chatDao.exportAllChatMessages(user);
    }

    public List<Chat> importAllChats(JwtSecurityUser user, List<Chat> newChats) {
        List saved = this.chatDao.importAllChats(newChats);
        saved.stream().map(Chat::getId).forEach(chatId -> this.createMessageProcessTask(user, chatId));
        return saved;
    }

    public List<ChatMessage> importAllChatMessages(List<ChatMessage> newChatMessages) {
        return this.chatDao.importAllChatMessages(newChatMessages);
    }

    public Optional<ChatMessage> getLastChatMessage(JwtSecurityUser user, UUID chatId, Set<UUID> toExclude) {
        return this.chatDao.getLastChatMessage(user, chatId, toExclude);
    }

    public TrendzSimpleEntityUsage findUsage(JwtSecurityUser user) {
        return this.chatDao.findUsage(user.getTenantId());
    }

    private void validateChatConfig(ChatConfig chatConfig) {
        if (chatConfig == null) {
            throw new ChatException("Chat config cannot be null");
        }
        if (ChatType.VIEW_ASSISTANT.name().equals(chatConfig.getChatType()) && chatConfig.getViewAssistantChatConfig() == null) {
            throw new ChatException("Chat view assistance config cannot be null when type is VIEW_ASSISTANT");
        }
        if (ChatType.METRIC_CODE_ASSISTANT.name().equals(chatConfig.getChatType()) && chatConfig.getMetricExplorationChatConfig() == null) {
            throw new ChatException("Chat metric exploration config cannot be null when type is METRIC_CODE_ASSISTANT");
        }
        if (!ChatType.VIEW_ASSISTANT.name().equals(chatConfig.getChatType()) && !ChatType.METRIC_CODE_ASSISTANT.name().equals(chatConfig.getChatType())) {
            throw new ChatException("Unknown chat type: \"%s\". Available ones: VIEW_ASSISTANT, METRIC_CODE_ASSISTANT");
        }
    }

    private void populateChatConfig(ChatConfig.ViewAssistanceChatConfig chatConfig) {
        ChatAvailableTopology availableTopology = chatConfig.getAvailableTopology();
        if (chatConfig.getAvailableTopology() == null) {
            return;
        }
        if (availableTopology.getBusinessEntities() == null) {
            availableTopology.setBusinessEntities(new ArrayList());
            return;
        }
        availableTopology.getBusinessEntities().stream().filter(availableBusinessEntity -> availableBusinessEntity.getFields() == null).forEach(availableBusinessEntity -> availableBusinessEntity.setFields(new ArrayList()));
    }

    private void createMessageProcessTask(JwtSecurityUser user, UUID chatId) {
        ChatLite chatLite = this.getChatLite(chatId, user);
        TaskReference reference = new TaskReference(TaskReferencedEntityType.CHAT_MESSAGE_PROCESS_TASK, chatLite.getId().toString());
        String taskName = "Chat message process: " + String.valueOf(chatLite.getId());
        ChatAssistance taskJob = new ChatAssistance();
        this.taskManagementService.createOrUpdateTask(user, reference, taskName, (TaskJob)taskJob);
    }

    private UUID runChatMessageProcessTask(JwtSecurityUser user, ChatLite chatLite, ChatMessagePostRequest postRequest) {
        ChatMessageLite chatMessageLite = chatLite.getLastMessage();
        TaskReference reference = new TaskReference(TaskReferencedEntityType.CHAT_MESSAGE_PROCESS_TASK, chatLite.getId().toString());
        ChatRequest chatRequest = ChatRequest.builder().chatId(chatLite.getId()).messageId(chatMessageLite.getId()).tzName(postRequest.getTzName()).domain(postRequest.getDomain()).build();
        if (chatLite.getType() == ChatType.METRIC_CODE_ASSISTANT) {
            ChatMessagePostRequest.MetricCodeAssistanceParams params = Optional.ofNullable(postRequest.getMetricCodeAssistanceParams()).orElseThrow(() -> new TrendzInternalException("Metric Code Params are missing."));
            chatRequest.setCode(params.getCode());
            chatRequest.setItemId(params.getItemId() == null ? null : UUIDUtils.parse((String)params.getItemId()));
            chatRequest.setDatePickerConfig(params.getDatePickerConfig());
        }
        ChatAssistance job = new ChatAssistance(chatRequest);
        Task task = (Task)this.taskService.findTaskByReferencedEntity(user, reference).orElseThrow(() -> new TaskNotFoundException(reference));
        return this.taskService.runExecution(user, task.getId(), (TaskJob)job, true, true);
    }

    private void validateChatQuota(JwtSecurityUser user) {
        long now = System.currentTimeMillis();
        ChatQuotaResult quotaResult = this.chatQuotaService.checkViewAssistanceQuotaForUser(user, now);
        if (!quotaResult.isAvailable()) {
            throw new ChatQuotaLimitException(quotaResult.getRemainingDuration());
        }
    }
}

