/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.chat;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.Cache;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.base.TimeRange;
import org.thingsboard.trendz.domain.chat.ChatQuotaQueue;
import org.thingsboard.trendz.domain.chat.ChatQuotaResult;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.chat.ChatQuotaService;
import org.thingsboard.trendz.service.provider.cache.CacheConfigurationName;
import org.thingsboard.trendz.service.provider.cache.CacheService;
import org.thingsboard.trendz.tools.DateTimeUtils;

@Service
public class ChatQuotaServiceImpl
implements ChatQuotaService {
    private final Cache cache;
    private final boolean enable;
    private final long ttlMs;
    private final int maxRequestsForSystem;
    private final int maxRequestsForTenant;
    private final int maxRequestsForCustomer;
    private final int maxRequestsForUser;
    private final Object mutex = new Object();

    @Autowired
    public ChatQuotaServiceImpl(@Value(value="${viewAssistance.quota.enable}") boolean enable, @Value(value="${viewAssistance.quota.maxRequestsForSystem}") int maxRequestsForSystem, @Value(value="${viewAssistance.quota.maxRequestsForTenant}") int maxRequestsForTenant, @Value(value="${viewAssistance.quota.maxRequestsForCustomer}") int maxRequestsForCustomer, @Value(value="${viewAssistance.quota.maxRequestsForUser}") int maxRequestsForUser, @Value(value="${viewAssistance.quota.durationInMinutes}") int ttlMinutes, CacheService cacheService) {
        this.enable = enable;
        this.maxRequestsForSystem = maxRequestsForSystem;
        this.maxRequestsForTenant = maxRequestsForTenant;
        this.maxRequestsForCustomer = maxRequestsForCustomer;
        this.maxRequestsForUser = maxRequestsForUser;
        this.ttlMs = (long)ttlMinutes * 60000L;
        this.cache = cacheService.getCache(CacheConfigurationName.viewAssistanceChatQuotaCacheName);
    }

    public ChatQuotaResult checkViewAssistanceQuotaForUser(JwtSecurityUser jwtSecurityUser, long now) {
        if (!this.enable) {
            return new ChatQuotaResult(true, -1, Duration.ZERO);
        }
        String systemKey = "system";
        String tenantKey = jwtSecurityUser.getTenantId().toString();
        String customerKey = tenantKey + "/" + String.valueOf(jwtSecurityUser.getCustomerId());
        String userKey = customerKey + "/" + String.valueOf(jwtSecurityUser.getUserId());
        return this.getChatQuotaForKey(Map.of(systemKey, this.maxRequestsForSystem, tenantKey, this.maxRequestsForTenant, customerKey, this.maxRequestsForCustomer, userKey, this.maxRequestsForUser), now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChatQuotaResult getChatQuotaForKey(Map<String, Integer> limits, long now) {
        Object object = this.mutex;
        synchronized (object) {
            long firstActivationTs;
            boolean available;
            Map chatQuotaQueues = limits.keySet().stream().collect(Collectors.toMap(Function.identity(), key -> {
                ChatQuotaQueue chatQuotaQueue = (ChatQuotaQueue)this.cache.get(key, ChatQuotaQueue::new);
                assert (chatQuotaQueue != null);
                return chatQuotaQueue;
            }));
            ZonedDateTime endData = DateTimeUtils.fromTs((long)now);
            ZonedDateTime startDate = endData.minus(this.ttlMs, ChronoUnit.MILLIS);
            TimeRange actualActivationsRange = new TimeRange(DateTimeUtils.toTs((ZonedDateTime)startDate), DateTimeUtils.toTs((ZonedDateTime)endData));
            Map<String, Set> actualActivations = chatQuotaQueues.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ChatQuotaQueue)entry.getValue()).getActivationTsSet().stream().filter(arg_0 -> ((TimeRange)actualActivationsRange).contains(arg_0)).collect(Collectors.toSet())));
            int free = actualActivations.entrySet().stream().mapToInt(entry -> (Integer)limits.get(entry.getKey()) - ((Set)entry.getValue()).size()).min().orElseThrow();
            boolean bl = available = free > 0;
            if (available) {
                actualActivations.forEach((key, value) -> {
                    value.add(now);
                    this.cache.put(key, (Object)new ChatQuotaQueue(value));
                });
                --free;
            }
            if ((firstActivationTs = actualActivations.entrySet().stream().filter(entry -> ((Integer)limits.get(entry.getKey())).intValue() == ((Set)entry.getValue()).size()).map(Map.Entry::getValue).map(set -> set.stream().mapToLong(i -> i).min().orElseThrow()).mapToLong(i -> i).max().orElse(0L)) == 0L) {
                return new ChatQuotaResult(available, free, Duration.ZERO);
            }
            TimeRange remainingRange = new TimeRange(DateTimeUtils.toTs((ZonedDateTime)startDate), firstActivationTs);
            return new ChatQuotaResult(available, free, remainingRange.duration());
        }
    }
}

