/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.calculation;

import jakarta.transaction.Transactional;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.calculation.LatestTelemetryStoreRepository;

@Service
@Transactional
public class LatestTelemetryStoreService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LatestTelemetryStoreService.class);
    private final JdbcTemplate jdbcTemplate;
    private final LatestTelemetryStoreRepository repository;

    @Autowired
    public LatestTelemetryStoreService(JdbcTemplate jdbcTemplate, LatestTelemetryStoreRepository repository) {
        this.jdbcTemplate = jdbcTemplate;
        this.repository = repository;
    }

    public Map<UUID, Map<String, Long>> getLatest(UUID calculationFieldId, Set<UUID> itemIds, Set<String> keys) {
        if (itemIds.isEmpty() || keys.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.repository.findLatestByItemIds(calculationFieldId, itemIds, keys).stream().map(array -> Triple.of((Object)UUID.fromString((String)array[0]), (Object)((String)array[1]), (Object)((Number)array[2]).longValue())).collect(Collectors.groupingBy(Triple::getLeft, Collectors.toMap(Triple::getMiddle, Triple::getRight)));
    }

    public void setLatestBatch(UUID calculationFieldId, Map<UUID, Map<String, Long>> itemToKeyToLatestTsMap) {
        ArrayList<UUID> itemIdsList = new ArrayList<UUID>();
        ArrayList<String> keysList = new ArrayList<String>();
        ArrayList<Long> valuesList = new ArrayList<Long>();
        for (Map.Entry<UUID, Map<String, Long>> itemEntry : itemToKeyToLatestTsMap.entrySet()) {
            UUID itemId = itemEntry.getKey();
            Map<String, Long> keyToLatestMap = itemEntry.getValue();
            for (Map.Entry<String, Long> keyEntry : keyToLatestMap.entrySet()) {
                String key = keyEntry.getKey();
                Long value = keyEntry.getValue();
                itemIdsList.add(itemId);
                keysList.add(key);
                valuesList.add(value);
            }
        }
        if (itemIdsList.isEmpty() || keysList.isEmpty() || valuesList.isEmpty()) {
            return;
        }
        this.jdbcTemplate.execute(connection -> {
            Array itemIdsArray = connection.createArrayOf("uuid", itemIdsList.toArray());
            Array keysArray = connection.createArrayOf("varchar", keysList.toArray());
            Array valuesArray = connection.createArrayOf("bigint", valuesList.toArray());
            String sql = "WITH data(calculation_field_id, item_id, key, value) AS (\n   SELECT CAST(? AS uuid) AS calculation_field_id, t.item_id, t.key, t.value\n   FROM unnest(?, ?, ?) AS t(item_id, key, value)\n)\nINSERT INTO latest_telemetry (calculation_field_id, item_id, key, value)\nSELECT * FROM data\nON CONFLICT (calculation_field_id, item_id, key) DO UPDATE SET value = EXCLUDED.value\n";
            try (PreparedStatement ps = connection.prepareStatement(sql);){
                int i = 0;
                ps.setObject(++i, calculationFieldId);
                ps.setArray(++i, itemIdsArray);
                ps.setArray(++i, keysArray);
                ps.setArray(++i, valuesArray);
                ps.execute();
            }
            finally {
                itemIdsArray.free();
                keysArray.free();
                valuesArray.free();
            }
            return null;
        });
    }
}

