/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.assistance.customprompt;

import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.dao.assistance.customprompt.CustomPromptDao;
import org.thingsboard.trendz.domain.assistance.customprompt.CustomPrompt;
import org.thingsboard.trendz.domain.assistance.customprompt.CustomPromptExecutionRequest;
import org.thingsboard.trendz.domain.assistance.customprompt.CustomPromptFilteringField;
import org.thingsboard.trendz.domain.assistance.customprompt.CustomPromptLite;
import org.thingsboard.trendz.domain.assistance.customprompt.CustomPromptModifyCreateRequest;
import org.thingsboard.trendz.domain.assistance.customprompt.CustomPromptSortingField;
import org.thingsboard.trendz.domain.chat.ChatType;
import org.thingsboard.trendz.exception.TrendzInternalException;
import org.thingsboard.trendz.exception.task.TaskNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.assistance.agent.AgentService;
import org.thingsboard.trendz.service.assistance.agent.customprompt.domain.CustomPromptRequest;
import org.thingsboard.trendz.service.assistance.agent.customprompt.domain.CustomPromptResult;
import org.thingsboard.trendz.service.assistance.customprompt.CustomPromptService;
import org.thingsboard.trendz.service.assistance.llm.LlmService;
import org.thingsboard.trendz.service.assistance.token.TokenUsageService;
import org.thingsboard.trendz.service.definition.ChangeEntityValidationInfo;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskManagementService;
import org.thingsboard.trendz.service.task.TaskService;
import org.thingsboard.trendz.service.task.job.CacheRefreshJob;
import org.thingsboard.trendz.service.task.job.CustomPromptJob;
import org.thingsboard.trendz.service.task.model.Task;
import org.thingsboard.trendz.service.task.model.TaskReference;
import org.thingsboard.trendz.service.task.model.TaskReferencedEntityType;
import org.thingsboard.trendz.tools.UUIDUtils;

@Service
public class CustomPromptServiceImpl
implements CustomPromptService {
    private static final String SYSTEM_AI_PROMPTS = "systemAiPrompts";
    private final CustomPromptDao customPromptDao;
    private final TokenUsageService tokenUsageService;
    private final TaskService taskService;
    private final TaskManagementService taskManagementService;
    private final LlmService llmService;
    private final AgentService agentService;

    @Autowired
    public CustomPromptServiceImpl(CustomPromptDao customPromptDao, TokenUsageService tokenUsageService, TaskService taskService, TaskManagementService taskManagementService, LlmService llmService, AgentService agentService) {
        this.customPromptDao = customPromptDao;
        this.tokenUsageService = tokenUsageService;
        this.taskService = taskService;
        this.taskManagementService = taskManagementService;
        this.llmService = llmService;
        this.agentService = agentService;
    }

    public CustomPrompt createCustomPrompt(CustomPromptModifyCreateRequest modifyCreateRequest, JwtSecurityUser user) {
        CustomPrompt customPrompt = this.customPromptDao.createCustomPrompt(modifyCreateRequest, user);
        this.createOrUpdateAiPromptExecutionTask(user, customPrompt);
        return customPrompt;
    }

    public void deleteCustomPrompt(UUID promptId, JwtSecurityUser user) {
        this.customPromptDao.deleteCustomPrompt(promptId, user);
        this.taskManagementService.deleteByTaskReference(user, new TaskReference(TaskReferencedEntityType.AI_PROMPT_EXECUTION_TASK, promptId.toString()));
    }

    public CustomPrompt updateCustomPrompt(UUID promptId, CustomPromptModifyCreateRequest modifyCreateRequest, JwtSecurityUser user) {
        CustomPrompt customPrompt = this.customPromptDao.modifyCustomPrompt(promptId, modifyCreateRequest, user);
        if (modifyCreateRequest.getName() != null) {
            this.createOrUpdateAiPromptExecutionTask(user, customPrompt);
        }
        return customPrompt;
    }

    @Cacheable(cacheNames={"systemAiPrompts"})
    public List<CustomPromptLite> getAllSystemCustomPromptLite() {
        return this.customPromptDao.getAllSystemPromptLite();
    }

    public Page<CustomPromptLite> getAllCustomPromptLite(int page, int pageSize, JwtSecurityUser user, List<CustomPromptFilteringField> filteringFields, List<CustomPromptSortingField> sortingFields) {
        return this.customPromptDao.getAllCustomPromptLite(page, pageSize, user, filteringFields, sortingFields);
    }

    public CustomPrompt getCustomPrompt(UUID promptId, JwtSecurityUser user) {
        return this.customPromptDao.findCustomPrompt(promptId, user);
    }

    public CustomPromptResult executeCustomPrompt(CustomPromptExecutionRequest customPromptExecutionRequest, JwtSecurityUser user) {
        return this.executeCustomPrompt(customPromptExecutionRequest, user, false);
    }

    public CustomPromptResult executeViewSummary(CustomPromptExecutionRequest customPromptExecutionRequest, JwtSecurityUser user) {
        return this.executeCustomPrompt(customPromptExecutionRequest, user, true);
    }

    public UUID runCustomPromptExecution(CustomPromptExecutionRequest customPromptRequest, JwtSecurityUser user) {
        this.llmService.validateChatTypeForUser(user, ChatType.CUSTOM_PROMPT);
        TaskReference reference = new TaskReference(TaskReferencedEntityType.AI_PROMPT_EXECUTION_TASK, this.getTaskReferenceKey(customPromptRequest, user));
        CustomPromptJob job = CustomPromptJob.builder().customPromptExecutionRequest(customPromptRequest).build();
        Task task = (Task)this.taskService.findTaskByReferencedEntity(user, reference).orElseThrow(() -> new TaskNotFoundException(reference));
        return this.taskService.runExecution(user, task.getId(), (TaskJob)job, false, true);
    }

    public List<CustomPrompt> getAllNonSystemPrompts(JwtSecurityUser user) {
        return this.customPromptDao.getAllNonSystemPrompts(user);
    }

    public List<CustomPrompt> importAllPrompts(List<CustomPrompt> newPrompts) {
        newPrompts.stream().filter(CustomPrompt::isSystem).findAny().ifPresent(customPrompt -> {
            throw new TrendzInternalException("Impossible to import system prompt: " + customPrompt.getName());
        });
        return this.customPromptDao.saveAllPrompts(newPrompts);
    }

    public ChangeEntityValidationInfo findDependedEntities(JwtSecurityUser user, CustomPrompt entity) {
        return this.customPromptDao.findDependedEntities(user, entity);
    }

    private CustomPromptResult executeCustomPrompt(CustomPromptExecutionRequest customPromptExecutionRequest, JwtSecurityUser user, boolean viewSummary) {
        CustomPromptRequest customPromptRequest = new CustomPromptRequest();
        UUID promptId = this.getPromptId(customPromptExecutionRequest);
        if (promptId == null) {
            customPromptRequest.setPrompt(customPromptExecutionRequest.getPrompt());
        } else {
            String prompt = this.customPromptDao.findCustomPrompt(promptId, user).getPrompt();
            customPromptRequest.setPrompt(prompt);
        }
        customPromptRequest.setData(customPromptExecutionRequest.getData());
        this.tokenUsageService.checkTokenUsage(user, ChatType.CUSTOM_PROMPT);
        String result = viewSummary ? this.agentService.processAiRequestViewSummary(user, customPromptRequest.getPrompt(), customPromptRequest.getData()) : this.agentService.processAiRequestCustomPrompt(user, customPromptRequest.getPrompt(), customPromptRequest.getData());
        return CustomPromptResult.builder().result(result).build();
    }

    private void createOrUpdateAiPromptExecutionTask(JwtSecurityUser user, CustomPrompt customPrompt) {
        TaskReference reference = new TaskReference(TaskReferencedEntityType.AI_PROMPT_EXECUTION_TASK, customPrompt.getId().toString());
        String taskName = "AI prompt execution: " + customPrompt.getName();
        CacheRefreshJob taskJob = new CacheRefreshJob();
        this.taskManagementService.createOrUpdateTask(user, reference, taskName, (TaskJob)taskJob);
    }

    private String getTaskReferenceKey(CustomPromptExecutionRequest customPromptRequest, JwtSecurityUser user) {
        UUID promptId = this.getPromptId(customPromptRequest);
        if (promptId == null) {
            return user.getTenantCustomerKey() + "/" + String.valueOf(EntityId.NULL_UUID);
        }
        CustomPrompt customPrompt = this.getCustomPrompt(promptId, user);
        if (customPrompt.isSystem()) {
            return user.getTenantCustomerKey() + "/" + String.valueOf(customPrompt.getId());
        }
        return customPrompt.getId().toString();
    }

    private UUID getPromptId(CustomPromptExecutionRequest customPromptRequest) {
        if (customPromptRequest.getPromptId() == null) {
            if (customPromptRequest.getPrompt() == null) {
                return SYSTEM_DEFAULT_PROMPT;
            }
            return null;
        }
        return UUIDUtils.parse((String)customPromptRequest.getPromptId());
    }
}

