/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.assistance.customprompt;

import java.util.List;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.thingsboard.trendz.domain.assistance.customprompt.CustomPrompt;
import org.thingsboard.trendz.domain.assistance.customprompt.CustomPromptExecutionRequest;
import org.thingsboard.trendz.domain.assistance.customprompt.CustomPromptFilteringField;
import org.thingsboard.trendz.domain.assistance.customprompt.CustomPromptLite;
import org.thingsboard.trendz.domain.assistance.customprompt.CustomPromptModifyCreateRequest;
import org.thingsboard.trendz.domain.assistance.customprompt.CustomPromptSortingField;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.assistance.agent.customprompt.domain.CustomPromptResult;
import org.thingsboard.trendz.service.definition.ChangeEntityValidationInfo;

public interface CustomPromptService {
    public static final UUID SYSTEM_DEFAULT_PROMPT = UUID.fromString("a21d5620-161c-11f0-9cd2-0242ac120002");

    public CustomPrompt createCustomPrompt(CustomPromptModifyCreateRequest var1, JwtSecurityUser var2);

    public void deleteCustomPrompt(UUID var1, JwtSecurityUser var2);

    public CustomPrompt updateCustomPrompt(UUID var1, CustomPromptModifyCreateRequest var2, JwtSecurityUser var3);

    public List<CustomPromptLite> getAllSystemCustomPromptLite();

    public Page<CustomPromptLite> getAllCustomPromptLite(int var1, int var2, JwtSecurityUser var3, List<CustomPromptFilteringField> var4, List<CustomPromptSortingField> var5);

    public CustomPrompt getCustomPrompt(UUID var1, JwtSecurityUser var2);

    public CustomPromptResult executeCustomPrompt(CustomPromptExecutionRequest var1, JwtSecurityUser var2);

    public CustomPromptResult executeViewSummary(CustomPromptExecutionRequest var1, JwtSecurityUser var2);

    public UUID runCustomPromptExecution(CustomPromptExecutionRequest var1, JwtSecurityUser var2);

    public List<CustomPrompt> getAllNonSystemPrompts(JwtSecurityUser var1);

    public List<CustomPrompt> importAllPrompts(List<CustomPrompt> var1);

    public ChangeEntityValidationInfo findDependedEntities(JwtSecurityUser var1, CustomPrompt var2);
}

