/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.assistance.agent.view;

import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.assistance.agent.AiAgentType;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteDataField;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteDateGroupingItem;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteViewConfig;
import org.thingsboard.trendz.domain.assistance.agent.lite.viewconfig.LitePieChartViewConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewType;
import org.thingsboard.trendz.service.assistance.agent.AgentService;
import org.thingsboard.trendz.service.assistance.agent.view.ViewExpertAgent;
import org.thingsboard.trendz.service.assistance.agent.view.domain.ViewExpertRequest;
import org.thingsboard.trendz.service.assistance.agent.view.domain.ViewExpertResult;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceContext;

@Service
public class PieChartViewExpertAgent
implements ViewExpertAgent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PieChartViewExpertAgent.class);
    private final AgentService agentService;

    @Autowired
    public PieChartViewExpertAgent(AgentService agentService) {
        this.agentService = agentService;
    }

    public AiAgentType getAgentType() {
        return AiAgentType.PIE_CHART_VIEW_EXPERT;
    }

    public ViewExpertResult generateView(ViewAssistanceContext context, Set<LiteDataField> dataFields, Set<LiteDateGroupingItem> dateGroupingItems) {
        ViewExpertRequest viewExpertRequest = ViewExpertRequest.builder().userQuestion(context.getQuestion()).myPreviousResponseWas(this.agentService.preparePreviousAnswerInfo(context, this.getAgentType())).liteDataFields(dataFields).dateGroupingItems(dateGroupingItems).build();
        LitePieChartViewConfig litePieChartViewConfig = (LitePieChartViewConfig)this.agentService.processAiRequest(context.getUser(), context.getAgentMetadataContainer(), (Object)viewExpertRequest, AiAgentType.PIE_CHART_VIEW_EXPERT);
        LiteViewConfig liteViewConfig = this.mapLitePieChartViewConfigToLiteViewConfig(litePieChartViewConfig);
        return ((ViewExpertResult.ViewExpertResultBuilder)((ViewExpertResult.ViewExpertResultBuilder)ViewExpertResult.builder().liteViewConfig(liteViewConfig).comment(litePieChartViewConfig.getX_comment())).status(litePieChartViewConfig.getX_status())).build();
    }

    private LiteViewConfig mapLitePieChartViewConfigToLiteViewConfig(LitePieChartViewConfig litePieChartViewConfig) {
        return LiteViewConfig.builder().xAxis(Collections.emptyList()).yAxis(litePieChartViewConfig.getSectorValues()).series(litePieChartViewConfig.getSectorNames()).viewType(ViewType.PIE).build();
    }
}

