/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.assistance.agent.topologymapper;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.assistance.agent.AgentResponseStatus;
import org.thingsboard.trendz.domain.assistance.agent.AiAgentType;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteBusinessEntityField;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteDataField;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteTopology;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.FieldQueryType;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.service.assistance.agent.AgentService;
import org.thingsboard.trendz.service.assistance.agent.TopologyMapper;
import org.thingsboard.trendz.service.assistance.agent.topologymapper.TopologyMapperExpertAgent;
import org.thingsboard.trendz.service.assistance.agent.topologymapper.domain.TopologyMapperExpertRequest;
import org.thingsboard.trendz.service.assistance.agent.topologymapper.domain.TopologyMapperExpertResponse;
import org.thingsboard.trendz.service.assistance.agent.topologymapper.domain.TopologyMapperExpertResult;
import org.thingsboard.trendz.service.assistance.agent.topologymapper.domain.TopologyMapperItem;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceContext;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceState;

@Service
public class TopologyMapperExpertAgentImpl
implements TopologyMapperExpertAgent {
    private final AgentService agentService;
    private final TopologyMapper topologyMapper;

    @Autowired
    public TopologyMapperExpertAgentImpl(AgentService agentService, TopologyMapper topologyMapper) {
        this.agentService = agentService;
        this.topologyMapper = topologyMapper;
    }

    public TopologyMapperExpertResult mapTopology(ViewAssistanceContext context, List<BusinessEntity> availableTopology, List<LiteDataField> fieldsForView, List<LiteDataField> fieldsForFilters) {
        ViewAssistanceState state = context.getViewAssistanceState();
        if (ObjectUtils.allNotNull((Object[])new Object[]{state.getTopologyMapper(), state.getView(), state.getFilter()})) {
            return state.getTopologyMapper();
        }
        TopologyMapperExpertResult topologyMapper = this.process(context, availableTopology, fieldsForView, fieldsForFilters);
        if (state.getTopologyMapper() != null) {
            if (state.getFilter() == null && state.getView() != null) {
                topologyMapper.setFieldsForView(state.getTopologyMapper().getFieldsForView());
            }
            if (state.getFilter() != null && state.getView() == null) {
                topologyMapper.setFieldsForFilters(state.getTopologyMapper().getFieldsForFilters());
            }
        }
        state.setTopologyMapper(topologyMapper);
        return state.getTopologyMapper();
    }

    private TopologyMapperExpertResult process(ViewAssistanceContext context, List<BusinessEntity> availableTopology, List<LiteDataField> fieldsForView, List<LiteDataField> fieldsForFilters) {
        LiteTopology liteTopology = this.topologyMapper.convertBusinessEntities(availableTopology);
        String topology = this.topologyMapper.transformInputData(liteTopology, false);
        String fieldsToMap = this.prepareFieldsToMap(fieldsForView, fieldsForFilters);
        TopologyMapperExpertRequest topologyMapperExpertRequest = TopologyMapperExpertRequest.builder().myPreviousResponseWas(this.agentService.preparePreviousAnswerInfo(context, AiAgentType.TOPOLOGY_MAPPER_EXPERT))._1_question(context.getQuestion())._2_topology(topology)._3_fieldsToMap(fieldsToMap).build();
        TopologyMapperExpertResponse topologyMapperExpertResponse = (TopologyMapperExpertResponse)this.agentService.processAiRequest(context.getUser(), context.getAgentMetadataContainer(), (Object)topologyMapperExpertRequest, AiAgentType.TOPOLOGY_MAPPER_EXPERT);
        Map sourceMap = topologyMapperExpertResponse.getResponse().stream().collect(Collectors.toMap(TopologyMapperItem::getIndex, Function.identity(), (e1, e2) -> e1));
        List missingViews = this.populateLiteDataField(sourceMap, fieldsForView, liteTopology, availableTopology, i -> i * 2);
        List missingFilters = this.populateLiteDataField(sourceMap, fieldsForFilters, liteTopology, availableTopology, i -> i * 2 - 1);
        if (!missingViews.isEmpty() || !missingFilters.isEmpty()) {
            return ((TopologyMapperExpertResult.TopologyMapperExpertResultBuilder)((TopologyMapperExpertResult.TopologyMapperExpertResultBuilder)TopologyMapperExpertResult.builder().status(AgentResponseStatus.ERROR)).comment("Cannot find fields for filters (1) and views (2): " + this.prepareFieldsToMap(missingViews, missingFilters))).build();
        }
        return ((TopologyMapperExpertResult.TopologyMapperExpertResultBuilder)((TopologyMapperExpertResult.TopologyMapperExpertResultBuilder)TopologyMapperExpertResult.builder().status(AgentResponseStatus.SUCCESS)).comment(topologyMapperExpertResponse.getX_comment())).fieldsForView(this.reduceLiteDataFields(fieldsForView)).fieldsForFilters(new HashSet<LiteDataField>(fieldsForFilters)).build();
    }

    private List<LiteDataField> populateLiteDataField(Map<Integer, TopologyMapperItem> sourceMap, List<LiteDataField> fields, LiteTopology liteTopology, List<BusinessEntity> businessEntities, Function<Integer, Integer> indexMapper) {
        AtomicInteger counter = new AtomicInteger();
        return fields.stream().map(liteDataField -> {
            TopologyMapperItem topologyMapperItem = (TopologyMapperItem)sourceMap.get(indexMapper.apply(counter.addAndGet(1)));
            if (topologyMapperItem == null) {
                return liteDataField;
            }
            liteDataField.setX_businessEntityName(topologyMapperItem.getTableName());
            liteDataField.getField().setName(topologyMapperItem.getColumnName());
            UUID beUUID = (UUID)liteTopology.getEntityNameToIdMap().get(topologyMapperItem.getTableName());
            Optional<BusinessEntityField> optBusinessEntityField = businessEntities.stream().filter(i -> i.getId().equals(beUUID)).map(BusinessEntity::getFields).flatMap(Collection::stream).filter(i -> i.getName().equals(topologyMapperItem.getColumnName())).findAny();
            if (optBusinessEntityField.isEmpty()) {
                return liteDataField;
            }
            liteDataField.getField().setType(optBusinessEntityField.get().getType());
            liteDataField.getField().setQueryType(optBusinessEntityField.get().getQuery().getQueryType());
            return null;
        }).filter(Objects::nonNull).toList();
    }

    private String prepareFieldsToMap(List<LiteDataField> fieldsForView, List<LiteDataField> fieldsForFilters) {
        AtomicInteger viewCounter = new AtomicInteger();
        AtomicInteger filterCounter = new AtomicInteger(-1);
        return "\n" + fieldsForView.stream().map(dataField -> "%d - %s (%s:%s) : %s".formatted(viewCounter.addAndGet(2), dataField.getField().getName(), dataField.getField().getType(), dataField.getField().getQueryType(), dataField.getField().getDescription())).collect(Collectors.joining("\n")) + fieldsForFilters.stream().map(dataField -> "%d - %s (%s:%s) : %s".formatted(filterCounter.addAndGet(2), dataField.getField().getName(), dataField.getField().getType(), dataField.getField().getQueryType(), dataField.getField().getDescription())).collect(Collectors.joining("\n"));
    }

    private Set<LiteDataField> reduceLiteDataFields(List<LiteDataField> liteDataFields) {
        HashSet<LiteDataField> result = new HashSet<LiteDataField>(liteDataFields);
        Set fieldsToSimplify = liteDataFields.stream().filter(field -> field.getAggregation() == FieldAggregation.COUNT).filter(field -> field.getField().getName().contains(field.getX_businessEntityName())).collect(Collectors.toSet());
        Map sourceMap = liteDataFields.stream().collect(Collectors.groupingBy(LiteDataField::getX_businessEntityName, Collectors.groupingBy(LiteDataField::getField, Collectors.mapping(LiteDataField::getAggregation, Collectors.toSet()))));
        Set newLiteDataFields = fieldsToSimplify.stream().map(field -> {
            Map fieldsMap = (Map)sourceMap.get(field.getX_businessEntityName());
            String fieldName = fieldsMap.keySet().stream().filter(key -> key.getQueryType() != FieldQueryType.TELEMETRY).map(LiteBusinessEntityField::getName).filter(name -> !name.contains(field.getX_businessEntityName())).findAny().orElse(null);
            if (fieldName == null) {
                return field;
            }
            return LiteDataField.builder().aggregation(FieldAggregation.COUNT).x_businessEntityName(field.getX_businessEntityName()).field(LiteBusinessEntityField.builder().name(fieldName).description("Count of: " + field.getX_businessEntityName()).type(FieldType.NUMERIC).queryType(FieldQueryType.ATTRIBUTE).build()).build();
        }).collect(Collectors.toSet());
        result.removeAll(fieldsToSimplify);
        result.addAll(newLiteDataFields);
        result.stream().filter(liteDataField -> liteDataField.getAggregation() == FieldAggregation.NONE).forEach(liteDataField -> liteDataField.setAggregation(FieldAggregation.UNIQ));
        return result;
    }
}

