/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.assistance.agent.state;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.assistance.agent.AgentResponseStatus;
import org.thingsboard.trendz.domain.assistance.agent.AiAgentType;
import org.thingsboard.trendz.service.assistance.agent.AgentService;
import org.thingsboard.trendz.service.assistance.agent.state.StateManagerExpertAgent;
import org.thingsboard.trendz.service.assistance.agent.state.domain.StateManagerExpertRequest;
import org.thingsboard.trendz.service.assistance.agent.state.domain.StateManagerExpertResponse;
import org.thingsboard.trendz.service.assistance.agent.state.domain.StateManagerExpertResult;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceContext;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceState;

@Service
public class StateManagerExpertAgentImpl
implements StateManagerExpertAgent {
    private final AgentService agentService;

    @Autowired
    public StateManagerExpertAgentImpl(AgentService agentService) {
        this.agentService = agentService;
    }

    public StateManagerExpertResult analyzeCache(ViewAssistanceContext context, String previousQuestion, String specification) {
        ViewAssistanceState state = context.getViewAssistanceState();
        StateManagerExpertResult stateManager = this.process(context, previousQuestion, specification);
        if (stateManager.isViewTypeChanged()) {
            state.setGeneralViewSettings(null);
            state.setDateGrouper(null);
        }
        if (stateManager.isDatePickerChanged()) {
            state.setDatePicker(null);
        }
        if (stateManager.isFiltersChanged() && stateManager.isViewFieldsChanged()) {
            state.setTopologyMapper(null);
            state.setGroupFinder(null);
        }
        if (stateManager.isFiltersChanged()) {
            state.setFilter(null);
            state.setFilterQueryAnalyzer(null);
        }
        if (stateManager.isViewFieldsChanged()) {
            state.setView(null);
            state.setQueryAnalyzer(null);
        }
        if (stateManager.isDateGroupingsChanged()) {
            state.setDateGrouper(null);
        }
        return stateManager;
    }

    private StateManagerExpertResult process(ViewAssistanceContext context, String previousQuestion, String specification) {
        if (previousQuestion == null || specification == null) {
            return ((StateManagerExpertResult.StateManagerExpertResultBuilder)((StateManagerExpertResult.StateManagerExpertResultBuilder)StateManagerExpertResult.builder().comment("Has no AI")).status(AgentResponseStatus.SUCCESS)).isViewFieldsChanged(true).isFiltersChanged(true).isDateGroupingsChanged(true).isDatePickerChanged(true).build();
        }
        StateManagerExpertRequest stateManagerExpertRequest = StateManagerExpertRequest.builder().oldQuestion(previousQuestion).specification(specification).newQuestion(context.getQuestion()).build();
        StateManagerExpertResponse stateManagerExpertResponse = (StateManagerExpertResponse)this.agentService.processAiRequest(context.getUser(), context.getAgentMetadataContainer(), (Object)stateManagerExpertRequest, AiAgentType.STATE_MANAGER_EXPERT);
        return ((StateManagerExpertResult.StateManagerExpertResultBuilder)((StateManagerExpertResult.StateManagerExpertResultBuilder)StateManagerExpertResult.builder().comment(stateManagerExpertResponse.get_comment())).status(stateManagerExpertResponse.get_status())).isViewTypeChanged(stateManagerExpertResponse.isViewTypeChanged()).isViewFieldsChanged(stateManagerExpertResponse.isViewFieldsChanged()).isFiltersChanged(stateManagerExpertResponse.isFiltersChanged()).isDateGroupingsChanged(stateManagerExpertResponse.isDateGroupingsChanged()).isDatePickerChanged(stateManagerExpertResponse.isDatePickerChanged()).build();
    }
}

