/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.assistance.agent.simpleoutput;

import java.time.ZoneId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.assistance.agent.AgentResponseStatus;
import org.thingsboard.trendz.domain.assistance.agent.AiAgentType;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.measurement.MeasurementReport;
import org.thingsboard.trendz.domain.runtime.ViewReport;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.assistance.agent.AgentService;
import org.thingsboard.trendz.service.assistance.agent.memorymanager.domain.MemoryManagerExpertRequest;
import org.thingsboard.trendz.service.assistance.agent.simpleoutput.SimpleOutputExpertAgent;
import org.thingsboard.trendz.service.assistance.agent.simpleoutput.domain.SimpleOutputExpertRequest;
import org.thingsboard.trendz.service.assistance.agent.simpleoutput.domain.SimpleOutputExpertResponse;
import org.thingsboard.trendz.service.assistance.agent.simpleoutput.domain.SimpleOutputExpertResult;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceContext;
import org.thingsboard.trendz.service.assistance.view.ViewMapper;
import org.thingsboard.trendz.service.view.ViewBuildingResult;
import org.thingsboard.trendz.service.view.ViewBuildingService;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Mono;

@Service
public class SimpleOutputExpertAgentImpl
implements SimpleOutputExpertAgent {
    private final AgentService agentService;
    private final ViewMapper viewMapper;
    private final ViewBuildingService viewBuildingService;

    @Autowired
    public SimpleOutputExpertAgentImpl(AgentService agentService, ViewMapper viewMapper, ViewBuildingService viewBuildingService) {
        this.agentService = agentService;
        this.viewMapper = viewMapper;
        this.viewBuildingService = viewBuildingService;
    }

    public SimpleOutputExpertResult processUserQuestion(ViewAssistanceContext context) {
        MemoryManagerExpertRequest memoryManagerExpertRequest = context.getAgentMetadataContainer().stream().filter(i -> i.getAiAgentType() == AiAgentType.MEMORY_MANAGER_EXPERT).findAny().map(i -> (MemoryManagerExpertRequest)i.getAiRequest()).orElseThrow();
        String stringViewConfig = this.viewMapper.mapViewConfigToString(context.getPreviousViewConfig(), context.getUser());
        String viewReport = context.getPreviousViewConfig() == null ? "No Data" : this.getDataFromViewConfig(context.getPreviousViewConfig(), context.getUser(), context.getZoneId());
        SimpleOutputExpertRequest request = SimpleOutputExpertRequest.builder()._1_userQueryOnWitchViewWasBuilt(memoryManagerExpertRequest.get_2_question())._2_generatedView(stringViewConfig)._3_viewData(viewReport)._4_userInput(memoryManagerExpertRequest.get_3_specification()).build();
        SimpleOutputExpertResponse simpleOutputExpertResponse = (SimpleOutputExpertResponse)this.agentService.processAiRequest(context.getUser(), context.getAgentMetadataContainer(), (Object)request, AiAgentType.SIMPLE_OUTPUT_EXPERT);
        return ((SimpleOutputExpertResult.SimpleOutputExpertResultBuilder)((SimpleOutputExpertResult.SimpleOutputExpertResultBuilder)SimpleOutputExpertResult.builder().response(simpleOutputExpertResponse.getAnswer()).viewConfig(context.getPreviousViewConfig()).status(AgentResponseStatus.SUCCESS)).comment("")).build();
    }

    private String getDataFromViewConfig(ViewConfig viewConfig, JwtSecurityUser user, ZoneId zoneId) {
        return (String)DonReactive.block((Mono)this.viewBuildingService.buildView(viewConfig, user, new MeasurementReport()).map(ViewBuildingResult::getViewReport).map(ViewReport::getRows).map(rows -> this.viewMapper.mapViewReportToString(viewConfig, rows, zoneId)));
    }
}

