/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.assistance.agent.resultanalyzer;

import java.time.ZoneId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.assistance.agent.AgentResponseStatus;
import org.thingsboard.trendz.domain.assistance.agent.AiAgentType;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.measurement.MeasurementReport;
import org.thingsboard.trendz.domain.runtime.ViewReport;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.assistance.agent.AgentService;
import org.thingsboard.trendz.service.assistance.agent.memorymanager.domain.MemoryManagerExpertRequest;
import org.thingsboard.trendz.service.assistance.agent.resultanalyzer.ResultAnalyzerExpertAgent;
import org.thingsboard.trendz.service.assistance.agent.resultanalyzer.domain.ResultAnalyzerExpertRequest;
import org.thingsboard.trendz.service.assistance.agent.resultanalyzer.domain.ResultAnalyzerExpertResponse;
import org.thingsboard.trendz.service.assistance.agent.resultanalyzer.domain.ResultAnalyzerExpertResult;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceContext;
import org.thingsboard.trendz.service.assistance.view.ViewMapper;
import org.thingsboard.trendz.service.view.ViewBuildingResult;
import org.thingsboard.trendz.service.view.ViewBuildingService;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Mono;

@Service
public class ResultAnalyzerExpertAgentImpl
implements ResultAnalyzerExpertAgent {
    private final ViewBuildingService viewBuildingService;
    private final AgentService agentService;
    private final ViewMapper viewMapper;

    @Autowired
    public ResultAnalyzerExpertAgentImpl(ViewBuildingService viewBuildingService, AgentService agentService, ViewMapper viewMapper) {
        this.viewBuildingService = viewBuildingService;
        this.agentService = agentService;
        this.viewMapper = viewMapper;
    }

    public ResultAnalyzerExpertResult processUserQuestion(ViewAssistanceContext context, ViewConfig newConfig) {
        String newViewConfigString = this.viewMapper.mapViewConfigToString(newConfig, context.getUser());
        String oldViewConfig = this.viewMapper.mapViewConfigToString(context.getPreviousViewConfig(), context.getUser());
        MemoryManagerExpertRequest memoryManagerExpertRequest = context.getAgentMetadataContainer().stream().filter(i -> i.getAiAgentType() == AiAgentType.MEMORY_MANAGER_EXPERT).findAny().map(i -> (MemoryManagerExpertRequest)i.getAiRequest()).orElseThrow();
        String viewReport = this.getDataFromViewConfig(newConfig, context.getUser(), context.getZoneId());
        ResultAnalyzerExpertRequest resultAnalyzerExpertRequest = ResultAnalyzerExpertRequest.builder()._1_previousView(oldViewConfig)._2_previousQuestion(memoryManagerExpertRequest.get_2_question())._3_specification(memoryManagerExpertRequest.get_3_specification())._4_generatedView(newViewConfigString)._5_dataFromThisView(viewReport).build();
        ResultAnalyzerExpertResponse resultAnalyzerExpertResponse = (ResultAnalyzerExpertResponse)this.agentService.processAiRequest(context.getUser(), context.getAgentMetadataContainer(), (Object)resultAnalyzerExpertRequest, AiAgentType.RESULT_ANALYZER_EXPERT);
        return ((ResultAnalyzerExpertResult.ResultAnalyzerExpertResultBuilder)((ResultAnalyzerExpertResult.ResultAnalyzerExpertResultBuilder)ResultAnalyzerExpertResult.builder().response(resultAnalyzerExpertResponse.getResponse()).status(AgentResponseStatus.SUCCESS)).comment("")).build();
    }

    private String getDataFromViewConfig(ViewConfig viewConfig, JwtSecurityUser user, ZoneId zoneId) {
        return (String)DonReactive.block((Mono)this.viewBuildingService.buildView(viewConfig, user, new MeasurementReport()).map(ViewBuildingResult::getViewReport).map(ViewReport::getRows).map(rows -> this.viewMapper.mapViewReportToString(viewConfig, rows, zoneId)).onErrorReturn((Object)"Cannot build view"));
    }
}

