/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.assistance.agent.queryanalyzer;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.trendz.domain.assistance.agent.AiAgentType;
import org.thingsboard.trendz.service.assistance.agent.AgentService;
import org.thingsboard.trendz.service.assistance.agent.queryanalyzer.QueryAnalyzerExpertAgent;
import org.thingsboard.trendz.service.assistance.agent.queryanalyzer.domain.QueryAnalyzerExpertRequest;
import org.thingsboard.trendz.service.assistance.agent.queryanalyzer.domain.QueryAnalyzerExpertResponse;
import org.thingsboard.trendz.service.assistance.agent.queryanalyzer.domain.QueryAnalyzerExpertResult;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceContext;

public abstract class QueryAnalyzerExpertAgentBase
implements QueryAnalyzerExpertAgent {
    private final AgentService agentService;

    @Autowired
    public QueryAnalyzerExpertAgentBase(AgentService agentService) {
        this.agentService = agentService;
    }

    public QueryAnalyzerExpertResult analyze(ViewAssistanceContext context) {
        String prepared = this.agentService.preparePreviousAnswerInfo(context, this.getAgentType());
        QueryAnalyzerExpertRequest analyzerExpertResult = QueryAnalyzerExpertRequest.builder().question(context.getQuestion()).myPreviousResponseWas(prepared).build();
        QueryAnalyzerExpertResponse queryAnalyzerExpertResponse = (QueryAnalyzerExpertResponse)this.agentService.processAiRequest(context.getUser(), context.getAgentMetadataContainer(), (Object)analyzerExpertResult, this.getAgentType());
        Set fields = Objects.requireNonNullElse(queryAnalyzerExpertResponse.getFields(), Collections.emptySet()).stream().peek(i -> i.setX_businessEntityName(null)).collect(Collectors.toSet());
        return ((QueryAnalyzerExpertResult.QueryAnalyzerExpertResultBuilder)((QueryAnalyzerExpertResult.QueryAnalyzerExpertResultBuilder)QueryAnalyzerExpertResult.builder().fields(fields).comment(queryAnalyzerExpertResponse.getX_1_1_comment())).status(queryAnalyzerExpertResponse.getX_1_2_status())).build();
    }

    public abstract AiAgentType getAgentType();
}

