/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.assistance.agent.memorymanager;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.assistance.agent.AgentResponseStatus;
import org.thingsboard.trendz.domain.assistance.agent.AiAgentType;
import org.thingsboard.trendz.service.assistance.agent.AgentService;
import org.thingsboard.trendz.service.assistance.agent.memorymanager.MemoryManagerExpertAgent;
import org.thingsboard.trendz.service.assistance.agent.memorymanager.domain.MemoryManagerExpertRequest;
import org.thingsboard.trendz.service.assistance.agent.memorymanager.domain.MemoryManagerExpertResponse;
import org.thingsboard.trendz.service.assistance.agent.memorymanager.domain.MemoryManagerExpertResult;
import org.thingsboard.trendz.service.assistance.agent.memorymanager.domain.MemoryManagerMessageItem;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceContext;

@Service
public class MemoryManagerExpertAgentImpl
implements MemoryManagerExpertAgent {
    private final AgentService agentService;

    @Autowired
    public MemoryManagerExpertAgentImpl(AgentService agentService) {
        this.agentService = agentService;
    }

    public MemoryManagerExpertResult processUserQuestion(ViewAssistanceContext context) {
        List<Pair> questionAnswerPairs = context.getHistory().stream().map(chatMessageLite -> Pair.of((Object)chatMessageLite.getUserQuestion(), (Object)chatMessageLite.getAiAnswer())).toList();
        List<MemoryManagerMessageItem> res = IntStream.range(0, questionAnswerPairs.size() - 1).mapToObj(i -> MemoryManagerMessageItem.builder().userAnswer((String)((Pair)questionAnswerPairs.get(i + 1)).getLeft()).ourAiQuestionToUser(((Pair)questionAnswerPairs.get(i)).getRight() == null ? "Build successful, what else to add?" : (String)((Pair)questionAnswerPairs.get(i)).getRight()).build()).toList();
        String history = res.isEmpty() ? null : "User query: %s\n%s".formatted(questionAnswerPairs.get(0).getLeft(), res.subList(0, res.size() - 1).stream().map(i -> "\n - (our question to user) %s\n - (user answer) %s".formatted(i.getOurAiQuestionToUser(), i.getUserAnswer())).collect(Collectors.joining()));
        String question = StringUtils.isEmpty((CharSequence)context.getViewAssistanceState().getAiMemory()) ? (String)questionAnswerPairs.get(0).getLeft() : context.getViewAssistanceState().getAiMemory();
        String specification = res.isEmpty() ? null : " - (our question to user) %s\n - (user answer) %s".formatted(res.get(res.size() - 1).getOurAiQuestionToUser(), res.get(res.size() - 1).getUserAnswer());
        MemoryManagerExpertRequest memoryManagerExpertRequest = MemoryManagerExpertRequest.builder()._0_chatSummary(context.getChatSummary())._1_history(history)._2_question(question)._3_specification(specification).build();
        MemoryManagerExpertResponse memoryManagerExpertResponse = (MemoryManagerExpertResponse)this.agentService.processAiRequest(context.getUser(), context.getAgentMetadataContainer(), (Object)memoryManagerExpertRequest, AiAgentType.MEMORY_MANAGER_EXPERT);
        if (memoryManagerExpertResponse.getGeneralQuestion() != null && !memoryManagerExpertResponse.getGeneralQuestion().isEmpty()) {
            context.getViewAssistanceState().setAiMemory(memoryManagerExpertResponse.getGeneralQuestion());
        }
        context.setChatSummary(memoryManagerExpertResponse.getNewChatSummary());
        return ((MemoryManagerExpertResult.MemoryManagerExpertResultBuilder)((MemoryManagerExpertResult.MemoryManagerExpertResultBuilder)MemoryManagerExpertResult.builder().previousQuestion(question).specification(specification).generalQuestion(memoryManagerExpertResponse.getGeneralQuestion()).status(AgentResponseStatus.SUCCESS)).comment(memoryManagerExpertResponse.get_comment())).build();
    }
}

