/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.assistance.agent;

import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.service.Result;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.assistance.metadata.CustomPromptMetadataDao;
import org.thingsboard.trendz.domain.assistance.agent.AgentMetadata;
import org.thingsboard.trendz.domain.assistance.agent.AiAgentType;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.assistance.agent.AgentMetadataService;
import org.thingsboard.trendz.service.assistance.token.TokenUsageService;
import org.thingsboard.trendz.tools.json.JsonUtils;

@Service
public class AgentMetadataServiceImpl
implements AgentMetadataService {
    private final TokenUsageService tokenUsageService;
    private final CustomPromptMetadataDao customPromptMetadataDao;

    @Autowired
    public AgentMetadataServiceImpl(TokenUsageService tokenUsageService, CustomPromptMetadataDao customPromptMetadataDao) {
        this.tokenUsageService = tokenUsageService;
        this.customPromptMetadataDao = customPromptMetadataDao;
    }

    public void extractMetadata(Result<?> aiResponse, Object aiRequest, long requestDurationNanos, AiAgentType aiAgentType, JwtSecurityUser user, List<AgentMetadata> agentMetadataList, String modelName) {
        TokenUsage tokenUsage = aiResponse.tokenUsage();
        AgentMetadata agentMetadata = AgentMetadata.builder().aiAgentType(aiAgentType).aiRequest(this.deepClone(aiRequest)).aiResponse(this.deepClone(aiResponse.content())).inputTokenUsage(tokenUsage.inputTokenCount().intValue()).outputTokenUsage(tokenUsage.outputTokenCount().intValue()).modelName(modelName).finishReason(aiResponse.finishReason()).requestDurationNanos(requestDurationNanos).build();
        this.tokenUsageService.use(agentMetadata, user);
        agentMetadataList.add(agentMetadata);
    }

    public void saveCustomPromptMetadata(String prompt, String data, Result<String> aiResponse, long requestDurationNanos, String modelName, JwtSecurityUser user) {
        TokenUsage tokenUsage = aiResponse.tokenUsage();
        AgentMetadata agentMetadata = AgentMetadata.builder().aiAgentType(AiAgentType.CUSTOM_PROMPT_EXPERT).inputTokenUsage(tokenUsage.inputTokenCount().intValue()).outputTokenUsage(tokenUsage.outputTokenCount().intValue()).modelName(modelName).finishReason(aiResponse.finishReason()).requestDurationNanos(requestDurationNanos).build();
        this.tokenUsageService.use(agentMetadata, user);
        this.customPromptMetadataDao.save(prompt, data, (String)aiResponse.content(), user, requestDurationNanos);
    }

    private <T> T deepClone(T object) {
        String json = JsonUtils.toJson(object);
        return (T)JsonUtils.fromJson((String)json, object.getClass());
    }
}

