/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.alarm;

import com.google.common.collect.Lists;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.alarm.AlarmStatus;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.domain.alarm.AlarmAggregatedInfo;
import org.thingsboard.trendz.domain.alarm.AlarmCreateRequest;
import org.thingsboard.trendz.domain.alarm.AlarmReport;
import org.thingsboard.trendz.domain.base.TimeRange;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.exception.TrendzInternalException;
import org.thingsboard.trendz.exception.service.provider.TbWebClientException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.alarm.alarmfield.TbAlarmData;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.service.provider.TbCustomerRelationService;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.view.ItemService;
import org.thingsboard.trendz.tools.DateTimeUtils;
import org.thingsboard.trendz.tools.json.JsonUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class AlarmService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlarmService.class);
    private final BusinessEntityService businessEntityService;
    private final ItemService itemService;
    private final TbRestDataSource tbRestDataSource;
    private final TbCustomerRelationService tbCustomerRelationService;

    @Autowired
    public AlarmService(BusinessEntityService businessEntityService, ItemService itemService, TbRestDataSource dataSource, TbCustomerRelationService tbCustomerRelationService) {
        this.businessEntityService = businessEntityService;
        this.itemService = itemService;
        this.tbRestDataSource = dataSource;
        this.tbCustomerRelationService = tbCustomerRelationService;
    }

    public Mono<AlarmReport> buildAlarmReport(DatePickerConfig datePickerConfig, String tzName, JwtSecurityUser user) {
        return Mono.just((Object)new Object()).flatMap(o -> {
            log.info("Alarm Report: start report building");
            long now = System.currentTimeMillis();
            ZoneId zoneId = ZoneId.of(tzName);
            Map customerDictionary = this.tbCustomerRelationService.getCustomerDictionary(user);
            TimeRange timeRange = datePickerConfig.buildStartEndPair(zoneId, now);
            String rangeBy = datePickerConfig.getRangeBy();
            return Mono.just((Object)user).map(arg_0 -> ((BusinessEntityService)this.businessEntityService).getAllEntities(arg_0)).doOnNext(allEntities -> log.info("Alarm Report: {} entities were found.", (Object)allEntities.size())).flatMapIterable(i -> i).filter(businessEntity -> !businessEntity.getQuery().getEntityType().equals((Object)BusinessEntityType.EXTERNAL)).flatMap(businessEntity -> {
                BusinessEntityType entityType = businessEntity.getQuery().getEntityType();
                log.info("Alarm Report: loading alarms for {} [{}]", (Object)businessEntity.getName(), (Object)entityType);
                return this.itemService.loadItems(businessEntity, null, null, null, user).flatMap(item -> this.tbRestDataSource.loadAlarms(null, entityType, item.getId(), user, timeRange.getStartTs(), timeRange.getEndTs(), 100000).flatMapIterable(response -> Lists.newArrayList((Iterator)JsonUtils.toNodeFromRaw((String)response).get("data").elements())).map(TbAlarmData::mapFromJson).map(tbAlarmData -> Pair.of((Object)businessEntity, (Object)Pair.of((Object)item, (Object)tbAlarmData))).collectList().defaultIfEmpty(Collections.emptyList())).collectList().doOnNext(list -> log.info("Alarm Report: {} alarms loaded for {} [{}]", new Object[]{list.size(), businessEntity.getName(), entityType})).defaultIfEmpty(Collections.emptyList());
            }).collectList().defaultIfEmpty(Collections.emptyList()).doOnNext(tupleList -> log.info("Alarm Report: loading finished")).map(tupleList -> {
                Map<UUID, String> entityIdToEntityNameMap = tupleList.stream().flatMap(Collection::stream).flatMap(Collection::stream).map(Pair::getLeft).collect(Collectors.toMap(BusinessEntity::getId, BusinessEntity::getName, (o1, o2) -> o1));
                Map<UUID, String> itemIdToItemNameMap = tupleList.stream().flatMap(Collection::stream).flatMap(Collection::stream).map(Pair::getRight).map(Pair::getLeft).collect(Collectors.toMap(Item::getId, Item::getName, (o1, o2) -> o1));
                Map<UUID, String> itemIdToItemLabelMap = tupleList.stream().flatMap(Collection::stream).flatMap(Collection::stream).map(Pair::getRight).map(Pair::getLeft).collect(Collectors.toMap(Item::getId, item -> Optional.ofNullable(item.getLabel()).orElse("No label"), (o1, o2) -> o1));
                List alarmDataList = tupleList.stream().flatMap(Collection::stream).flatMap(Collection::stream).map(Pair::getRight).map(Pair::getRight).collect(Collectors.toList());
                Map<UUID, String> customerIdToCustomerName = alarmDataList.stream().map(TbAlarmData::getCustomerId).filter(customerDictionary::containsKey).map(customerId -> Map.entry(customerId, (String)customerDictionary.get(customerId))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (o1, o2) -> o1));
                Map alarmIdToEntityIdMap = tupleList.stream().flatMap(Collection::stream).flatMap(Collection::stream).map(tuple -> {
                    TbAlarmData alarmData = (TbAlarmData)((Pair)tuple.getRight()).getRight();
                    BusinessEntity businessEntity = (BusinessEntity)tuple.getLeft();
                    return Map.entry(alarmData.getId(), businessEntity.getId());
                }).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toSet())));
                Map alarmAggregatedInfo = this.aggregateRawAlarms(alarmDataList, rangeBy, zoneId, alarmIdToEntityIdMap);
                log.info("Alarm Report: finish report building");
                return AlarmReport.builder().entityIdToEntityName(entityIdToEntityNameMap).customerIdToCustomerName(customerIdToCustomerName).itemIdToItemName(itemIdToItemNameMap).itemIdToItemLabel(itemIdToItemLabelMap).alarmAggregatedInfo(alarmAggregatedInfo).build();
            });
        });
    }

    public Mono<Boolean> deleteAll(JwtSecurityUser user, Set<UUID> alarmIds) {
        return Flux.fromStream(alarmIds.stream()).flatMap(alarmId -> this.tbRestDataSource.deleteTbAlarm(alarmId, user).onErrorResume(throwable -> this.processThrowable(throwable, (Object)true))).all(i -> i);
    }

    public Mono<Boolean> clearAll(JwtSecurityUser user, Set<UUID> alarmIds) {
        return Flux.fromStream(alarmIds.stream()).flatMap(alarmId -> this.tbRestDataSource.clearTbAlarm(alarmId, user).map(info -> true).onErrorResume(throwable -> this.processThrowable(throwable, (Object)true))).collectList().thenReturn((Object)true);
    }

    public Mono<Alarm> createAlarm(AlarmCreateRequest alarmCreateRequest, JwtSecurityUser user, UUID businessEntityId) {
        BusinessEntity businessEntity = this.businessEntityService.findEntityById(user, businessEntityId);
        boolean isDevice = businessEntity.getQuery().getEntityType() == BusinessEntityType.DEVICE;
        DeviceId originator = isDevice ? new DeviceId(alarmCreateRequest.getItemId()) : new AssetId(alarmCreateRequest.getItemId());
        Mono alarmMono = alarmCreateRequest.getAlarmId() != null ? this.tbRestDataSource.retrieveTbAlarm(alarmCreateRequest.getAlarmId(), user).doOnNext(alarm -> alarm.setCleared(!alarmCreateRequest.isActive())).onErrorResume(throwable -> this.processThrowable(throwable, (Object)new Alarm())) : Mono.just((Object)new Alarm());
        return alarmMono.flatMap(arg_0 -> this.lambda$createAlarm$27(user, (EntityId)originator, alarmCreateRequest, arg_0));
    }

    private Map<Long, AlarmAggregatedInfo> aggregateRawAlarms(List<TbAlarmData> alarmDataList, String rangeBy, ZoneId zoneId, Map<UUID, Set<UUID>> alarmIdToEntityIdMap) {
        HashMap<Long, List> groupedAlarmData = new HashMap<Long, List>();
        for (TbAlarmData data : alarmDataList) {
            Long groupKey = this.applyGroupFunction(rangeBy, data.getStartTs(), zoneId);
            groupedAlarmData.computeIfAbsent(groupKey, i -> new ArrayList()).add(data);
        }
        HashMap<Long, AlarmAggregatedInfo> tsToAggregatedInfoMap = new HashMap<Long, AlarmAggregatedInfo>();
        for (Map.Entry entry : groupedAlarmData.entrySet()) {
            long ts = (Long)entry.getKey();
            List alarmGroup = (List)entry.getValue();
            HashMap<UUID, Map> entityByTypeCount = new HashMap<UUID, Map>();
            HashMap<UUID, Integer> entityCount = new HashMap<UUID, Integer>();
            HashMap<UUID, Integer> customerCount = new HashMap<UUID, Integer>();
            HashMap<UUID, Integer> itemCount = new HashMap<UUID, Integer>();
            HashMap<AlarmSeverity, Integer> severityCount = new HashMap<AlarmSeverity, Integer>();
            HashMap<AlarmStatus, Integer> statusCount = new HashMap<AlarmStatus, Integer>();
            HashMap<String, Integer> typeCount = new HashMap<String, Integer>();
            int ackCountAll = 0;
            int clearCountAll = 0;
            double aggAckDurationAll = 0.0;
            double aggClearDurationAll = 0.0;
            HashMap<String, Integer> aggAckCount = new HashMap<String, Integer>();
            HashMap<String, Integer> aggClearCount = new HashMap<String, Integer>();
            HashMap<String, Double> aggAckDuration = new HashMap<String, Double>();
            HashMap<String, Double> aggClearDuration = new HashMap<String, Double>();
            for (TbAlarmData alarmData : alarmGroup) {
                Set<UUID> entityIdSet = alarmIdToEntityIdMap.get(alarmData.getId());
                for (UUID entityId : entityIdSet) {
                    Integer entityByTypeCountPrev = entityByTypeCount.computeIfAbsent(entityId, i -> new HashMap()).computeIfAbsent(alarmData.getType(), i -> 0);
                    Integer entityCountPrev = entityCount.computeIfAbsent(entityId, i -> 0);
                    Integer customerCountPrev = customerCount.computeIfAbsent(alarmData.getCustomerId(), i -> 0);
                    Integer itemCountPrev = itemCount.computeIfAbsent(alarmData.getItemId(), i -> 0);
                    Integer severityCountPrev = severityCount.computeIfAbsent(alarmData.getSeverity(), i -> 0);
                    Integer statusCountPrev = statusCount.computeIfAbsent(alarmData.getStatus(), i -> 0);
                    Integer typeCountPrev = typeCount.computeIfAbsent(alarmData.getType(), i -> 0);
                    ((Map)entityByTypeCount.get(entityId)).put(alarmData.getType(), entityByTypeCountPrev + 1);
                    entityCount.put(alarmData.getCustomerId(), entityCountPrev + 1);
                    customerCount.put(alarmData.getCustomerId(), customerCountPrev + 1);
                    itemCount.put(alarmData.getItemId(), itemCountPrev + 1);
                    severityCount.put(alarmData.getSeverity(), severityCountPrev + 1);
                    statusCount.put(alarmData.getStatus(), statusCountPrev + 1);
                    typeCount.put(alarmData.getType(), typeCountPrev + 1);
                }
                if (alarmData.getAckTs() != 0L) {
                    long ackDuration = alarmData.getAckTs() - alarmData.getStartTs();
                    Double aggAckDurationPrev = aggAckDuration.computeIfAbsent(alarmData.getType(), i -> 0.0);
                    Integer aggAckCountPrev = aggAckCount.computeIfAbsent(alarmData.getType(), i -> 0);
                    ++ackCountAll;
                    aggAckDurationAll += (double)ackDuration;
                    aggAckCount.put(alarmData.getType(), aggAckCountPrev + 1);
                    aggAckDuration.put(alarmData.getType(), aggAckDurationPrev + (double)ackDuration);
                }
                if (alarmData.getClearTs() == 0L) continue;
                long clearDuration = alarmData.getClearTs() - alarmData.getStartTs();
                Double aggClearDurationPrev = aggClearDuration.computeIfAbsent(alarmData.getType(), i -> 0.0);
                Integer aggClearCountPrev = aggClearCount.computeIfAbsent(alarmData.getType(), i -> 0);
                ++clearCountAll;
                aggClearDurationAll += (double)clearDuration;
                aggClearCount.put(alarmData.getType(), aggClearCountPrev + 1);
                aggClearDuration.put(alarmData.getType(), aggClearDurationPrev + (double)clearDuration);
            }
            aggAckDurationAll /= (double)ackCountAll;
            aggClearDurationAll /= (double)clearCountAll;
            for (String type : aggAckDuration.keySet()) {
                Double aggAckDurationPrev = (Double)aggAckDuration.get(type);
                aggAckDuration.put(type, aggAckDurationPrev / (double)((Integer)aggAckCount.get(type)).intValue());
            }
            for (String type : aggClearDuration.keySet()) {
                Double aggClearDurationPrev = (Double)aggClearDuration.get(type);
                aggClearDuration.put(type, aggClearDurationPrev / (double)((Integer)aggClearCount.get(type)).intValue());
            }
            AlarmAggregatedInfo aggregatedInfo = AlarmAggregatedInfo.builder().entityByTypeCount(entityByTypeCount).entityCount(entityCount).customerCount(customerCount).itemCount(itemCount).severityCount(severityCount).statusCount(statusCount).typeCount(typeCount).ackCountAll(ackCountAll).clearCountAll(clearCountAll).aggregatedAckDurationAll(aggAckDurationAll).aggregatedClearDurationAll(aggClearDurationAll).aggregatedAckCount(aggAckCount).aggregatedClearCount(aggClearCount).aggregatedAckDuration(aggAckDuration).aggregatedClearDuration(aggClearDuration).build();
            tsToAggregatedInfoMap.put(ts, aggregatedInfo);
        }
        return tsToAggregatedInfoMap;
    }

    private long applyGroupFunction(String rangeBy, long ts, ZoneId zoneId) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{rangeBy})) {
            ChronoUnit chronoUnit = switch (rangeBy) {
                case "minute" -> ChronoUnit.MINUTES;
                case "hour" -> ChronoUnit.HOURS;
                case "day" -> ChronoUnit.DAYS;
                case "week" -> ChronoUnit.WEEKS;
                case "month" -> ChronoUnit.MONTHS;
                default -> throw new TrendzInternalException("group function error");
            };
            return DateTimeUtils.extendedTruncateTo((long)ts, (ZoneId)zoneId, (ChronoUnit)chronoUnit);
        }
        throw new TrendzInternalException("group function error");
    }

    private <T> Mono<T> processThrowable(Throwable throwable, T defaultValue) {
        Throwable cause;
        if (throwable instanceof TbWebClientException && (cause = throwable.getCause()) instanceof WebClientResponseException.NotFound) {
            return Mono.just(defaultValue);
        }
        return Mono.error((Throwable)throwable);
    }

    private /* synthetic */ Mono lambda$createAlarm$27(JwtSecurityUser user, EntityId originator, AlarmCreateRequest alarmCreateRequest, Alarm alarm) {
        alarm.setTenantId(user.getTenant());
        alarm.setOriginator(originator);
        alarm.setSeverity(alarmCreateRequest.getAlarmSeverity());
        alarm.setStartTs(alarmCreateRequest.getTimeRange().getStartTs());
        alarm.setEndTs(alarmCreateRequest.getTimeRange().getEndTs());
        alarm.setType(alarmCreateRequest.getType());
        return this.tbRestDataSource.saveTbAlarm(alarm, user).flatMap(saved -> {
            if (alarmCreateRequest.isActive()) {
                return Mono.just((Object)saved);
            }
            return this.tbRestDataSource.clearTbAlarm(saved.getUuidId(), user).then(Mono.just((Object)saved));
        });
    }
}

