/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.security.provider;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.security.entity.AuthToken;
import org.thingsboard.trendz.security.entity.SecurityUser;
import org.thingsboard.trendz.security.service.TokenExtractor;
import org.thingsboard.trendz.security.token.JwtAuthenticationToken;

@Component
public class JwtAuthenticationProvider
implements AuthenticationProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JwtAuthenticationProvider.class);
    private final TokenExtractor tokenExtractor;

    @Autowired
    public JwtAuthenticationProvider(TokenExtractor tokenExtractor) {
        this.tokenExtractor = tokenExtractor;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        AuthToken authToken = (AuthToken)authentication.getCredentials();
        SecurityUser securityUser = this.tokenExtractor.parseAccessJwtToken(authToken);
        return new JwtAuthenticationToken(securityUser);
    }

    public boolean supports(Class<?> authentication) {
        return JwtAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

