/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.security.handler;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.Writer;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.trendz.security.entity.MfaAuthResponse;
import org.thingsboard.trendz.security.entity.SecurityUser;
import org.thingsboard.trendz.tools.json.JsonUtils;

@Component
public class RestAwareAuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        SecurityUser securityUser = (SecurityUser)authentication.getPrincipal();
        response.setStatus(HttpStatus.OK.value());
        response.setContentType("application/json");
        if (securityUser.getAuthority().equals((Object)Authority.PRE_VERIFICATION_TOKEN)) {
            JsonUtils.getObjectMapper().writeValue((Writer)response.getWriter(), (Object)new MfaAuthResponse(securityUser.getAuthToken()));
        } else {
            JsonUtils.getObjectMapper().writeValue((Writer)response.getWriter(), (Object)securityUser.getAuthToken());
        }
        this.clearAuthenticationAttributes(request);
    }

    protected final void clearAuthenticationAttributes(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        session.removeAttribute("SPRING_SECURITY_LAST_EXCEPTION");
    }
}

