/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.interceptor;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;
import org.thingsboard.trendz.domain.customize.CustomViewSettings;
import org.thingsboard.trendz.service.customize.CustomizationService;

@Component
@Order(value=1)
public class WhitelabelingRedirectionInterceptor
implements HandlerInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WhitelabelingRedirectionInterceptor.class);
    public static final String WHITELABELING_PREFIX_PARAMETER = "whitelabelingPrefix";
    public static final String WHITELABELING_NEW_PATH_ATTRIBUTE = "whitelabelingNewPath";
    private final CustomizationService customizationService;

    @Autowired
    public WhitelabelingRedirectionInterceptor(CustomizationService customizationService) {
        this.customizationService = customizationService;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String domain = request.getServerName();
        String path = this.getPath(request);
        String prefixParameter = (String)request.getAttribute(WHITELABELING_PREFIX_PARAMETER);
        if (prefixParameter == null) {
            String prefixSetting;
            CustomViewSettings settings = this.customizationService.getCustomViewSettings(domain);
            String prefixPath = this.getPrefix(path);
            if (prefixPath.equals(prefixSetting = settings.getUrl()) || prefixPath.equals("trendz") || prefixPath.equals("analytics")) {
                String newPath = StringUtils.replaceOnce((String)path, (String)(prefixPath + "/"), (String)"/");
                String newPrefix = this.getPrefix(this.removeFirstSlashIfPresent(newPath));
                if ("apiTrendz".equals(newPrefix)) {
                    response.sendError(403, "Access to API through whitelabeling prefix is forbidden!");
                    return false;
                }
                request.setAttribute(WHITELABELING_NEW_PATH_ATTRIBUTE, (Object)newPath);
                request.setAttribute(WHITELABELING_PREFIX_PARAMETER, (Object)prefixPath);
                RequestDispatcher dispatcher = request.getRequestDispatcher(newPath);
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
                return false;
            }
        }
        return true;
    }

    private String getPath(HttpServletRequest request) {
        String pathAttribute = request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE).toString();
        if (pathAttribute.isBlank() || pathAttribute.charAt(pathAttribute.length() - 1) == '/') {
            return pathAttribute;
        }
        return pathAttribute + "/";
    }

    private String getPrefix(String path) {
        String[] pathSplit = path.split("/");
        if (pathSplit.length == 0) {
            return "";
        }
        return pathSplit[0];
    }

    private String removeFirstSlashIfPresent(String path) {
        if (path.charAt(0) == '/') {
            return path.substring(1);
        }
        return path;
    }
}

