/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.interceptor;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.Base64;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

@Component
@Order(value=3)
public class StaticResourceProcessingInterceptor
implements HandlerInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StaticResourceProcessingInterceptor.class);
    private volatile String jsLibEtag;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof ResourceHttpRequestHandler) {
            String uriToFile = (String)request.getAttribute("whitelabelingNewPath");
            if (uriToFile == null) {
                log.warn("URI is null, fetch from request");
                uriToFile = request.getRequestURI();
            }
            if (uriToFile == null) {
                log.warn("URI is null, pass request anyway");
                return true;
            }
            String cleanUriToFile = this.clearUri(uriToFile);
            if (cleanUriToFile.endsWith("trendz-tb-lib.js.map")) {
                response.setStatus(404);
                return false;
            }
            if (cleanUriToFile.endsWith("trendz-tb-lib.js")) {
                Path pathToFile = Path.of(this.getClass().getClassLoader().getResource("resources" + cleanUriToFile).toURI());
                String actualTag = request.getHeader("If-None-Match");
                String expectedTag = this.getEtag(pathToFile);
                log.info("E-Tag expected: {}", (Object)expectedTag);
                log.info("E-Tag actual:   {}", (Object)actualTag);
                if (expectedTag.equals(actualTag)) {
                    response.setStatus(304);
                    return false;
                }
                response.setHeader("ETag", expectedTag);
            }
        }
        return true;
    }

    private String clearUri(String uri) {
        return uri.charAt(uri.length() - 1) == '/' ? uri.substring(0, uri.length() - 1) : uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEtag(Path pathToFile) throws Exception {
        if (this.jsLibEtag == null) {
            StaticResourceProcessingInterceptor staticResourceProcessingInterceptor = this;
            synchronized (staticResourceProcessingInterceptor) {
                if (this.jsLibEtag == null) {
                    this.jsLibEtag = this.generateETag(pathToFile);
                }
            }
        }
        return this.jsLibEtag;
    }

    private String generateETag(Path path) throws Exception {
        byte[] fileContent = Files.readAllBytes(path);
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] hash = digest.digest(fileContent);
        return "\"" + Base64.getEncoder().encodeToString(hash) + "\"";
    }
}

