/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.tb.provider;

import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.thingsboard.trendz.domain.tb.provider.RequestPriority;
import reactor.core.publisher.Mono;

public class RequestTask<T>
implements Comparable<RequestTask<?>> {
    private final long submittedAt;
    private final Mono<T> work;
    private final RequestPriority priority;
    private final CompletableFuture<T> future = new CompletableFuture();

    public RequestTask(Mono<T> work, RequestPriority priority) {
        this.work = work;
        this.submittedAt = System.currentTimeMillis();
        this.priority = priority;
    }

    @Override
    public int compareTo(RequestTask<?> other) {
        int priorityCompare = Integer.compare(this.priority.getIndex(), other.priority.getIndex());
        if (priorityCompare != 0) {
            return priorityCompare;
        }
        return Long.compare(this.submittedAt, other.submittedAt);
    }

    @Generated
    public long getSubmittedAt() {
        return this.submittedAt;
    }

    @Generated
    public Mono<T> getWork() {
        return this.work;
    }

    @Generated
    public RequestPriority getPriority() {
        return this.priority;
    }

    @Generated
    public CompletableFuture<T> getFuture() {
        return this.future;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestTask)) {
            return false;
        }
        RequestTask other = (RequestTask)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getSubmittedAt() != other.getSubmittedAt()) {
            return false;
        }
        Mono this$work = this.getWork();
        Mono other$work = other.getWork();
        if (this$work == null ? other$work != null : !this$work.equals(other$work)) {
            return false;
        }
        RequestPriority this$priority = this.getPriority();
        RequestPriority other$priority = other.getPriority();
        if (this$priority == null ? other$priority != null : !this$priority.equals(other$priority)) {
            return false;
        }
        CompletableFuture this$future = this.getFuture();
        CompletableFuture other$future = other.getFuture();
        return !(this$future == null ? other$future != null : !this$future.equals(other$future));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RequestTask;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $submittedAt = this.getSubmittedAt();
        result = result * 59 + (int)($submittedAt >>> 32 ^ $submittedAt);
        Mono $work = this.getWork();
        result = result * 59 + ($work == null ? 43 : $work.hashCode());
        RequestPriority $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : $priority.hashCode());
        CompletableFuture $future = this.getFuture();
        result = result * 59 + ($future == null ? 43 : $future.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RequestTask(submittedAt=" + this.getSubmittedAt() + ", work=" + String.valueOf(this.getWork()) + ", priority=" + String.valueOf(this.getPriority()) + ", future=" + String.valueOf(this.getFuture()) + ")";
    }
}

