/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.metric.ai;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.trendz.domain.metric.MetricDefinition;
import org.thingsboard.trendz.domain.metric.ai.MetricDefinitionAiLite;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;

public class MetricDefinitionAiLite {
    private String name;
    private String description;
    private String howToCalculate;
    private List<String> useCases;
    private List<String> uniqKeys;

    public MetricDefinition toData(JwtSecurityUser user, UUID businessEntityId, ItemLite itemLite) {
        long now = System.currentTimeMillis();
        return MetricDefinition.builder().id(UUID.randomUUID()).tenantId(user.getTenantId()).customerId(user.getCustomerId()).businessEntityId(businessEntityId).item(itemLite).name(this.getName()).userInput("AI Generated suggestion").description(this.getDescription()).howToCalculate(this.getHowToCalculate()).useCases(this.getUseCases() == null ? Collections.emptyList() : this.getUseCases().stream().map(MetricDefinition.UseCase::new).toList()).autoDeletable(true).createdTs(now).updatedTs(now).build();
    }

    @Generated
    public static MetricDefinitionAiLiteBuilder builder() {
        return new MetricDefinitionAiLiteBuilder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getHowToCalculate() {
        return this.howToCalculate;
    }

    @Generated
    public List<String> getUseCases() {
        return this.useCases;
    }

    @Generated
    public List<String> getUniqKeys() {
        return this.uniqKeys;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setHowToCalculate(String howToCalculate) {
        this.howToCalculate = howToCalculate;
    }

    @Generated
    public void setUseCases(List<String> useCases) {
        this.useCases = useCases;
    }

    @Generated
    public void setUniqKeys(List<String> uniqKeys) {
        this.uniqKeys = uniqKeys;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricDefinitionAiLite)) {
            return false;
        }
        MetricDefinitionAiLite other = (MetricDefinitionAiLite)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$howToCalculate = this.getHowToCalculate();
        String other$howToCalculate = other.getHowToCalculate();
        if (this$howToCalculate == null ? other$howToCalculate != null : !this$howToCalculate.equals(other$howToCalculate)) {
            return false;
        }
        List this$useCases = this.getUseCases();
        List other$useCases = other.getUseCases();
        if (this$useCases == null ? other$useCases != null : !((Object)this$useCases).equals(other$useCases)) {
            return false;
        }
        List this$uniqKeys = this.getUniqKeys();
        List other$uniqKeys = other.getUniqKeys();
        return !(this$uniqKeys == null ? other$uniqKeys != null : !((Object)this$uniqKeys).equals(other$uniqKeys));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MetricDefinitionAiLite;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $howToCalculate = this.getHowToCalculate();
        result = result * 59 + ($howToCalculate == null ? 43 : $howToCalculate.hashCode());
        List $useCases = this.getUseCases();
        result = result * 59 + ($useCases == null ? 43 : ((Object)$useCases).hashCode());
        List $uniqKeys = this.getUniqKeys();
        result = result * 59 + ($uniqKeys == null ? 43 : ((Object)$uniqKeys).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MetricDefinitionAiLite(name=" + this.getName() + ", description=" + this.getDescription() + ", howToCalculate=" + this.getHowToCalculate() + ", useCases=" + String.valueOf(this.getUseCases()) + ", uniqKeys=" + String.valueOf(this.getUniqKeys()) + ")";
    }

    @Generated
    public MetricDefinitionAiLite() {
    }

    @Generated
    public MetricDefinitionAiLite(String name, String description, String howToCalculate, List<String> useCases, List<String> uniqKeys) {
        this.name = name;
        this.description = description;
        this.howToCalculate = howToCalculate;
        this.useCases = useCases;
        this.uniqKeys = uniqKeys;
    }
}

