/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.metric;

import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.trendz.domain.definition.migration.TrendzEntity;
import org.thingsboard.trendz.domain.metric.MetricDefinition;
import org.thingsboard.trendz.domain.runtime.ItemLite;

public class MetricDefinition
implements TrendzEntity {
    private UUID id;
    private UUID tenantId;
    private UUID customerId;
    private UUID businessEntityId;
    private ItemLite item;
    private String name;
    private String userInput;
    private String description;
    private String howToCalculate;
    private boolean isAdvancedMode;
    private List<UseCase> useCases;
    private List<Field> fields;
    private UUID calculationFieldId;
    private boolean isOutdated;
    private String code;
    private boolean autoDeletable;
    private long createdTs;
    private long updatedTs;

    public MetricDefinition(MetricDefinition that) {
        this.id = that.id;
        this.tenantId = that.tenantId;
        this.customerId = that.customerId;
        this.businessEntityId = that.businessEntityId;
        this.item = new ItemLite(that.item);
        this.name = that.name;
        this.userInput = that.userInput;
        this.description = that.description;
        this.howToCalculate = that.howToCalculate;
        this.isAdvancedMode = that.isAdvancedMode;
        this.code = that.code;
        this.autoDeletable = that.autoDeletable;
        this.createdTs = that.createdTs;
        this.updatedTs = that.updatedTs;
        this.calculationFieldId = that.calculationFieldId;
        this.isOutdated = that.isOutdated;
        this.useCases = that.useCases == null ? null : that.useCases.stream().map(UseCase::new).toList();
        this.fields = that.fields == null ? null : that.fields.stream().map(Field::new).toList();
    }

    public Status getStatus() {
        if (this.autoDeletable) {
            return Status.NEW;
        }
        if (this.calculationFieldId != null) {
            return Status.WITH_CALCULATION_FIELD;
        }
        if (this.code != null) {
            return Status.WITH_CODE;
        }
        return Status.IN_PROGRESS;
    }

    @Generated
    public static MetricDefinitionBuilder builder() {
        return new MetricDefinitionBuilder();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public UUID getTenantId() {
        return this.tenantId;
    }

    @Generated
    public UUID getCustomerId() {
        return this.customerId;
    }

    @Generated
    public UUID getBusinessEntityId() {
        return this.businessEntityId;
    }

    @Generated
    public ItemLite getItem() {
        return this.item;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getUserInput() {
        return this.userInput;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getHowToCalculate() {
        return this.howToCalculate;
    }

    @Generated
    public boolean isAdvancedMode() {
        return this.isAdvancedMode;
    }

    @Generated
    public List<UseCase> getUseCases() {
        return this.useCases;
    }

    @Generated
    public List<Field> getFields() {
        return this.fields;
    }

    @Generated
    public UUID getCalculationFieldId() {
        return this.calculationFieldId;
    }

    @Generated
    public boolean isOutdated() {
        return this.isOutdated;
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public boolean isAutoDeletable() {
        return this.autoDeletable;
    }

    @Generated
    public long getCreatedTs() {
        return this.createdTs;
    }

    @Generated
    public long getUpdatedTs() {
        return this.updatedTs;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public void setTenantId(UUID tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setCustomerId(UUID customerId) {
        this.customerId = customerId;
    }

    @Generated
    public void setBusinessEntityId(UUID businessEntityId) {
        this.businessEntityId = businessEntityId;
    }

    @Generated
    public void setItem(ItemLite item) {
        this.item = item;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setUserInput(String userInput) {
        this.userInput = userInput;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setHowToCalculate(String howToCalculate) {
        this.howToCalculate = howToCalculate;
    }

    @Generated
    public void setAdvancedMode(boolean isAdvancedMode) {
        this.isAdvancedMode = isAdvancedMode;
    }

    @Generated
    public void setUseCases(List<UseCase> useCases) {
        this.useCases = useCases;
    }

    @Generated
    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    @Generated
    public void setCalculationFieldId(UUID calculationFieldId) {
        this.calculationFieldId = calculationFieldId;
    }

    @Generated
    public void setOutdated(boolean isOutdated) {
        this.isOutdated = isOutdated;
    }

    @Generated
    public void setCode(String code) {
        this.code = code;
    }

    @Generated
    public void setAutoDeletable(boolean autoDeletable) {
        this.autoDeletable = autoDeletable;
    }

    @Generated
    public void setCreatedTs(long createdTs) {
        this.createdTs = createdTs;
    }

    @Generated
    public void setUpdatedTs(long updatedTs) {
        this.updatedTs = updatedTs;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricDefinition)) {
            return false;
        }
        MetricDefinition other = (MetricDefinition)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isAdvancedMode() != other.isAdvancedMode()) {
            return false;
        }
        if (this.isOutdated() != other.isOutdated()) {
            return false;
        }
        if (this.isAutoDeletable() != other.isAutoDeletable()) {
            return false;
        }
        if (this.getCreatedTs() != other.getCreatedTs()) {
            return false;
        }
        if (this.getUpdatedTs() != other.getUpdatedTs()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$tenantId = this.getTenantId();
        UUID other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        UUID this$customerId = this.getCustomerId();
        UUID other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        UUID this$businessEntityId = this.getBusinessEntityId();
        UUID other$businessEntityId = other.getBusinessEntityId();
        if (this$businessEntityId == null ? other$businessEntityId != null : !((Object)this$businessEntityId).equals(other$businessEntityId)) {
            return false;
        }
        ItemLite this$item = this.getItem();
        ItemLite other$item = other.getItem();
        if (this$item == null ? other$item != null : !this$item.equals(other$item)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$userInput = this.getUserInput();
        String other$userInput = other.getUserInput();
        if (this$userInput == null ? other$userInput != null : !this$userInput.equals(other$userInput)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$howToCalculate = this.getHowToCalculate();
        String other$howToCalculate = other.getHowToCalculate();
        if (this$howToCalculate == null ? other$howToCalculate != null : !this$howToCalculate.equals(other$howToCalculate)) {
            return false;
        }
        List this$useCases = this.getUseCases();
        List other$useCases = other.getUseCases();
        if (this$useCases == null ? other$useCases != null : !((Object)this$useCases).equals(other$useCases)) {
            return false;
        }
        List this$fields = this.getFields();
        List other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        UUID this$calculationFieldId = this.getCalculationFieldId();
        UUID other$calculationFieldId = other.getCalculationFieldId();
        if (this$calculationFieldId == null ? other$calculationFieldId != null : !((Object)this$calculationFieldId).equals(other$calculationFieldId)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        return !(this$code == null ? other$code != null : !this$code.equals(other$code));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MetricDefinition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAdvancedMode() ? 79 : 97);
        result = result * 59 + (this.isOutdated() ? 79 : 97);
        result = result * 59 + (this.isAutoDeletable() ? 79 : 97);
        long $createdTs = this.getCreatedTs();
        result = result * 59 + (int)($createdTs >>> 32 ^ $createdTs);
        long $updatedTs = this.getUpdatedTs();
        result = result * 59 + (int)($updatedTs >>> 32 ^ $updatedTs);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        UUID $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        UUID $businessEntityId = this.getBusinessEntityId();
        result = result * 59 + ($businessEntityId == null ? 43 : ((Object)$businessEntityId).hashCode());
        ItemLite $item = this.getItem();
        result = result * 59 + ($item == null ? 43 : $item.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $userInput = this.getUserInput();
        result = result * 59 + ($userInput == null ? 43 : $userInput.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $howToCalculate = this.getHowToCalculate();
        result = result * 59 + ($howToCalculate == null ? 43 : $howToCalculate.hashCode());
        List $useCases = this.getUseCases();
        result = result * 59 + ($useCases == null ? 43 : ((Object)$useCases).hashCode());
        List $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        UUID $calculationFieldId = this.getCalculationFieldId();
        result = result * 59 + ($calculationFieldId == null ? 43 : ((Object)$calculationFieldId).hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MetricDefinition(id=" + String.valueOf(this.getId()) + ", tenantId=" + String.valueOf(this.getTenantId()) + ", customerId=" + String.valueOf(this.getCustomerId()) + ", businessEntityId=" + String.valueOf(this.getBusinessEntityId()) + ", item=" + String.valueOf(this.getItem()) + ", name=" + this.getName() + ", userInput=" + this.getUserInput() + ", description=" + this.getDescription() + ", howToCalculate=" + this.getHowToCalculate() + ", isAdvancedMode=" + this.isAdvancedMode() + ", useCases=" + String.valueOf(this.getUseCases()) + ", fields=" + String.valueOf(this.getFields()) + ", calculationFieldId=" + String.valueOf(this.getCalculationFieldId()) + ", isOutdated=" + this.isOutdated() + ", code=" + this.getCode() + ", autoDeletable=" + this.isAutoDeletable() + ", createdTs=" + this.getCreatedTs() + ", updatedTs=" + this.getUpdatedTs() + ")";
    }

    @Generated
    public MetricDefinition() {
    }

    @Generated
    public MetricDefinition(UUID id, UUID tenantId, UUID customerId, UUID businessEntityId, ItemLite item, String name, String userInput, String description, String howToCalculate, boolean isAdvancedMode, List<UseCase> useCases, List<Field> fields, UUID calculationFieldId, boolean isOutdated, String code, boolean autoDeletable, long createdTs, long updatedTs) {
        this.id = id;
        this.tenantId = tenantId;
        this.customerId = customerId;
        this.businessEntityId = businessEntityId;
        this.item = item;
        this.name = name;
        this.userInput = userInput;
        this.description = description;
        this.howToCalculate = howToCalculate;
        this.isAdvancedMode = isAdvancedMode;
        this.useCases = useCases;
        this.fields = fields;
        this.calculationFieldId = calculationFieldId;
        this.isOutdated = isOutdated;
        this.code = code;
        this.autoDeletable = autoDeletable;
        this.createdTs = createdTs;
        this.updatedTs = updatedTs;
    }
}

