/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.measurement;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.domain.measurement.FieldTrace;
import org.thingsboard.trendz.domain.measurement.MeasuredTaskType;
import org.thingsboard.trendz.domain.measurement.MeasurementInfo;
import org.thingsboard.trendz.domain.measurement.MeasurementParameters;
import org.thingsboard.trendz.domain.measurement.MeasurementReport;
import org.thingsboard.trendz.domain.measurement.RequestTrace;

@Component
public class TraceBuilder {
    public RequestTrace buildRequestTrace(MeasurementReport measurementReport) {
        Collection measurements = measurementReport.getMeasurements();
        RequestTrace trace = this.initRequestTrace(measurements);
        trace.setOthers(measurements.stream().filter(m -> !m.getType().equals((Object)MeasuredTaskType.BUILD_VIEW)).filter(m -> !m.getType().equals((Object)MeasuredTaskType.WAIT_FILTER_LOADING)).filter(m -> m.getMeasurementParameters().getViewFieldAggregation() == null || StringUtils.isEmpty((CharSequence)m.getMeasurementParameters().getViewFieldName())).collect(Collectors.toList()));
        List infoByField = measurements.stream().filter(m -> !m.getType().equals((Object)MeasuredTaskType.BUILD_VIEW)).filter(m -> !m.getType().equals((Object)MeasuredTaskType.WAIT_FILTER_LOADING)).filter(m -> m.getMeasurementParameters().getViewFieldAggregation() != null && StringUtils.isNotEmpty((CharSequence)m.getMeasurementParameters().getViewFieldName())).collect(Collectors.groupingBy(arg_0 -> this.getKey(arg_0))).values().stream().sorted((t0, t1) -> {
            long left = t0.stream().mapToLong(MeasurementInfo::getScheduleTs).max().orElse(0L);
            long right = t1.stream().mapToLong(MeasurementInfo::getScheduleTs).max().orElse(0L);
            return Long.compare(left, right);
        }).collect(Collectors.toList());
        for (int i = 0; i < infoByField.size(); ++i) {
            trace.getFieldTraces().add(this.buildFieldTrace(i, this.getKey((MeasurementInfo)((List)infoByField.get(i)).get(0)), (List)infoByField.get(i), measurementReport));
        }
        return trace;
    }

    private FieldTrace buildFieldTrace(int order, String key, List<MeasurementInfo> infos, MeasurementReport measurementReport) {
        FieldTrace fieldTrace = new FieldTrace();
        fieldTrace.setFieldName(key);
        fieldTrace.setProcessingOrder(order);
        if (measurementReport.getFieldKeyToItemsCnt().containsKey(key)) {
            fieldTrace.setItemsCnt(((AtomicLong)measurementReport.getFieldKeyToItemsCnt().get(key)).get());
        }
        if (measurementReport.getFieldKeyToValuesCnt().containsKey(key)) {
            fieldTrace.setRawValuesSize(((AtomicLong)measurementReport.getFieldKeyToValuesCnt().get(key)).get());
        }
        fieldTrace.setTotalTime(infos.stream().filter(m -> m.getType().equals((Object)MeasuredTaskType.FIELD_PROCESSING)).mapToLong(MeasurementInfo::getExecutionTime).sum());
        fieldTrace.setItemLoad(infos.stream().filter(m -> m.getType().equals((Object)MeasuredTaskType.ITEM_SERVICE_LOAD_ITEMS)).mapToLong(MeasurementInfo::getExecutionTime).sum());
        fieldTrace.setRelatedItemLoad(infos.stream().filter(m -> m.getType().equals((Object)MeasuredTaskType.ITEM_SERVICE_LOAD_RELATED) || m.getType().equals((Object)MeasuredTaskType.ITEM_SERVICE_LOAD_MULTI_RELATED)).mapToLong(MeasurementInfo::getExecutionTime).sum());
        long itemLoadTimeMax = infos.stream().filter(m -> m.getType().equals((Object)MeasuredTaskType.ITEM_LOAD_DATA_TB)).mapToLong(MeasurementInfo::getRuntimeEndTs).max().orElse(0L);
        long itemLoadTimeMin = infos.stream().filter(m -> m.getType().equals((Object)MeasuredTaskType.ITEM_LOAD_DATA_TB)).mapToLong(MeasurementInfo::getRuntimeStartTs).min().orElse(0L);
        fieldTrace.setTbLoadTime(itemLoadTimeMax - itemLoadTimeMin);
        fieldTrace.setCacheLoadTime(infos.stream().filter(m -> m.getType().equals((Object)MeasuredTaskType.ITEM_LOAD_DATA_CACHE)).mapToLong(MeasurementInfo::getExecutionTime).sum());
        fieldTrace.setScriptLoadTime(infos.stream().filter(m -> m.getType().equals((Object)MeasuredTaskType.LOAD_DATA_BUNDLE)).mapToLong(MeasurementInfo::getExecutionTime).sum());
        fieldTrace.setBatchCalcTime(infos.stream().filter(m -> m.getType().equals((Object)MeasuredTaskType.BATCH_CALCULATION_FIELD_PROCESSING)).mapToLong(MeasurementInfo::getExecutionTime).sum());
        fieldTrace.setNativeCalcTime(infos.stream().filter(m -> m.getType().equals((Object)MeasuredTaskType.NATIVE_CALCULATION_FIELD_PROCESSING)).mapToLong(MeasurementInfo::getExecutionTime).sum());
        fieldTrace.setStateTime(infos.stream().filter(m -> m.getType().equals((Object)MeasuredTaskType.STATE_FIELD_PROCESSING)).mapToLong(MeasurementInfo::getExecutionTime).sum());
        fieldTrace.setPredictTime(infos.stream().filter(m -> m.getType().equals((Object)MeasuredTaskType.PREDICTION_CALCULATION)).mapToLong(MeasurementInfo::getExecutionTime).sum());
        fieldTrace.setAnomalyTime(infos.stream().filter(m -> m.getType().equals((Object)MeasuredTaskType.ANOMALY_FIELD_PROCESSING)).mapToLong(MeasurementInfo::getExecutionTime).sum());
        fieldTrace.setAggTime(infos.stream().filter(m -> m.getType().equals((Object)MeasuredTaskType.FIELD_AGGREGATION)).mapToLong(MeasurementInfo::getExecutionTime).sum());
        fieldTrace.setPreAggTime(infos.stream().filter(m -> m.getType().equals((Object)MeasuredTaskType.FIELD_PRE_AGGREGATION)).mapToLong(MeasurementInfo::getExecutionTime).sum());
        fieldTrace.setDateGroupTime(infos.stream().filter(m -> m.getType().equals((Object)MeasuredTaskType.DATE_GROUPING)).mapToLong(MeasurementInfo::getExecutionTime).sum());
        return fieldTrace;
    }

    private RequestTrace initRequestTrace(Collection<MeasurementInfo> measurements) {
        RequestTrace trace = new RequestTrace();
        MeasurementInfo buildView = measurements.stream().filter(m -> m.getType().equals((Object)MeasuredTaskType.BUILD_VIEW)).findFirst().orElse(null);
        MeasurementInfo firstFieldProcessing = measurements.stream().filter(m -> m.getType().equals((Object)MeasuredTaskType.FIELD_PROCESSING)).findFirst().orElse(null);
        String lastFieldKey = measurements.stream().filter(m -> m.getType().equals((Object)MeasuredTaskType.FIELD_PROCESSING)).reduce((f, s) -> s).map(arg_0 -> this.getKey(arg_0)).orElse(null);
        long lastFieldProcessingMaxEndTs = measurements.stream().filter(m -> this.getKey(m).equals(lastFieldKey)).mapToLong(MeasurementInfo::getRuntimeEndTs).max().orElse(-1L);
        if (buildView != null && firstFieldProcessing != null && lastFieldProcessingMaxEndTs != -1L) {
            long initTime = firstFieldProcessing.getScheduleTs() - buildView.getRuntimeStartTs();
            long postTime = buildView.getRuntimeEndTs() - lastFieldProcessingMaxEndTs;
            trace.setTotalTime(buildView.getRuntimeEndTs() - buildView.getRuntimeStartTs());
            trace.setInitTime(initTime);
            trace.setPostTime(postTime);
        }
        long fieldProcessingTime = measurements.stream().filter(m -> m.getType().equals((Object)MeasuredTaskType.FIELD_PROCESSING)).mapToLong(MeasurementInfo::getExecutionTime).sum();
        trace.setFieldsProcessTime(fieldProcessingTime);
        long waitFilter = measurements.stream().filter(m -> m.getType().equals((Object)MeasuredTaskType.WAIT_FILTER_LOADING)).mapToLong(MeasurementInfo::getExecutionTime).sum();
        trace.setWaitFilterTime(waitFilter);
        long restRequest = measurements.stream().filter(m -> m.getType().equals((Object)MeasuredTaskType.TB_REST_REQUEST)).mapToLong(MeasurementInfo::getExecutionTime).sum();
        trace.setRestRequestTime(restRequest);
        long restRequestCount = measurements.stream().filter(m -> m.getType().equals((Object)MeasuredTaskType.TB_REST_REQUEST)).count();
        trace.setRestRequestCount(restRequestCount);
        return trace;
    }

    private String getKey(MeasurementInfo info) {
        MeasurementParameters parameters = info.getMeasurementParameters();
        return parameters.getViewFieldName() + "_" + String.valueOf(parameters.getViewFieldAggregation());
    }
}

