/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.measurement;

import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.measurement.MeasuredTaskType;
import org.thingsboard.trendz.domain.measurement.MeasurementInfo;
import org.thingsboard.trendz.domain.measurement.MeasurementParameters;
import org.thingsboard.trendz.domain.measurement.MeasurementReport;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class MeasurementService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MeasurementService.class);

    public <T> Flux<T> performWithMeasurement(Flux<T> publisher, MeasurementReport measurementReport, long scheduleTs, MeasuredTaskType type, MeasurementParameters measurementParameters) {
        return this.performWithMeasurement(publisher.collectList(), measurementReport, scheduleTs, type, measurementParameters).flatMapIterable(list -> list);
    }

    public <T> Mono<T> performWithMeasurement(Mono<T> publisher, MeasurementReport measurementReport, long scheduleTs, MeasuredTaskType type, MeasurementParameters measurementParameters) {
        MeasurementInfo measurement = new MeasurementInfo();
        measurement.setType(type);
        measurement.setScheduleTs(scheduleTs);
        measurement.setMeasurementParameters(measurementParameters);
        measurementReport.getMeasurements().add(measurement);
        return Mono.just((Object)new Object()).doOnNext(o -> measurement.setRuntimeStartTs(System.currentTimeMillis())).flatMap(o -> publisher).doOnNext(o -> measurement.setRuntimeEndTs(System.currentTimeMillis()));
    }

    public <T> T performWithMeasurement(Supplier<T> action, MeasurementReport measurementReport, MeasuredTaskType type, MeasurementParameters measurementParameters) {
        MeasurementInfo measurement = new MeasurementInfo();
        measurement.setType(type);
        measurement.setScheduleTs(0L);
        measurement.setMeasurementParameters(measurementParameters);
        measurement.setRuntimeStartTs(System.currentTimeMillis());
        T result = action.get();
        measurement.setRuntimeEndTs(System.currentTimeMillis());
        measurementReport.getMeasurements().add(measurement);
        return result;
    }
}

