/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.measurement;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.measurement.Measurable;
import org.thingsboard.trendz.domain.measurement.MeasuredTaskType;
import org.thingsboard.trendz.domain.measurement.MeasurementParameters;
import org.thingsboard.trendz.domain.measurement.MeasurementReport;
import org.thingsboard.trendz.domain.measurement.MeasurementService;
import org.thingsboard.trendz.exception.measurement.MeasurementException;
import org.thingsboard.trendz.service.view.ViewContext;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Aspect
@Component
public class MeasurableAnnotationProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MeasurableAnnotationProcessor.class);
    @Value(value="${measurement.enable}")
    private boolean enableService;
    @Autowired
    private MeasurementService measurementService;
    private static final ExpressionParser parser = new SpelExpressionParser();

    @Around(value="@annotation(Measurable)")
    public Object proceedMeasurement(ProceedingJoinPoint joinPoint) throws Throwable {
        if (!this.enableService) {
            return joinPoint.proceed();
        }
        try {
            MeasurementReport measurementReport;
            MethodSignature signature = (MethodSignature)joinPoint.getSignature();
            Measurable annotation = signature.getMethod().getAnnotation(Measurable.class);
            if ("".equals(annotation.context())) {
                measurementReport = (MeasurementReport)this.getDynamicValue(signature, joinPoint, annotation.measurementReport());
            } else {
                ViewContext context = (ViewContext)this.getDynamicValue(signature, joinPoint, annotation.context());
                if (context == null) {
                    log.warn("The measuring is cancelled because the context is not provided.");
                    return joinPoint.proceed();
                }
                measurementReport = context.getMeasurementReport();
            }
            MeasuredTaskType type = annotation.type();
            MeasurementParameters measurementParameters = this.createMeasurementParameters(annotation, signature, joinPoint);
            AtomicLong scheduleTs = new AtomicLong(0L);
            Supplier<Object> action = () -> {
                try {
                    log.trace("Measuring: {} measure is launched. ", (Object)type);
                    scheduleTs.set(System.currentTimeMillis());
                    Object result = joinPoint.proceed();
                    return result;
                }
                catch (Throwable e) {
                    throw new MeasurementException(e);
                }
            };
            Class returnType = signature.getReturnType();
            if (Flux.class.equals((Object)returnType)) {
                Object result = action.get();
                return this.measurementService.performWithMeasurement((Flux)result, measurementReport, scheduleTs.get(), type, measurementParameters);
            }
            if (Mono.class.equals((Object)returnType)) {
                Object result = action.get();
                return this.measurementService.performWithMeasurement((Mono)result, measurementReport, scheduleTs.get(), type, measurementParameters);
            }
            return this.measurementService.performWithMeasurement(action, measurementReport, type, measurementParameters);
        }
        catch (Exception e) {
            log.error("The measuring is failed, proceeding method without measurement, joinPoint = {}", (Object)joinPoint, (Object)e);
            throw e;
        }
    }

    private MeasurementParameters createMeasurementParameters(Measurable annotation, MethodSignature signature, ProceedingJoinPoint joinPoint) {
        String viewFieldName = "".equals(annotation.viewFieldName()) ? null : (String)this.getDynamicValue(signature, joinPoint, annotation.viewFieldName());
        FieldAggregation viewFieldAggregation = "".equals(annotation.viewFieldAggregation()) ? null : (FieldAggregation)this.getDynamicValue(signature, joinPoint, annotation.viewFieldAggregation());
        String businessEntityId = "".equals(annotation.businessEntityId()) ? null : this.getDynamicValue(signature, joinPoint, annotation.businessEntityId()).toString();
        String itemName = "".equals(annotation.itemName()) ? null : (String)this.getDynamicValue(signature, joinPoint, annotation.itemName());
        String requestName = "".equals(annotation.requestName()) ? null : (String)this.getDynamicValue(signature, joinPoint, annotation.requestName());
        return MeasurementParameters.builder().viewFieldName(viewFieldName).viewFieldAggregation(viewFieldAggregation).businessEntityId(businessEntityId).itemName(itemName).requestName(requestName).build();
    }

    private Object getDynamicValue(MethodSignature signature, ProceedingJoinPoint joinPoint, String key) {
        String[] parameterNames = signature.getParameterNames();
        Object[] args = joinPoint.getArgs();
        StandardEvaluationContext context = new StandardEvaluationContext();
        for (int i = 0; i < parameterNames.length; ++i) {
            context.setVariable(parameterNames[i], args[i]);
        }
        return parser.parseExpression(key).getValue((EvaluationContext)context, Object.class);
    }
}

