/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.definition.migration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.thingsboard.trendz.domain.anomaly.Anomaly;
import org.thingsboard.trendz.domain.anomaly.AnomalyModel;
import org.thingsboard.trendz.domain.assistance.customprompt.CustomPrompt;
import org.thingsboard.trendz.domain.chat.Chat;
import org.thingsboard.trendz.domain.chat.ChatMessage;
import org.thingsboard.trendz.domain.definition.calculation.CalculationField;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.metadata.BusinessEntityFieldMetadata;
import org.thingsboard.trendz.domain.definition.entity.metadata.BusinessEntityMetadata;
import org.thingsboard.trendz.domain.definition.migration.MigrationData;
import org.thingsboard.trendz.domain.definition.migration.MigrationProperties;
import org.thingsboard.trendz.domain.definition.view.config.ViewCollection;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.metric.MetricDefinition;
import org.thingsboard.trendz.domain.metric.MetricDefinitionMetadata;
import org.thingsboard.trendz.domain.sql.SqlDatasource;
import org.thingsboard.trendz.domain.user.UserMetadata;
import org.thingsboard.trendz.service.model.prediction.PredictionModel;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentData;
import org.thingsboard.trendz.service.task.model.Task;
import org.thingsboard.trendz.service.task.model.TaskSequence;

public class MigrationData {
    private MigrationProperties properties;
    private List<BusinessEntity> businessEntities;
    private List<SqlDatasource> sqlDatasource;
    private List<ViewCollection> viewCollections;
    private List<ViewConfig> viewConfigs;
    private List<CalculationField> calculationFields;
    private List<PredictionModel> predictionModels;
    private Map<UUID, Map<UUID, Long>> modelToItemToLastPointMap;
    private List<SegmentData> segmentData;
    private List<AnomalyModel> anomalyModels;
    private Map<UUID, List<Anomaly>> anomalyMap;
    private List<Task> tasks;
    private List<TaskSequence> taskSequences;
    private List<Chat> chats;
    private List<ChatMessage> chatMessages;
    private List<CustomPrompt> prompts;
    private List<MetricDefinition> metricDefinitions;
    private List<MetricDefinitionMetadata> metricDefinitionMetadata;
    private List<UserMetadata> userMetadata;
    private List<BusinessEntityMetadata> entityMetadata;
    private List<BusinessEntityFieldMetadata> fieldMetadata;

    public MigrationData(MigrationData that) {
        this.properties = that.properties == null ? null : new MigrationProperties(that.properties);
        this.businessEntities = that.businessEntities == null ? null : that.businessEntities.stream().map(BusinessEntity::new).collect(Collectors.toList());
        this.sqlDatasource = that.sqlDatasource == null ? null : that.sqlDatasource.stream().map(SqlDatasource::new).collect(Collectors.toList());
        this.viewCollections = that.viewCollections == null ? null : that.viewCollections.stream().map(ViewCollection::new).collect(Collectors.toList());
        this.viewConfigs = that.viewConfigs == null ? null : that.viewConfigs.stream().map(ViewConfig::new).collect(Collectors.toList());
        this.calculationFields = that.calculationFields == null ? null : that.calculationFields.stream().map(CalculationField::new).collect(Collectors.toList());
        this.predictionModels = that.predictionModels == null ? null : that.predictionModels.stream().map(PredictionModel::new).collect(Collectors.toList());
        this.modelToItemToLastPointMap = that.modelToItemToLastPointMap == null ? null : that.modelToItemToLastPointMap.entrySet().stream().map(entry -> {
            UUID key = (UUID)entry.getKey();
            HashMap value = entry.getValue() == null ? null : new HashMap((Map)entry.getValue());
            return Map.entry(key, value);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.segmentData = that.segmentData == null ? null : that.segmentData.stream().map(SegmentData::new).collect(Collectors.toList());
        this.anomalyModels = that.anomalyModels == null ? null : that.anomalyModels.stream().map(AnomalyModel::new).collect(Collectors.toList());
        this.anomalyMap = that.anomalyMap == null ? null : that.anomalyMap.entrySet().stream().map(entry -> {
            UUID key = (UUID)entry.getKey();
            List<Anomaly> value = entry.getValue() == null ? null : ((List)entry.getValue()).stream().map(Anomaly::new).toList();
            return Map.entry(key, value);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.tasks = that.tasks == null ? null : that.tasks.stream().map(Task::new).collect(Collectors.toList());
        this.taskSequences = that.taskSequences == null ? null : that.taskSequences.stream().map(TaskSequence::new).collect(Collectors.toList());
        this.chats = that.chats == null ? null : that.chats.stream().map(Chat::new).toList();
        this.chatMessages = that.chatMessages == null ? null : that.chatMessages.stream().map(ChatMessage::new).toList();
        this.prompts = that.prompts == null ? null : that.prompts.stream().map(CustomPrompt::new).collect(Collectors.toList());
        this.metricDefinitions = that.metricDefinitions == null ? null : that.metricDefinitions.stream().map(MetricDefinition::new).collect(Collectors.toList());
        this.metricDefinitionMetadata = that.metricDefinitionMetadata == null ? null : that.metricDefinitionMetadata.stream().map(MetricDefinitionMetadata::new).collect(Collectors.toList());
        this.userMetadata = that.userMetadata == null ? null : that.userMetadata.stream().map(UserMetadata::new).collect(Collectors.toList());
        this.entityMetadata = that.entityMetadata == null ? null : that.entityMetadata.stream().map(BusinessEntityMetadata::new).collect(Collectors.toList());
        this.fieldMetadata = that.fieldMetadata == null ? null : that.fieldMetadata.stream().map(BusinessEntityFieldMetadata::new).collect(Collectors.toList());
    }

    @Generated
    public static MigrationDataBuilder builder() {
        return new MigrationDataBuilder();
    }

    @Generated
    public MigrationProperties getProperties() {
        return this.properties;
    }

    @Generated
    public List<BusinessEntity> getBusinessEntities() {
        return this.businessEntities;
    }

    @Generated
    public List<SqlDatasource> getSqlDatasource() {
        return this.sqlDatasource;
    }

    @Generated
    public List<ViewCollection> getViewCollections() {
        return this.viewCollections;
    }

    @Generated
    public List<ViewConfig> getViewConfigs() {
        return this.viewConfigs;
    }

    @Generated
    public List<CalculationField> getCalculationFields() {
        return this.calculationFields;
    }

    @Generated
    public List<PredictionModel> getPredictionModels() {
        return this.predictionModels;
    }

    @Generated
    public Map<UUID, Map<UUID, Long>> getModelToItemToLastPointMap() {
        return this.modelToItemToLastPointMap;
    }

    @Generated
    public List<SegmentData> getSegmentData() {
        return this.segmentData;
    }

    @Generated
    public List<AnomalyModel> getAnomalyModels() {
        return this.anomalyModels;
    }

    @Generated
    public Map<UUID, List<Anomaly>> getAnomalyMap() {
        return this.anomalyMap;
    }

    @Generated
    public List<Task> getTasks() {
        return this.tasks;
    }

    @Generated
    public List<TaskSequence> getTaskSequences() {
        return this.taskSequences;
    }

    @Generated
    public List<Chat> getChats() {
        return this.chats;
    }

    @Generated
    public List<ChatMessage> getChatMessages() {
        return this.chatMessages;
    }

    @Generated
    public List<CustomPrompt> getPrompts() {
        return this.prompts;
    }

    @Generated
    public List<MetricDefinition> getMetricDefinitions() {
        return this.metricDefinitions;
    }

    @Generated
    public List<MetricDefinitionMetadata> getMetricDefinitionMetadata() {
        return this.metricDefinitionMetadata;
    }

    @Generated
    public List<UserMetadata> getUserMetadata() {
        return this.userMetadata;
    }

    @Generated
    public List<BusinessEntityMetadata> getEntityMetadata() {
        return this.entityMetadata;
    }

    @Generated
    public List<BusinessEntityFieldMetadata> getFieldMetadata() {
        return this.fieldMetadata;
    }

    @Generated
    public void setProperties(MigrationProperties properties) {
        this.properties = properties;
    }

    @Generated
    public void setBusinessEntities(List<BusinessEntity> businessEntities) {
        this.businessEntities = businessEntities;
    }

    @Generated
    public void setSqlDatasource(List<SqlDatasource> sqlDatasource) {
        this.sqlDatasource = sqlDatasource;
    }

    @Generated
    public void setViewCollections(List<ViewCollection> viewCollections) {
        this.viewCollections = viewCollections;
    }

    @Generated
    public void setViewConfigs(List<ViewConfig> viewConfigs) {
        this.viewConfigs = viewConfigs;
    }

    @Generated
    public void setCalculationFields(List<CalculationField> calculationFields) {
        this.calculationFields = calculationFields;
    }

    @Generated
    public void setPredictionModels(List<PredictionModel> predictionModels) {
        this.predictionModels = predictionModels;
    }

    @Generated
    public void setModelToItemToLastPointMap(Map<UUID, Map<UUID, Long>> modelToItemToLastPointMap) {
        this.modelToItemToLastPointMap = modelToItemToLastPointMap;
    }

    @Generated
    public void setSegmentData(List<SegmentData> segmentData) {
        this.segmentData = segmentData;
    }

    @Generated
    public void setAnomalyModels(List<AnomalyModel> anomalyModels) {
        this.anomalyModels = anomalyModels;
    }

    @Generated
    public void setAnomalyMap(Map<UUID, List<Anomaly>> anomalyMap) {
        this.anomalyMap = anomalyMap;
    }

    @Generated
    public void setTasks(List<Task> tasks) {
        this.tasks = tasks;
    }

    @Generated
    public void setTaskSequences(List<TaskSequence> taskSequences) {
        this.taskSequences = taskSequences;
    }

    @Generated
    public void setChats(List<Chat> chats) {
        this.chats = chats;
    }

    @Generated
    public void setChatMessages(List<ChatMessage> chatMessages) {
        this.chatMessages = chatMessages;
    }

    @Generated
    public void setPrompts(List<CustomPrompt> prompts) {
        this.prompts = prompts;
    }

    @Generated
    public void setMetricDefinitions(List<MetricDefinition> metricDefinitions) {
        this.metricDefinitions = metricDefinitions;
    }

    @Generated
    public void setMetricDefinitionMetadata(List<MetricDefinitionMetadata> metricDefinitionMetadata) {
        this.metricDefinitionMetadata = metricDefinitionMetadata;
    }

    @Generated
    public void setUserMetadata(List<UserMetadata> userMetadata) {
        this.userMetadata = userMetadata;
    }

    @Generated
    public void setEntityMetadata(List<BusinessEntityMetadata> entityMetadata) {
        this.entityMetadata = entityMetadata;
    }

    @Generated
    public void setFieldMetadata(List<BusinessEntityFieldMetadata> fieldMetadata) {
        this.fieldMetadata = fieldMetadata;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MigrationData)) {
            return false;
        }
        MigrationData other = (MigrationData)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        MigrationProperties this$properties = this.getProperties();
        MigrationProperties other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !this$properties.equals(other$properties)) {
            return false;
        }
        List this$businessEntities = this.getBusinessEntities();
        List other$businessEntities = other.getBusinessEntities();
        if (this$businessEntities == null ? other$businessEntities != null : !((Object)this$businessEntities).equals(other$businessEntities)) {
            return false;
        }
        List this$sqlDatasource = this.getSqlDatasource();
        List other$sqlDatasource = other.getSqlDatasource();
        if (this$sqlDatasource == null ? other$sqlDatasource != null : !((Object)this$sqlDatasource).equals(other$sqlDatasource)) {
            return false;
        }
        List this$viewCollections = this.getViewCollections();
        List other$viewCollections = other.getViewCollections();
        if (this$viewCollections == null ? other$viewCollections != null : !((Object)this$viewCollections).equals(other$viewCollections)) {
            return false;
        }
        List this$viewConfigs = this.getViewConfigs();
        List other$viewConfigs = other.getViewConfigs();
        if (this$viewConfigs == null ? other$viewConfigs != null : !((Object)this$viewConfigs).equals(other$viewConfigs)) {
            return false;
        }
        List this$calculationFields = this.getCalculationFields();
        List other$calculationFields = other.getCalculationFields();
        if (this$calculationFields == null ? other$calculationFields != null : !((Object)this$calculationFields).equals(other$calculationFields)) {
            return false;
        }
        List this$predictionModels = this.getPredictionModels();
        List other$predictionModels = other.getPredictionModels();
        if (this$predictionModels == null ? other$predictionModels != null : !((Object)this$predictionModels).equals(other$predictionModels)) {
            return false;
        }
        Map this$modelToItemToLastPointMap = this.getModelToItemToLastPointMap();
        Map other$modelToItemToLastPointMap = other.getModelToItemToLastPointMap();
        if (this$modelToItemToLastPointMap == null ? other$modelToItemToLastPointMap != null : !((Object)this$modelToItemToLastPointMap).equals(other$modelToItemToLastPointMap)) {
            return false;
        }
        List this$segmentData = this.getSegmentData();
        List other$segmentData = other.getSegmentData();
        if (this$segmentData == null ? other$segmentData != null : !((Object)this$segmentData).equals(other$segmentData)) {
            return false;
        }
        List this$anomalyModels = this.getAnomalyModels();
        List other$anomalyModels = other.getAnomalyModels();
        if (this$anomalyModels == null ? other$anomalyModels != null : !((Object)this$anomalyModels).equals(other$anomalyModels)) {
            return false;
        }
        Map this$anomalyMap = this.getAnomalyMap();
        Map other$anomalyMap = other.getAnomalyMap();
        if (this$anomalyMap == null ? other$anomalyMap != null : !((Object)this$anomalyMap).equals(other$anomalyMap)) {
            return false;
        }
        List this$tasks = this.getTasks();
        List other$tasks = other.getTasks();
        if (this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks)) {
            return false;
        }
        List this$taskSequences = this.getTaskSequences();
        List other$taskSequences = other.getTaskSequences();
        if (this$taskSequences == null ? other$taskSequences != null : !((Object)this$taskSequences).equals(other$taskSequences)) {
            return false;
        }
        List this$chats = this.getChats();
        List other$chats = other.getChats();
        if (this$chats == null ? other$chats != null : !((Object)this$chats).equals(other$chats)) {
            return false;
        }
        List this$chatMessages = this.getChatMessages();
        List other$chatMessages = other.getChatMessages();
        if (this$chatMessages == null ? other$chatMessages != null : !((Object)this$chatMessages).equals(other$chatMessages)) {
            return false;
        }
        List this$prompts = this.getPrompts();
        List other$prompts = other.getPrompts();
        if (this$prompts == null ? other$prompts != null : !((Object)this$prompts).equals(other$prompts)) {
            return false;
        }
        List this$metricDefinitions = this.getMetricDefinitions();
        List other$metricDefinitions = other.getMetricDefinitions();
        if (this$metricDefinitions == null ? other$metricDefinitions != null : !((Object)this$metricDefinitions).equals(other$metricDefinitions)) {
            return false;
        }
        List this$metricDefinitionMetadata = this.getMetricDefinitionMetadata();
        List other$metricDefinitionMetadata = other.getMetricDefinitionMetadata();
        if (this$metricDefinitionMetadata == null ? other$metricDefinitionMetadata != null : !((Object)this$metricDefinitionMetadata).equals(other$metricDefinitionMetadata)) {
            return false;
        }
        List this$userMetadata = this.getUserMetadata();
        List other$userMetadata = other.getUserMetadata();
        if (this$userMetadata == null ? other$userMetadata != null : !((Object)this$userMetadata).equals(other$userMetadata)) {
            return false;
        }
        List this$entityMetadata = this.getEntityMetadata();
        List other$entityMetadata = other.getEntityMetadata();
        if (this$entityMetadata == null ? other$entityMetadata != null : !((Object)this$entityMetadata).equals(other$entityMetadata)) {
            return false;
        }
        List this$fieldMetadata = this.getFieldMetadata();
        List other$fieldMetadata = other.getFieldMetadata();
        return !(this$fieldMetadata == null ? other$fieldMetadata != null : !((Object)this$fieldMetadata).equals(other$fieldMetadata));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MigrationData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MigrationProperties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        List $businessEntities = this.getBusinessEntities();
        result = result * 59 + ($businessEntities == null ? 43 : ((Object)$businessEntities).hashCode());
        List $sqlDatasource = this.getSqlDatasource();
        result = result * 59 + ($sqlDatasource == null ? 43 : ((Object)$sqlDatasource).hashCode());
        List $viewCollections = this.getViewCollections();
        result = result * 59 + ($viewCollections == null ? 43 : ((Object)$viewCollections).hashCode());
        List $viewConfigs = this.getViewConfigs();
        result = result * 59 + ($viewConfigs == null ? 43 : ((Object)$viewConfigs).hashCode());
        List $calculationFields = this.getCalculationFields();
        result = result * 59 + ($calculationFields == null ? 43 : ((Object)$calculationFields).hashCode());
        List $predictionModels = this.getPredictionModels();
        result = result * 59 + ($predictionModels == null ? 43 : ((Object)$predictionModels).hashCode());
        Map $modelToItemToLastPointMap = this.getModelToItemToLastPointMap();
        result = result * 59 + ($modelToItemToLastPointMap == null ? 43 : ((Object)$modelToItemToLastPointMap).hashCode());
        List $segmentData = this.getSegmentData();
        result = result * 59 + ($segmentData == null ? 43 : ((Object)$segmentData).hashCode());
        List $anomalyModels = this.getAnomalyModels();
        result = result * 59 + ($anomalyModels == null ? 43 : ((Object)$anomalyModels).hashCode());
        Map $anomalyMap = this.getAnomalyMap();
        result = result * 59 + ($anomalyMap == null ? 43 : ((Object)$anomalyMap).hashCode());
        List $tasks = this.getTasks();
        result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
        List $taskSequences = this.getTaskSequences();
        result = result * 59 + ($taskSequences == null ? 43 : ((Object)$taskSequences).hashCode());
        List $chats = this.getChats();
        result = result * 59 + ($chats == null ? 43 : ((Object)$chats).hashCode());
        List $chatMessages = this.getChatMessages();
        result = result * 59 + ($chatMessages == null ? 43 : ((Object)$chatMessages).hashCode());
        List $prompts = this.getPrompts();
        result = result * 59 + ($prompts == null ? 43 : ((Object)$prompts).hashCode());
        List $metricDefinitions = this.getMetricDefinitions();
        result = result * 59 + ($metricDefinitions == null ? 43 : ((Object)$metricDefinitions).hashCode());
        List $metricDefinitionMetadata = this.getMetricDefinitionMetadata();
        result = result * 59 + ($metricDefinitionMetadata == null ? 43 : ((Object)$metricDefinitionMetadata).hashCode());
        List $userMetadata = this.getUserMetadata();
        result = result * 59 + ($userMetadata == null ? 43 : ((Object)$userMetadata).hashCode());
        List $entityMetadata = this.getEntityMetadata();
        result = result * 59 + ($entityMetadata == null ? 43 : ((Object)$entityMetadata).hashCode());
        List $fieldMetadata = this.getFieldMetadata();
        result = result * 59 + ($fieldMetadata == null ? 43 : ((Object)$fieldMetadata).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MigrationData(properties=" + String.valueOf(this.getProperties()) + ", businessEntities=" + String.valueOf(this.getBusinessEntities()) + ", sqlDatasource=" + String.valueOf(this.getSqlDatasource()) + ", viewCollections=" + String.valueOf(this.getViewCollections()) + ", viewConfigs=" + String.valueOf(this.getViewConfigs()) + ", calculationFields=" + String.valueOf(this.getCalculationFields()) + ", predictionModels=" + String.valueOf(this.getPredictionModels()) + ", modelToItemToLastPointMap=" + String.valueOf(this.getModelToItemToLastPointMap()) + ", segmentData=" + String.valueOf(this.getSegmentData()) + ", anomalyModels=" + String.valueOf(this.getAnomalyModels()) + ", anomalyMap=" + String.valueOf(this.getAnomalyMap()) + ", tasks=" + String.valueOf(this.getTasks()) + ", taskSequences=" + String.valueOf(this.getTaskSequences()) + ", chats=" + String.valueOf(this.getChats()) + ", chatMessages=" + String.valueOf(this.getChatMessages()) + ", prompts=" + String.valueOf(this.getPrompts()) + ", metricDefinitions=" + String.valueOf(this.getMetricDefinitions()) + ", metricDefinitionMetadata=" + String.valueOf(this.getMetricDefinitionMetadata()) + ", userMetadata=" + String.valueOf(this.getUserMetadata()) + ", entityMetadata=" + String.valueOf(this.getEntityMetadata()) + ", fieldMetadata=" + String.valueOf(this.getFieldMetadata()) + ")";
    }

    @Generated
    public MigrationData(MigrationProperties properties, List<BusinessEntity> businessEntities, List<SqlDatasource> sqlDatasource, List<ViewCollection> viewCollections, List<ViewConfig> viewConfigs, List<CalculationField> calculationFields, List<PredictionModel> predictionModels, Map<UUID, Map<UUID, Long>> modelToItemToLastPointMap, List<SegmentData> segmentData, List<AnomalyModel> anomalyModels, Map<UUID, List<Anomaly>> anomalyMap, List<Task> tasks, List<TaskSequence> taskSequences, List<Chat> chats, List<ChatMessage> chatMessages, List<CustomPrompt> prompts, List<MetricDefinition> metricDefinitions, List<MetricDefinitionMetadata> metricDefinitionMetadata, List<UserMetadata> userMetadata, List<BusinessEntityMetadata> entityMetadata, List<BusinessEntityFieldMetadata> fieldMetadata) {
        this.properties = properties;
        this.businessEntities = businessEntities;
        this.sqlDatasource = sqlDatasource;
        this.viewCollections = viewCollections;
        this.viewConfigs = viewConfigs;
        this.calculationFields = calculationFields;
        this.predictionModels = predictionModels;
        this.modelToItemToLastPointMap = modelToItemToLastPointMap;
        this.segmentData = segmentData;
        this.anomalyModels = anomalyModels;
        this.anomalyMap = anomalyMap;
        this.tasks = tasks;
        this.taskSequences = taskSequences;
        this.chats = chats;
        this.chatMessages = chatMessages;
        this.prompts = prompts;
        this.metricDefinitions = metricDefinitions;
        this.metricDefinitionMetadata = metricDefinitionMetadata;
        this.userMetadata = userMetadata;
        this.entityMetadata = entityMetadata;
        this.fieldMetadata = fieldMetadata;
    }

    @Generated
    public MigrationData() {
    }
}

