/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.definition.entity.relation;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.trendz.dao.business.RelationId;
import org.thingsboard.trendz.domain.definition.entity.relation.Direction;
import org.thingsboard.trendz.domain.definition.entity.relation.Relation;
import org.thingsboard.trendz.domain.definition.entity.relation.TemporaryRelationDeserializer;

@JsonDeserialize(using=TemporaryRelationDeserializer.class)
public class Relation {
    private String name;
    private boolean enabled;
    private UUID relatedEntityId;
    private String relationType;
    private Direction direction;

    public Relation(Relation that) {
        this.name = that.name;
        this.enabled = that.enabled;
        this.relatedEntityId = that.relatedEntityId;
        this.relationType = that.relationType;
        this.direction = that.direction;
    }

    public Relation revert(UUID newRelatedId) {
        return new Relation(this.name, this.enabled, newRelatedId, this.relationType, this.direction.opposite());
    }

    public RelationId makeRelationId(UUID entityId) {
        return RelationId.builder().from(entityId).relatedEntityId(this.relatedEntityId).name(this.name).direction(this.direction.name()).build();
    }

    @Generated
    public static RelationBuilder builder() {
        return new RelationBuilder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public UUID getRelatedEntityId() {
        return this.relatedEntityId;
    }

    @Generated
    public String getRelationType() {
        return this.relationType;
    }

    @Generated
    public Direction getDirection() {
        return this.direction;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setRelatedEntityId(UUID relatedEntityId) {
        this.relatedEntityId = relatedEntityId;
    }

    @Generated
    public void setRelationType(String relationType) {
        this.relationType = relationType;
    }

    @Generated
    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Relation)) {
            return false;
        }
        Relation other = (Relation)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        UUID this$relatedEntityId = this.getRelatedEntityId();
        UUID other$relatedEntityId = other.getRelatedEntityId();
        if (this$relatedEntityId == null ? other$relatedEntityId != null : !((Object)this$relatedEntityId).equals(other$relatedEntityId)) {
            return false;
        }
        String this$relationType = this.getRelationType();
        String other$relationType = other.getRelationType();
        if (this$relationType == null ? other$relationType != null : !this$relationType.equals(other$relationType)) {
            return false;
        }
        Direction this$direction = this.getDirection();
        Direction other$direction = other.getDirection();
        return !(this$direction == null ? other$direction != null : !this$direction.equals(other$direction));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Relation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        UUID $relatedEntityId = this.getRelatedEntityId();
        result = result * 59 + ($relatedEntityId == null ? 43 : ((Object)$relatedEntityId).hashCode());
        String $relationType = this.getRelationType();
        result = result * 59 + ($relationType == null ? 43 : $relationType.hashCode());
        Direction $direction = this.getDirection();
        result = result * 59 + ($direction == null ? 43 : $direction.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Relation(name=" + this.getName() + ", enabled=" + this.isEnabled() + ", relatedEntityId=" + String.valueOf(this.getRelatedEntityId()) + ", relationType=" + this.getRelationType() + ", direction=" + String.valueOf(this.getDirection()) + ")";
    }

    @Generated
    public Relation(String name, boolean enabled, UUID relatedEntityId, String relationType, Direction direction) {
        this.name = name;
        this.enabled = enabled;
        this.relatedEntityId = relatedEntityId;
        this.relationType = relationType;
        this.direction = direction;
    }

    @Generated
    public Relation() {
    }
}

