/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.definition.entity.field;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityFieldQuery;
import org.thingsboard.trendz.domain.definition.entity.field.FieldQueryType;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.metric.item.AttributeDetails;
import org.thingsboard.trendz.domain.metric.item.telemetry.TelemetryDetails;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BusinessEntityField {
    private UUID id;
    private UUID businessEntityId;
    private String name;
    private String description;
    private boolean hidden;
    private FieldType type;
    private BusinessEntityFieldQuery query;
    private String calcFunction;

    public BusinessEntityField(BusinessEntityField that) {
        this.id = that.id;
        this.businessEntityId = that.businessEntityId;
        this.name = that.name;
        this.description = that.description;
        this.hidden = that.hidden;
        this.type = that.type;
        this.query = that.query == null ? null : new BusinessEntityFieldQuery(that.query);
        this.calcFunction = that.calcFunction;
    }

    public boolean hasTime() {
        return this.query != null && this.query.hasTime();
    }

    public String uniqKey() {
        if (this.query == null) {
            return null;
        }
        if (this.hasTime()) {
            return TelemetryDetails.uniqKey((String)this.query.getKey());
        }
        if (this.query.getQueryType() == FieldQueryType.ATTRIBUTE) {
            return AttributeDetails.uniqName((String)this.query.getKey(), (String)this.query.getScope());
        }
        return null;
    }

    @Generated
    public static BusinessEntityFieldBuilder builder() {
        return new BusinessEntityFieldBuilder();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public UUID getBusinessEntityId() {
        return this.businessEntityId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public boolean isHidden() {
        return this.hidden;
    }

    @Generated
    public FieldType getType() {
        return this.type;
    }

    @Generated
    public BusinessEntityFieldQuery getQuery() {
        return this.query;
    }

    @Generated
    public String getCalcFunction() {
        return this.calcFunction;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public void setBusinessEntityId(UUID businessEntityId) {
        this.businessEntityId = businessEntityId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Generated
    public void setType(FieldType type) {
        this.type = type;
    }

    @Generated
    public void setQuery(BusinessEntityFieldQuery query) {
        this.query = query;
    }

    @Generated
    public void setCalcFunction(String calcFunction) {
        this.calcFunction = calcFunction;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BusinessEntityField)) {
            return false;
        }
        BusinessEntityField other = (BusinessEntityField)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isHidden() != other.isHidden()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$businessEntityId = this.getBusinessEntityId();
        UUID other$businessEntityId = other.getBusinessEntityId();
        if (this$businessEntityId == null ? other$businessEntityId != null : !((Object)this$businessEntityId).equals(other$businessEntityId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        FieldType this$type = this.getType();
        FieldType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        BusinessEntityFieldQuery this$query = this.getQuery();
        BusinessEntityFieldQuery other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        String this$calcFunction = this.getCalcFunction();
        String other$calcFunction = other.getCalcFunction();
        return !(this$calcFunction == null ? other$calcFunction != null : !this$calcFunction.equals(other$calcFunction));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BusinessEntityField;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHidden() ? 79 : 97);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $businessEntityId = this.getBusinessEntityId();
        result = result * 59 + ($businessEntityId == null ? 43 : ((Object)$businessEntityId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        FieldType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        BusinessEntityFieldQuery $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        String $calcFunction = this.getCalcFunction();
        result = result * 59 + ($calcFunction == null ? 43 : $calcFunction.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BusinessEntityField(id=" + String.valueOf(this.getId()) + ", businessEntityId=" + String.valueOf(this.getBusinessEntityId()) + ", name=" + this.getName() + ", description=" + this.getDescription() + ", hidden=" + this.isHidden() + ", type=" + String.valueOf(this.getType()) + ", query=" + String.valueOf(this.getQuery()) + ", calcFunction=" + this.getCalcFunction() + ")";
    }

    @Generated
    public BusinessEntityField() {
    }

    @Generated
    public BusinessEntityField(UUID id, UUID businessEntityId, String name, String description, boolean hidden, FieldType type, BusinessEntityFieldQuery query, String calcFunction) {
        this.id = id;
        this.businessEntityId = businessEntityId;
        this.name = name;
        this.description = description;
        this.hidden = hidden;
        this.type = type;
        this.query = query;
        this.calcFunction = calcFunction;
    }
}

