/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.definition.entity;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityQuery;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.relation.Relation;
import org.thingsboard.trendz.domain.definition.migration.TrendzEntity;

public class BusinessEntity
implements TrendzEntity {
    private UUID id;
    private UUID tenantId;
    private String name;
    private String description;
    private boolean hidden;
    private List<BusinessEntityField> fields;
    private List<Relation> relations;
    private BusinessEntityQuery query;
    private boolean sharedWithCustomers;

    public BusinessEntity(BusinessEntity that) {
        this.id = that.id;
        this.tenantId = that.tenantId;
        this.name = that.name;
        this.description = that.description;
        this.hidden = that.hidden;
        this.fields = that.fields == null ? null : that.fields.stream().map(BusinessEntityField::new).collect(Collectors.toList());
        this.relations = that.relations == null ? null : that.relations.stream().map(Relation::new).collect(Collectors.toList());
        this.query = that.query == null ? null : new BusinessEntityQuery(that.query);
        this.sharedWithCustomers = that.sharedWithCustomers;
    }

    public String uniqKey() {
        return this.query == null ? null : "%s_%s".formatted(this.query.getEntityType().name(), this.query.getType());
    }

    @Generated
    public static BusinessEntityBuilder builder() {
        return new BusinessEntityBuilder();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public UUID getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public boolean isHidden() {
        return this.hidden;
    }

    @Generated
    public List<BusinessEntityField> getFields() {
        return this.fields;
    }

    @Generated
    public List<Relation> getRelations() {
        return this.relations;
    }

    @Generated
    public BusinessEntityQuery getQuery() {
        return this.query;
    }

    @Generated
    public boolean isSharedWithCustomers() {
        return this.sharedWithCustomers;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public void setTenantId(UUID tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Generated
    public void setFields(List<BusinessEntityField> fields) {
        this.fields = fields;
    }

    @Generated
    public void setRelations(List<Relation> relations) {
        this.relations = relations;
    }

    @Generated
    public void setQuery(BusinessEntityQuery query) {
        this.query = query;
    }

    @Generated
    public void setSharedWithCustomers(boolean sharedWithCustomers) {
        this.sharedWithCustomers = sharedWithCustomers;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BusinessEntity)) {
            return false;
        }
        BusinessEntity other = (BusinessEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isHidden() != other.isHidden()) {
            return false;
        }
        if (this.isSharedWithCustomers() != other.isSharedWithCustomers()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$tenantId = this.getTenantId();
        UUID other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List this$fields = this.getFields();
        List other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        List this$relations = this.getRelations();
        List other$relations = other.getRelations();
        if (this$relations == null ? other$relations != null : !((Object)this$relations).equals(other$relations)) {
            return false;
        }
        BusinessEntityQuery this$query = this.getQuery();
        BusinessEntityQuery other$query = other.getQuery();
        return !(this$query == null ? other$query != null : !this$query.equals(other$query));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BusinessEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHidden() ? 79 : 97);
        result = result * 59 + (this.isSharedWithCustomers() ? 79 : 97);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        List $relations = this.getRelations();
        result = result * 59 + ($relations == null ? 43 : ((Object)$relations).hashCode());
        BusinessEntityQuery $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BusinessEntity(id=" + String.valueOf(this.getId()) + ", tenantId=" + String.valueOf(this.getTenantId()) + ", name=" + this.getName() + ", description=" + this.getDescription() + ", hidden=" + this.isHidden() + ", fields=" + String.valueOf(this.getFields()) + ", relations=" + String.valueOf(this.getRelations()) + ", query=" + String.valueOf(this.getQuery()) + ", sharedWithCustomers=" + this.isSharedWithCustomers() + ")";
    }

    @Generated
    public BusinessEntity() {
    }

    @Generated
    public BusinessEntity(UUID id, UUID tenantId, String name, String description, boolean hidden, List<BusinessEntityField> fields, List<Relation> relations, BusinessEntityQuery query, boolean sharedWithCustomers) {
        this.id = id;
        this.tenantId = tenantId;
        this.name = name;
        this.description = description;
        this.hidden = hidden;
        this.fields = fields;
        this.relations = relations;
        this.query = query;
        this.sharedWithCustomers = sharedWithCustomers;
    }
}

