/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.base;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.thingsboard.trendz.domain.base.Point;
import org.thingsboard.trendz.domain.base.TimeRange;
import org.thingsboard.trendz.domain.base.TimeSeriesStatistic;

public class TimeSeries {
    private List<Point> points;
    private TimeSeriesStatistic statistic;

    public TimeSeries() {
        this.points = Collections.emptyList();
        this.statistic = new TimeSeriesStatistic();
    }

    public TimeSeries(List<Point> points) {
        this.points = points;
        this.statistic = new TimeSeriesStatistic(points);
    }

    public TimeSeries(TimeSeries that) {
        this.points = new ArrayList(that.points);
        this.statistic = new TimeSeriesStatistic(that.statistic);
    }

    public String toString() {
        return this.toString(ZoneId.systemDefault());
    }

    public String toString(ZoneId zoneId) {
        return this.statistic.toString(zoneId);
    }

    public void sort() {
        Collections.sort(this.points);
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.points.isEmpty();
    }

    @JsonIgnore
    public TimeRange getTimeRange() {
        return new TimeRange(this.statistic.getMinTs().longValue(), this.statistic.getMaxTs().longValue());
    }

    @Generated
    public List<Point> getPoints() {
        return this.points;
    }

    @Generated
    public TimeSeriesStatistic getStatistic() {
        return this.statistic;
    }

    @Generated
    public void setPoints(List<Point> points) {
        this.points = points;
    }

    @Generated
    public void setStatistic(TimeSeriesStatistic statistic) {
        this.statistic = statistic;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeSeries)) {
            return false;
        }
        TimeSeries other = (TimeSeries)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List this$points = this.getPoints();
        List other$points = other.getPoints();
        if (this$points == null ? other$points != null : !((Object)this$points).equals(other$points)) {
            return false;
        }
        TimeSeriesStatistic this$statistic = this.getStatistic();
        TimeSeriesStatistic other$statistic = other.getStatistic();
        return !(this$statistic == null ? other$statistic != null : !this$statistic.equals(other$statistic));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TimeSeries;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List $points = this.getPoints();
        result = result * 59 + ($points == null ? 43 : ((Object)$points).hashCode());
        TimeSeriesStatistic $statistic = this.getStatistic();
        result = result * 59 + ($statistic == null ? 43 : $statistic.hashCode());
        return result;
    }
}

