/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.base;

import java.time.ZoneId;
import lombok.Generated;
import org.thingsboard.trendz.domain.base.Point;
import org.thingsboard.trendz.tools.DateTimeUtils;

public class Point
implements Comparable<Point> {
    private long ts;
    private double value;

    public Point(Point that) {
        this.ts = that.ts;
        this.value = that.value;
    }

    @Override
    public int compareTo(Point that) {
        return Long.compare(this.ts, that.ts);
    }

    public String toString() {
        return this.toString(ZoneId.systemDefault());
    }

    public String toString(ZoneId zoneId) {
        return "Point(%s, %s)".formatted(DateTimeUtils.fromTs((long)this.ts, (ZoneId)zoneId), this.value);
    }

    public static Point point(long ts, double value) {
        return new Point(ts, value);
    }

    @Generated
    public static PointBuilder builder() {
        return new PointBuilder();
    }

    @Generated
    public long getTs() {
        return this.ts;
    }

    @Generated
    public double getValue() {
        return this.value;
    }

    @Generated
    public void setTs(long ts) {
        this.ts = ts;
    }

    @Generated
    public void setValue(double value) {
        this.value = value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Point)) {
            return false;
        }
        Point other = (Point)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getTs() != other.getTs()) {
            return false;
        }
        return Double.compare(this.getValue(), other.getValue()) == 0;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Point;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $ts = this.getTs();
        result = result * 59 + (int)($ts >>> 32 ^ $ts);
        long $value = Double.doubleToLongBits(this.getValue());
        result = result * 59 + (int)($value >>> 32 ^ $value);
        return result;
    }

    @Generated
    public Point() {
    }

    @Generated
    public Point(long ts, double value) {
        this.ts = ts;
        this.value = value;
    }
}

