/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.assistance.model;

import java.util.Arrays;
import lombok.Generated;
import org.thingsboard.trendz.domain.assistance.model.LlmProvider;
import org.thingsboard.trendz.exception.assistance.LlmNameNotFoundException;

/*
 * Exception performing whole class analysis ignored.
 */
public enum LlmName {
    CUSTOM("custom"),
    GPT_4_O_MINI("gpt-4o-mini"),
    GPT_4_O("gpt-4o"),
    O3_MINI("o3-mini"),
    O4_MINI("o4-mini"),
    GEMINI_2_5_FLASH("gemini-2.5-flash"),
    GEMINI_2_0_FLASH("gemini-2.0-flash"),
    GEMINI_2_0_FLASH_LITE("gemini-2.0-flash-lite"),
    META_LLAMA_3_1_70b_INSTRUCT("us.meta.llama3-1-70b-instruct-v1:0"),
    META_LLAMA_3_2_90b_INSTRUCT("us.meta.llama3-2-90b-instruct-v1:0"),
    META_LLAMA_3_3_70b_INSTRUCT("us.meta.llama3-3-70b-instruct-v1:0"),
    ANTHROPIC_CLAUDE_3_5_HAIKU("us.anthropic.claude-3-5-haiku-20241022-v1:0"),
    ANTHROPIC_CLAUDE_3_5_SONNET("us.anthropic.claude-3-5-sonnet-20241022-v2:0"),
    ANTHROPIC_CLAUDE_3_7_SONNET("us.anthropic.claude-3-7-sonnet-20250219-v1:0"),
    AMAZON_NOVA_LITE("us.amazon.nova-lite-v1:0"),
    AMAZON_NOVA_PRO("us.amazon.nova-pro-v1:0"),
    MISTRAL_LARGE("mistral.mistral-large-2402-v1:0");

    private final String modelName;

    public static LlmName from(LlmProvider llmProvider, String modelName) {
        if (llmProvider == LlmProvider.CUSTOM) {
            return null;
        }
        return llmProvider.getModelNames().stream().filter(llmName -> llmName.getModelName().equals(modelName)).findAny().orElseThrow(() -> new LlmNameNotFoundException(llmProvider, modelName));
    }

    public static LlmName from(String modelName) {
        return Arrays.stream(LlmName.values()).filter(llmName -> llmName.getModelName().equals(modelName)).findAny().orElseThrow(() -> new LlmNameNotFoundException(modelName));
    }

    public static LlmName fromUnsafe(String modelName) {
        return Arrays.stream(LlmName.values()).filter(llmName -> llmName.getModelName().equals(modelName)).findAny().orElse(null);
    }

    @Generated
    public String getModelName() {
        return this.modelName;
    }

    @Generated
    private LlmName(String modelName) {
        this.modelName = modelName;
    }
}

