/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.anomaly;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.thingsboard.trendz.domain.anomaly.DatasetConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.ItemLite;

public class DatasetConfig {
    private UUID id;
    private UUID businessEntityId;
    private List<ViewField> fields;
    private Set<ItemLite> itemSet;
    private int maxPointsCount;
    private long startTs;
    private long endTs;
    private String tzName;

    public DatasetConfig(DatasetConfig that) {
        this.id = that.id;
        this.fields = that.fields == null ? null : that.fields.stream().map(ViewField::new).collect(Collectors.toList());
        this.itemSet = that.itemSet == null ? new HashSet() : new HashSet(that.itemSet);
        this.maxPointsCount = that.maxPointsCount;
        this.startTs = that.startTs;
        this.endTs = that.endTs;
        this.tzName = that.tzName;
        this.businessEntityId = that.businessEntityId;
    }

    @Generated
    public static DatasetConfigBuilder builder() {
        return new DatasetConfigBuilder();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public UUID getBusinessEntityId() {
        return this.businessEntityId;
    }

    @Generated
    public List<ViewField> getFields() {
        return this.fields;
    }

    @Generated
    public Set<ItemLite> getItemSet() {
        return this.itemSet;
    }

    @Generated
    public int getMaxPointsCount() {
        return this.maxPointsCount;
    }

    @Generated
    public long getStartTs() {
        return this.startTs;
    }

    @Generated
    public long getEndTs() {
        return this.endTs;
    }

    @Generated
    public String getTzName() {
        return this.tzName;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public void setBusinessEntityId(UUID businessEntityId) {
        this.businessEntityId = businessEntityId;
    }

    @Generated
    public void setFields(List<ViewField> fields) {
        this.fields = fields;
    }

    @Generated
    public void setItemSet(Set<ItemLite> itemSet) {
        this.itemSet = itemSet;
    }

    @Generated
    public void setMaxPointsCount(int maxPointsCount) {
        this.maxPointsCount = maxPointsCount;
    }

    @Generated
    public void setStartTs(long startTs) {
        this.startTs = startTs;
    }

    @Generated
    public void setEndTs(long endTs) {
        this.endTs = endTs;
    }

    @Generated
    public void setTzName(String tzName) {
        this.tzName = tzName;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatasetConfig)) {
            return false;
        }
        DatasetConfig other = (DatasetConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getMaxPointsCount() != other.getMaxPointsCount()) {
            return false;
        }
        if (this.getStartTs() != other.getStartTs()) {
            return false;
        }
        if (this.getEndTs() != other.getEndTs()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$businessEntityId = this.getBusinessEntityId();
        UUID other$businessEntityId = other.getBusinessEntityId();
        if (this$businessEntityId == null ? other$businessEntityId != null : !((Object)this$businessEntityId).equals(other$businessEntityId)) {
            return false;
        }
        List this$fields = this.getFields();
        List other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        Set this$itemSet = this.getItemSet();
        Set other$itemSet = other.getItemSet();
        if (this$itemSet == null ? other$itemSet != null : !((Object)this$itemSet).equals(other$itemSet)) {
            return false;
        }
        String this$tzName = this.getTzName();
        String other$tzName = other.getTzName();
        return !(this$tzName == null ? other$tzName != null : !this$tzName.equals(other$tzName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DatasetConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxPointsCount();
        long $startTs = this.getStartTs();
        result = result * 59 + (int)($startTs >>> 32 ^ $startTs);
        long $endTs = this.getEndTs();
        result = result * 59 + (int)($endTs >>> 32 ^ $endTs);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $businessEntityId = this.getBusinessEntityId();
        result = result * 59 + ($businessEntityId == null ? 43 : ((Object)$businessEntityId).hashCode());
        List $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        Set $itemSet = this.getItemSet();
        result = result * 59 + ($itemSet == null ? 43 : ((Object)$itemSet).hashCode());
        String $tzName = this.getTzName();
        result = result * 59 + ($tzName == null ? 43 : $tzName.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DatasetConfig(id=" + String.valueOf(this.getId()) + ", businessEntityId=" + String.valueOf(this.getBusinessEntityId()) + ", fields=" + String.valueOf(this.getFields()) + ", itemSet=" + String.valueOf(this.getItemSet()) + ", maxPointsCount=" + this.getMaxPointsCount() + ", startTs=" + this.getStartTs() + ", endTs=" + this.getEndTs() + ", tzName=" + this.getTzName() + ")";
    }

    @Generated
    public DatasetConfig() {
    }

    @Generated
    public DatasetConfig(UUID id, UUID businessEntityId, List<ViewField> fields, Set<ItemLite> itemSet, int maxPointsCount, long startTs, long endTs, String tzName) {
        this.id = id;
        this.businessEntityId = businessEntityId;
        this.fields = fields;
        this.itemSet = itemSet;
        this.maxPointsCount = maxPointsCount;
        this.startTs = startTs;
        this.endTs = endTs;
        this.tzName = tzName;
    }
}

