/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.anomaly;

import lombok.Generated;
import org.thingsboard.trendz.domain.anomaly.AnomalyModel;
import org.thingsboard.trendz.domain.anomaly.AnomalyModelProperties;
import org.thingsboard.trendz.domain.anomaly.AnomalyModelStatus;
import org.thingsboard.trendz.domain.anomaly.ChangeAnomalyModelConfig;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ChangeAnomalyModelConfig {
    private final boolean isFailedOrCanceledStatus;
    private final boolean isModelTypeTheSame;
    private final boolean isNameTheSame;
    private final boolean isTelemetryKeyTheSame;
    private final boolean isTelemetrySavingOptionsTheSame;
    private final boolean isDatasetTheSame;
    private final boolean isMlPropertiesTheSame;
    private final boolean isAlarmTypeTheSame;
    private final boolean isAlarmConfigTheSame;

    public boolean isRebuildRequired() {
        return !this.isModelTypeTheSame || !this.isDatasetTheSame || !this.isMlPropertiesTheSame || this.isFailedOrCanceledStatus;
    }

    public static ChangeAnomalyModelConfig getInstance(AnomalyModel model, AnomalyModelProperties properties) {
        boolean isFailedOrCanceledStatus = model.getStatus() == AnomalyModelStatus.FAILED || model.getStatus() == AnomalyModelStatus.CANCELED;
        boolean isModelTypeTheSame = properties.getModelType() == null || properties.getModelType() == model.getType();
        boolean isNameTheSame = properties.getName() == null || properties.getName().equals(model.getName());
        boolean isTelemetryKeyTheSame = properties.getTbTelemetryKey() == null || properties.getTbTelemetryKey().equals(model.getTbTelemetryKey());
        boolean isTelemetrySavingOptionsTheSame = properties.getTelemetrySavePeriodUnit() == null || properties.getTelemetrySavePeriodUnit().equals(model.getTelemetrySavePeriodUnit());
        boolean isDatasetTheSame = properties.getDatasetConfig() == null;
        boolean isMlPropertiesTheSame = properties.getMlProperties() == null;
        boolean isAlarmTypeChanged = properties.getAlarmType() == null || properties.getAlarmType().equals(model.getAlarmType());
        boolean isAlarmConfigTheSame = properties.getAlarmConfig() == null;
        return ChangeAnomalyModelConfig.builder().isFailedOrCanceledStatus(isFailedOrCanceledStatus).isModelTypeTheSame(isModelTypeTheSame).isNameTheSame(isNameTheSame).isTelemetryKeyTheSame(isTelemetryKeyTheSame).isTelemetrySavingOptionsTheSame(isTelemetrySavingOptionsTheSame).isDatasetTheSame(isDatasetTheSame).isMlPropertiesTheSame(isMlPropertiesTheSame).isAlarmTypeTheSame(isAlarmTypeChanged).isAlarmConfigTheSame(isAlarmConfigTheSame).build();
    }

    public static ChangeAnomalyModelConfig getInstanceForNewModel() {
        return ChangeAnomalyModelConfig.builder().isFailedOrCanceledStatus(false).isModelTypeTheSame(false).isNameTheSame(false).isTelemetryKeyTheSame(false).isTelemetrySavingOptionsTheSame(false).isDatasetTheSame(false).isMlPropertiesTheSame(false).isAlarmTypeTheSame(false).isAlarmConfigTheSame(false).build();
    }

    @Generated
    public static ChangeAnomalyModelConfigBuilder builder() {
        return new ChangeAnomalyModelConfigBuilder();
    }

    @Generated
    public boolean isFailedOrCanceledStatus() {
        return this.isFailedOrCanceledStatus;
    }

    @Generated
    public boolean isModelTypeTheSame() {
        return this.isModelTypeTheSame;
    }

    @Generated
    public boolean isNameTheSame() {
        return this.isNameTheSame;
    }

    @Generated
    public boolean isTelemetryKeyTheSame() {
        return this.isTelemetryKeyTheSame;
    }

    @Generated
    public boolean isTelemetrySavingOptionsTheSame() {
        return this.isTelemetrySavingOptionsTheSame;
    }

    @Generated
    public boolean isDatasetTheSame() {
        return this.isDatasetTheSame;
    }

    @Generated
    public boolean isMlPropertiesTheSame() {
        return this.isMlPropertiesTheSame;
    }

    @Generated
    public boolean isAlarmTypeTheSame() {
        return this.isAlarmTypeTheSame;
    }

    @Generated
    public boolean isAlarmConfigTheSame() {
        return this.isAlarmConfigTheSame;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeAnomalyModelConfig)) {
            return false;
        }
        ChangeAnomalyModelConfig other = (ChangeAnomalyModelConfig)o;
        if (this.isFailedOrCanceledStatus() != other.isFailedOrCanceledStatus()) {
            return false;
        }
        if (this.isModelTypeTheSame() != other.isModelTypeTheSame()) {
            return false;
        }
        if (this.isNameTheSame() != other.isNameTheSame()) {
            return false;
        }
        if (this.isTelemetryKeyTheSame() != other.isTelemetryKeyTheSame()) {
            return false;
        }
        if (this.isTelemetrySavingOptionsTheSame() != other.isTelemetrySavingOptionsTheSame()) {
            return false;
        }
        if (this.isDatasetTheSame() != other.isDatasetTheSame()) {
            return false;
        }
        if (this.isMlPropertiesTheSame() != other.isMlPropertiesTheSame()) {
            return false;
        }
        if (this.isAlarmTypeTheSame() != other.isAlarmTypeTheSame()) {
            return false;
        }
        return this.isAlarmConfigTheSame() == other.isAlarmConfigTheSame();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFailedOrCanceledStatus() ? 79 : 97);
        result = result * 59 + (this.isModelTypeTheSame() ? 79 : 97);
        result = result * 59 + (this.isNameTheSame() ? 79 : 97);
        result = result * 59 + (this.isTelemetryKeyTheSame() ? 79 : 97);
        result = result * 59 + (this.isTelemetrySavingOptionsTheSame() ? 79 : 97);
        result = result * 59 + (this.isDatasetTheSame() ? 79 : 97);
        result = result * 59 + (this.isMlPropertiesTheSame() ? 79 : 97);
        result = result * 59 + (this.isAlarmTypeTheSame() ? 79 : 97);
        result = result * 59 + (this.isAlarmConfigTheSame() ? 79 : 97);
        return result;
    }

    @Generated
    public String toString() {
        return "ChangeAnomalyModelConfig(isFailedOrCanceledStatus=" + this.isFailedOrCanceledStatus() + ", isModelTypeTheSame=" + this.isModelTypeTheSame() + ", isNameTheSame=" + this.isNameTheSame() + ", isTelemetryKeyTheSame=" + this.isTelemetryKeyTheSame() + ", isTelemetrySavingOptionsTheSame=" + this.isTelemetrySavingOptionsTheSame() + ", isDatasetTheSame=" + this.isDatasetTheSame() + ", isMlPropertiesTheSame=" + this.isMlPropertiesTheSame() + ", isAlarmTypeTheSame=" + this.isAlarmTypeTheSame() + ", isAlarmConfigTheSame=" + this.isAlarmConfigTheSame() + ")";
    }

    @Generated
    private ChangeAnomalyModelConfig(boolean isFailedOrCanceledStatus, boolean isModelTypeTheSame, boolean isNameTheSame, boolean isTelemetryKeyTheSame, boolean isTelemetrySavingOptionsTheSame, boolean isDatasetTheSame, boolean isMlPropertiesTheSame, boolean isAlarmTypeTheSame, boolean isAlarmConfigTheSame) {
        this.isFailedOrCanceledStatus = isFailedOrCanceledStatus;
        this.isModelTypeTheSame = isModelTypeTheSame;
        this.isNameTheSame = isNameTheSame;
        this.isTelemetryKeyTheSame = isTelemetryKeyTheSame;
        this.isTelemetrySavingOptionsTheSame = isTelemetrySavingOptionsTheSame;
        this.isDatasetTheSame = isDatasetTheSame;
        this.isMlPropertiesTheSame = isMlPropertiesTheSame;
        this.isAlarmTypeTheSame = isAlarmTypeTheSame;
        this.isAlarmConfigTheSame = isAlarmConfigTheSame;
    }
}

