/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.user;

import jakarta.transaction.Transactional;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.user.UserMetadataDto;
import org.thingsboard.trendz.dao.user.UserMetadataRepository;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.domain.user.UserMetadata;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.tools.json.JsonUtils;

@Service
@Transactional
public class UserMetadataDao {
    private final UserMetadataRepository userMetadataRepository;

    @Autowired
    public UserMetadataDao(UserMetadataRepository userMetadataRepository) {
        this.userMetadataRepository = userMetadataRepository;
    }

    public Optional<UserMetadata> getMetadata(JwtSecurityUser user) {
        UUID tenantId = user.getTenantId();
        UUID customerId = user.getCustomerId();
        return this.userMetadataRepository.findByUser(tenantId, customerId).map(UserMetadataDto::toData);
    }

    public UserMetadata updateMetadata(JwtSecurityUser user, DatePickerConfig datePickerConfig, UUID entityId, ItemLite itemLite) {
        UUID tenantId = user.getTenantId();
        UUID customerId = user.getCustomerId();
        UserMetadataDto metadataDto = this.userMetadataRepository.findByUser(tenantId, customerId).orElseGet(() -> UserMetadataDto.builder().id(UUID.randomUUID()).tenantId(tenantId).customerId(customerId).build());
        if (datePickerConfig != null) {
            metadataDto.setDefaultDatePickerConfig(JsonUtils.toJson((Object)datePickerConfig));
        }
        if (entityId != null) {
            metadataDto.setDefaultBusinessEntityId(entityId);
        }
        if (itemLite != null) {
            metadataDto.setDefaultItemId(itemLite.getId());
            metadataDto.setDefaultItemName(itemLite.getName());
        }
        return ((UserMetadataDto)this.userMetadataRepository.save((Object)metadataDto)).toData();
    }

    public List<UserMetadata> saveAll(List<UserMetadata> userMetadata) {
        return userMetadata.stream().map(metadata -> this.updateMetadata(JwtSecurityUser.builder().tenantId(metadata.getTenantId()).customerId(metadata.getCustomerId()).build(), metadata.getDefaultDatePickerConfig(), metadata.getDefaultBusinessEntityId(), metadata.getDefaultItem())).toList();
    }

    public List<UserMetadata> findAllByTenantId(JwtSecurityUser user) {
        return this.userMetadataRepository.findAllByTenantId(user.getTenantId()).stream().map(UserMetadataDto::toData).toList();
    }
}

