/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.task;

import jakarta.transaction.Transactional;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.task.TaskSequenceDto;
import org.thingsboard.trendz.dao.task.TaskSequenceRepository;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.task.model.TaskReference;
import org.thingsboard.trendz.service.task.model.TaskSequence;
import org.thingsboard.trendz.service.task.model.TaskSequenceFilteringField;
import org.thingsboard.trendz.service.task.model.TaskSequenceSortingField;
import org.thingsboard.trendz.tools.UUIDUtils;

@Service
@Transactional
public class TaskSequenceDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskSequenceDao.class);
    private final TaskSequenceRepository taskSequenceRepository;

    @Autowired
    public TaskSequenceDao(TaskSequenceRepository taskSequenceRepository) {
        this.taskSequenceRepository = taskSequenceRepository;
    }

    public List<TaskSequence> exportAll(JwtSecurityUser user) {
        UUID tenantId = user.getTenantId();
        UUID customerId = UUIDUtils.mapNullUuidToNull((UUID)user.getCustomerId());
        return this.taskSequenceRepository.exportAllByTenantIdAndCustomerId(tenantId, customerId).stream().map(TaskSequenceDto::toData).collect(Collectors.toList());
    }

    public List<TaskSequence> importAll(List<TaskSequence> taskSequences) {
        List<TaskSequenceDto> dtos = taskSequences.stream().map(TaskSequenceDto::from).toList();
        return StreamSupport.stream(this.taskSequenceRepository.saveAll(dtos).spliterator(), false).map(TaskSequenceDto::toData).toList();
    }

    public Page<TaskSequence> findAllTaskSequences(JwtSecurityUser user, int page, int pageSize, List<TaskSequenceFilteringField> filteringFields, List<TaskSequenceSortingField> sortingFields) {
        UUID tenantId = user.getTenantId();
        UUID customerId = UUIDUtils.mapNullUuidToNull((UUID)user.getCustomerId());
        Map<TaskSequenceFilteringField.Type, String> filterMap = filteringFields.stream().collect(Collectors.toMap(TaskSequenceFilteringField::getType, TaskSequenceFilteringField::getValue));
        String name = filterMap.get(TaskSequenceFilteringField.Type.NAME);
        List orders = sortingFields.stream().map(sortingField -> new Sort.Order(sortingField.getDirection(), sortingField.getType().getValue())).collect(Collectors.toList());
        return this.taskSequenceRepository.findAllByTenantIdAndCustomerId(tenantId, customerId, name, (Pageable)PageRequest.of((int)page, (int)pageSize, (Sort)Sort.by(orders))).map(TaskSequenceDto::toData);
    }

    public Optional<TaskSequence> findTaskSequenceById(JwtSecurityUser user, UUID id) {
        return this.findTaskSequenceById(user, id, false);
    }

    public Optional<TaskSequence> findTaskSequenceById(JwtSecurityUser user, UUID id, boolean insecure) {
        UUID tenantId = user.getTenantId();
        UUID customerId = UUIDUtils.mapNullUuidToNull((UUID)user.getCustomerId());
        return this.taskSequenceRepository.findByIdAndTenantIdAndCustomerId(id, tenantId, customerId, insecure).map(TaskSequenceDto::toData);
    }

    public TaskSequence saveSequence(TaskSequence sequence) {
        TaskSequenceDto sequenceDto = TaskSequenceDto.from((TaskSequence)sequence);
        TaskSequenceDto savedDto = (TaskSequenceDto)this.taskSequenceRepository.save((Object)sequenceDto);
        return savedDto.toData();
    }

    public void deleteSequence(UUID id) {
        this.taskSequenceRepository.deleteById((Object)id);
    }

    public Set<TaskReference> checkTaskExistence(JwtSecurityUser user, Set<TaskReference> taskReferenceSet) {
        UUID tenantId = user.getTenantId();
        UUID customerId = UUIDUtils.mapNullUuidToNull((UUID)user.getCustomerId());
        if (taskReferenceSet.isEmpty()) {
            return Collections.emptySet();
        }
        return this.taskSequenceRepository.checkTaskExistence(tenantId, customerId, taskReferenceSet);
    }
}

