/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.task;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.thingsboard.trendz.dao.task.TaskAndExecutionInfoDto;
import org.thingsboard.trendz.dao.task.TaskDto;
import org.thingsboard.trendz.dao.task.TaskExecutionDto;
import org.thingsboard.trendz.service.task.model.TaskJobType;
import org.thingsboard.trendz.service.task.model.TaskLite;
import org.thingsboard.trendz.service.task.model.TaskReferencedEntityType;

@Repository
public interface TaskRepository
extends CrudRepository<TaskDto, UUID> {
    @Query(value="SELECT new org.thingsboard.trendz.service.task.model.TaskLite(\n    t.id,\n    t.tenantId,\n    t.customerId,\n    t.createdTs,\n    t.updatedTs,\n    MAX(te.startTs),\n    t.name,\n    t.jobType,\n    t.reference.type\n)\nFROM TaskDto t\nLEFT JOIN TaskExecutionDto te ON te.taskId = t.id\nWHERE t.tenantId = :tenantId\n  AND (:customerId IS NULL OR t.customerId = :customerId)\n  AND (:enabled IS NULL OR t.enabled = :enabled)\n  AND (:jobType IS NULL OR t.jobType = :jobType)\n  AND (:name IS NULL OR t.name LIKE %:name%)\n  AND (:referencedEntityKeySet IS NULL OR t.reference.key IN (:referencedEntityKeySet))\n  AND (:referencedEntityTypeSet IS NULL OR t.reference.type IN (:referencedEntityTypeSet))\nGROUP BY t.id, t.tenantId, t.customerId, t.createdTs, t.updatedTs, t.name, t.jobType, t.reference.type\n")
    public Page<TaskLite> findAllLiteByTenantIdAndCustomerId(@Param(value="tenantId") UUID var1, @Param(value="customerId") UUID var2, @Param(value="enabled") Boolean var3, @Param(value="jobType") TaskJobType var4, @Param(value="name") String var5, @Param(value="referencedEntityKeySet") Set<String> var6, @Param(value="referencedEntityTypeSet") Set<TaskReferencedEntityType> var7, Pageable var8);

    @Query(value="SELECT t\nFROM TaskDto t\nWHERE t.tenantId = :tenantId\n  AND (coalesce(:customerId, null) IS NULL OR t.customerId = :customerId)\n  AND (coalesce(:enabled, null) IS NULL OR t.enabled = :enabled)\n  AND (coalesce(:jobType, null) IS NULL OR t.jobType = :jobType)\n  AND (coalesce(:name, null) IS NULL OR t.name LIKE %:name%)\n  AND (coalesce(:referencedEntityKeySet, null) IS NULL OR t.reference.key IN (:referencedEntityKeySet))\n  AND (coalesce(:referencedEntityTypeSet, null) IS NULL OR t.reference.type IN (:referencedEntityTypeSet))\n")
    public Page<TaskDto> findAllByTenantIdAndCustomerId(@Param(value="tenantId") UUID var1, @Param(value="customerId") UUID var2, @Param(value="enabled") Boolean var3, @Param(value="jobType") TaskJobType var4, @Param(value="name") String var5, @Param(value="referencedEntityKeySet") Set<String> var6, @Param(value="referencedEntityTypeSet") Set<TaskReferencedEntityType> var7, Pageable var8);

    @Query(value="SELECT new org.thingsboard.trendz.dao.task.TaskAndExecutionInfoDto(\n  te.taskId, te.id, te.status\n)\nFROM TaskExecutionDto te\nWHERE te.taskId IN (:taskIdSet)\n")
    public Set<TaskAndExecutionInfoDto> findAllExecutionsInfoByTaskIdSet(@Param(value="taskIdSet") Set<UUID> var1);

    @Query(value="SELECT t\nFROM TaskDto t\nWHERE t.id = :id\n  AND t.tenantId = :tenantId\n  AND (:insecure = TRUE OR coalesce(:customerId, null) IS NULL OR t.customerId = :customerId)\n")
    public Optional<TaskDto> findByIdAndTenantIdAndCustomerId(@Param(value="id") UUID var1, @Param(value="tenantId") UUID var2, @Param(value="customerId") UUID var3, @Param(value="insecure") boolean var4);

    @Query(value="SELECT te\nFROM TaskExecutionDto te\nWHERE te.id = :id\n  AND te.tenantId = :tenantId\n  AND (coalesce(:customerId, null) IS NULL OR te.customerId = :customerId)\n")
    public Optional<TaskExecutionDto> findExecutionByIdAndTenantIdAndCustomerId(@Param(value="id") UUID var1, @Param(value="tenantId") UUID var2, @Param(value="customerId") UUID var3);

    @Query(value="SELECT t\nFROM TaskDto t\nWHERE t.reference.type = :type\n  AND t.reference.key = :key\n  AND t.tenantId = :tenantId\n  AND (:insecure = TRUE OR coalesce(:customerId, null) IS NULL OR t.customerId = :customerId)\n")
    public Optional<TaskDto> findTaskByReferencedEntityAndTenantIdAndCustomerId(@Param(value="tenantId") UUID var1, @Param(value="customerId") UUID var2, @Param(value="type") TaskReferencedEntityType var3, @Param(value="key") String var4, @Param(value="insecure") boolean var5);

    @Query(nativeQuery=true, value="UPDATE trendz_task t SET json_job = :taskJob WHERE t.id = :taskId\n")
    @Modifying
    public void updateTaskJob(@Param(value="taskId") UUID var1, @Param(value="taskJob") String var2);

    @Query(nativeQuery=true, value="UPDATE trendz_task t SET enabled = :enabled WHERE t.id = :taskId\n")
    @Modifying
    public void updateTaskEnabled(@Param(value="taskId") UUID var1, @Param(value="enabled") boolean var2);

    @Modifying
    @Query(nativeQuery=true, value="DELETE FROM trendz_task_execution\nWHERE id IN (\n    SELECT te.id\n    FROM trendz_task_execution te JOIN trendz_task t ON te.task_id = t.id\n    WHERE t.ttl_enabled = true AND\n          te.status = 'FINISHED' AND\n          :currentTime - te.finish_ts > t.ttl_duration\n)\n")
    public int deleteExpiredTaskExecutions(@Param(value="currentTime") long var1);

    @Modifying
    @Query(nativeQuery=true, value="DELETE FROM trendz_task_execution\nWHERE id IN (\n    SELECT te.id\n    FROM trendz_task_execution te\n    JOIN trendz_task t ON te.task_id = t.id\n    WHERE t.store_execution_enabled = true\n      AND te.status = 'FINISHED'\n      AND te.id NOT IN (\n          SELECT te2.id\n          FROM trendz_task_execution te2\n          WHERE te2.task_id = te.task_id\n          ORDER BY te2.created_ts DESC\n          LIMIT t.store_execution_count\n      )\n)\n")
    public int deleteExceedingTaskExecutions();

    @Query(nativeQuery=true, value="DELETE FROM trendz_task_execution te WHERE te.id IN (:taskExecutionIds)\n")
    @Modifying
    public void deleteTaskExecutionsByIdSet(@Param(value="taskExecutionIds") Set<UUID> var1);

    @Query(nativeQuery=true, value="DELETE FROM trendz_task_execution_state_record tesr WHERE tesr.execution_id IN (:taskExecutionIds)\n")
    @Modifying
    public void deleteTaskExecutionStateRecordsByIdSet(@Param(value="taskExecutionIds") Set<UUID> var1);

    @Query(nativeQuery=true, value="SELECT CAST(te.id AS VARCHAR), CAST(te.task_id AS VARCHAR)\nFROM trendz_task_execution te LEFT JOIN trendz_task_execution_state_record tesr ON te.id = tesr.execution_id\nWHERE (te.status = 'CREATED' OR te.status = 'RUNNING') AND :currentTime - tesr.last_update_ts > :recordTimeout\n")
    public List<Object[]> loadLostTaskExecutions(@Param(value="recordTimeout") long var1, @Param(value="currentTime") long var3);

    @Query(nativeQuery=true, value="SELECT CAST(ter.execution_id AS VARCHAR), CAST(ter.task_id AS VARCHAR)\nFROM trendz_task_execution_request ter LEFT JOIN trendz_task_execution te ON ter.execution_id = te.id\nWHERE\n    ter.state = 'BORROWED' AND\n    (te.id IS NULL OR te.id IN (:lostTaskExecutionIds))\n")
    public List<Object[]> findLostTaskExecutionRequests(@Param(value="lostTaskExecutionIds") Set<UUID> var1);

    @Query(nativeQuery=true, value="UPDATE trendz_task_execution SET status = 'LOST', finish_ts = :currentTime WHERE id IN (:lostTaskExecutionIds)\n")
    @Modifying
    public void labelLostTaskExecutions(@Param(value="lostTaskExecutionIds") Set<UUID> var1, @Param(value="currentTime") long var2);

    @Query(value="DELETE FROM TaskExecutionRequestDto ter WHERE ter.executionId IN (:executionIdSet)\n")
    @Modifying
    public void removeAllExecutionRequestsByExecutionIdSet(@Param(value="executionIdSet") Set<UUID> var1);

    @Query(nativeQuery=true, value="UPDATE trendz_task_scheduling_state_record tsr\nSET last_finish_ts = :currentTime, state = 'FREE'\nWHERE tsr.task_id IN (:lostTaskIds)\n")
    @Modifying
    public void labelLostTaskStateRecords(@Param(value="lostTaskIds") Set<UUID> var1, @Param(value="currentTime") long var2);

    @Query(nativeQuery=true, value="SELECT CAST(tesr.execution_id AS VARCHAR), tesr.state, tesr.last_update_ts, tesr.removed_task\nFROM trendz_task_execution te\nJOIN trendz_task_execution_state_record tesr ON te.id = tesr.execution_id\nWHERE te.id IN (:currentTaskExecutionIds) AND tesr.state = 'CANCELLED'\n")
    public Set<Object[]> findCancelledTaskExecutionIds(@Param(value="currentTaskExecutionIds") Set<UUID> var1);

    @Query(nativeQuery=true, value="SELECT CAST(ter.task_id AS VARCHAR), CAST(ter.execution_id AS VARCHAR)\nFROM trendz_task_execution_request ter\nWHERE ter.state = 'FREE'\nORDER BY ter.created_ts\nLIMIT 1\nFOR UPDATE\n")
    public Optional<Object[][]> findNextExecutionRequest();

    @Query(nativeQuery=true, value="SELECT CAST(tsr.task_id AS VARCHAR)\nFROM trendz_task t LEFT JOIN trendz_task_scheduling_state_record tsr ON t.id = tsr.task_id\nWHERE t.enabled = true AND t.schedule_type = 'PLANNED' AND tsr.state = 'FREE' AND :currentTime - t.schedule_planned_ts > 0\nORDER BY t.created_ts\nLIMIT 1\nFOR UPDATE\n")
    public Optional<UUID> findNextPlannedTask(@Param(value="currentTime") long var1);

    @Query(nativeQuery=true, value="SELECT CAST(tsr.task_id AS VARCHAR)\nFROM trendz_task t LEFT JOIN trendz_task_scheduling_state_record tsr ON t.id = tsr.task_id\nWHERE t.enabled = true AND t.schedule_type = 'PERIODIC' AND tsr.state = 'FREE' AND :currentTime - tsr.last_finish_ts >= t.schedule_period_ts\nORDER BY t.created_ts\nLIMIT 1\nFOR UPDATE\n")
    public Optional<UUID> findNextPeriodicTask(@Param(value="currentTime") long var1);

    @Query(nativeQuery=true, value="WITH calc AS (\n  SELECT\n    t.id                                  AS task_id,\n    tsr.last_finish_ts,\n    t.schedule_scheduling_time_zone       AS tz,\n    t.schedule_scheduling_unit            AS unit,\n    t.schedule_scheduling_unit_count      AS cnt,\n\n    -- anchor: last execution time truncated by unit and timezone\n    date_trunc(\n      lower(CAST(t.schedule_scheduling_unit AS text)),\n      timezone(\n        t.schedule_scheduling_time_zone,\n        to_timestamp(tsr.last_finish_ts / 1000.0)\n      )\n    ) AS anchor\n  FROM trendz_task t\n  JOIN trendz_task_scheduling_state_record tsr ON t.id = tsr.task_id\n  WHERE\n    t.enabled = TRUE\n    AND t.schedule_type = 'SCHEDULED'\n)\n\nSELECT CAST(c.task_id AS VARCHAR)\nFROM calc c\nWHERE\n  timezone(c.tz, to_timestamp(:currentTimeMs / 1000.0)) >= c.anchor + c.cnt *\n    CASE c.unit\n      WHEN 'HOURS'   THEN interval '1 hour'\n      WHEN 'MINUTES' THEN interval '1 minute'\n      WHEN 'DAYS'    THEN interval '1 day'\n      WHEN 'WEEKS'   THEN interval '1 week'\n    END\n  AND EXISTS (\n    SELECT 1\n    FROM trendz_task_scheduling_state_record tsr2\n    WHERE\n      tsr2.task_id = c.task_id\n      AND tsr2.state = 'FREE'\n  )\nORDER BY (SELECT created_ts FROM trendz_task WHERE id = c.task_id)\nLIMIT 1\nFOR UPDATE\n")
    public Optional<UUID> findNextScheduledTask(@Param(value="currentTimeMs") long var1);

    @Query(value="SELECT\n    CAST(vc.id AS VARCHAR) AS view_config_id,\n    (CASE WHEN vc.task_id IS NULL THEN 'NO_TASK_REFERENCE' ELSE 'TASK_REFERENCE_EXISTS' END) AS task_cache_reference,\n    (CASE WHEN vc.calculated_telemetry_saving_task_id IS NULL THEN 'NO_TASK_REFERENCE' ELSE 'TASK_REFERENCE_EXISTS' END) AS task_save_reference,\n    (CASE WHEN cache_task.id IS NULL THEN 'NO_TASK_FOUND' ELSE 'TASK_EXISTS' END) AS task_cache_presence,\n    (CASE WHEN save_task.id IS NULL THEN 'NO_TASK_FOUND' ELSE 'TASK_EXISTS' END) AS task_save_presence,\n    COALESCE((SELECT status FROM trendz_task_execution cache_execution WHERE cache_execution.task_id = cache_task.id ORDER BY cache_execution.created_ts DESC LIMIT 1), 'NO_EXECUTION') AS last_execution_cache_status,\n    COALESCE((SELECT status FROM trendz_task_execution save_execution WHERE save_execution.task_id = save_task.id ORDER BY save_execution.created_ts DESC LIMIT 1), 'NO_EXECUTION') AS last_execution_save_status\nFROM view_config vc\nLEFT JOIN trendz_task cache_task ON vc.task_id = cache_task.id\nLEFT JOIN trendz_task save_task ON vc.calculated_telemetry_saving_task_id = save_task.id\nWHERE vc.tenant_id = :tenantId AND vc.id IN (:configIdSet);\n", nativeQuery=true)
    public List<Object[]> getViewConfigStatusData(@Param(value="tenantId") UUID var1, @Param(value="configIdSet") Set<UUID> var2);
}

