/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.task;

import java.util.Set;
import java.util.UUID;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.thingsboard.trendz.dao.task.TaskExecutionStateRecordDto;

@Repository
public interface TaskExecutionStateRecordRepository
extends CrudRepository<TaskExecutionStateRecordDto, UUID> {
    @Modifying
    @Query(nativeQuery=true, value="UPDATE trendz_task_execution_state_record te SET state = :state, last_update_ts = :lastUpdateTs WHERE execution_id in :ids ")
    public void updateBatch(@Param(value="ids") Set<UUID> var1, @Param(value="state") String var2, @Param(value="lastUpdateTs") long var3);

    @Modifying
    @Query(nativeQuery=true, value="UPDATE trendz_task_execution_state_record as tesr SET state = 'CANCELLED' WHERE tesr.state = 'WORKING' AND tesr.execution_id IN (SELECT te.id FROM trendz_task_execution_state_record tesr LEFT JOIN trendz_task_execution te ON tesr.execution_id = te.id LEFT JOIN trendz_task task ON te.task_id = task.id WHERE task.tenant_id = :tenantId AND task.customer_id = :customerId )")
    public void cancelByTenantIdAndCustomerId(@Param(value="tenantId") UUID var1, @Param(value="customerId") UUID var2);

    @Modifying
    @Query(nativeQuery=true, value="UPDATE trendz_task_execution_state_record as tesr SET state = 'CANCELLED', removed_task = :removedTask WHERE tesr.state = 'WORKING' AND tesr.execution_id IN (SELECT te.id FROM trendz_task_execution_state_record tesr LEFT JOIN trendz_task_execution te ON tesr.execution_id = te.id LEFT JOIN trendz_task task ON te.task_id = task.id WHERE task.id = :taskId AND task.tenant_id = :tenantId AND task.customer_id = :customerId )")
    public void cancelByTaskIdAndTenantIdAndCustomerId(@Param(value="taskId") UUID var1, @Param(value="tenantId") UUID var2, @Param(value="customerId") UUID var3, @Param(value="removedTask") boolean var4);
}

