/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.task;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.dao.task.TaskExecutionProgressStepDto;
import org.thingsboard.trendz.service.task.model.TaskExecutionProgressStep;
import org.thingsboard.trendz.tools.UUIDUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="trendz_task_execution_progress_step")
public class TaskExecutionProgressStepDto {
    @Id
    private UUID id;
    @Column(name="execution_id")
    private UUID executionId;
    @Column(name="parent_step_id")
    private UUID parentStepId;
    @Column(name="name")
    private String name;
    @Column(name="start_ts")
    private long startTs;
    @Column(name="finish_ts")
    private long finishTs;

    public TaskExecutionProgressStep toData() {
        return TaskExecutionProgressStep.builder().id(this.id).taskExecutionId(this.executionId).parentStepId(Objects.requireNonNullElse(this.parentStepId, EntityId.NULL_UUID)).childrenSteps(new ArrayList()).name(this.name).startTs(this.startTs).finishTs(this.finishTs).build();
    }

    public static TaskExecutionProgressStepDto from(TaskExecutionProgressStep entity) {
        UUID parentId = UUIDUtils.mapNullUuidToNull((UUID)entity.getParentStepId());
        return TaskExecutionProgressStepDto.builder().id(entity.getId()).executionId(entity.getTaskExecutionId()).parentStepId(parentId).name(entity.getName()).startTs(entity.getStartTs()).finishTs(entity.getFinishTs()).build();
    }

    @Generated
    public static TaskExecutionProgressStepDtoBuilder builder() {
        return new TaskExecutionProgressStepDtoBuilder();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public UUID getExecutionId() {
        return this.executionId;
    }

    @Generated
    public UUID getParentStepId() {
        return this.parentStepId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public long getStartTs() {
        return this.startTs;
    }

    @Generated
    public long getFinishTs() {
        return this.finishTs;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public void setExecutionId(UUID executionId) {
        this.executionId = executionId;
    }

    @Generated
    public void setParentStepId(UUID parentStepId) {
        this.parentStepId = parentStepId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setStartTs(long startTs) {
        this.startTs = startTs;
    }

    @Generated
    public void setFinishTs(long finishTs) {
        this.finishTs = finishTs;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskExecutionProgressStepDto)) {
            return false;
        }
        TaskExecutionProgressStepDto other = (TaskExecutionProgressStepDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getStartTs() != other.getStartTs()) {
            return false;
        }
        if (this.getFinishTs() != other.getFinishTs()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$executionId = this.getExecutionId();
        UUID other$executionId = other.getExecutionId();
        if (this$executionId == null ? other$executionId != null : !((Object)this$executionId).equals(other$executionId)) {
            return false;
        }
        UUID this$parentStepId = this.getParentStepId();
        UUID other$parentStepId = other.getParentStepId();
        if (this$parentStepId == null ? other$parentStepId != null : !((Object)this$parentStepId).equals(other$parentStepId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TaskExecutionProgressStepDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startTs = this.getStartTs();
        result = result * 59 + (int)($startTs >>> 32 ^ $startTs);
        long $finishTs = this.getFinishTs();
        result = result * 59 + (int)($finishTs >>> 32 ^ $finishTs);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $executionId = this.getExecutionId();
        result = result * 59 + ($executionId == null ? 43 : ((Object)$executionId).hashCode());
        UUID $parentStepId = this.getParentStepId();
        result = result * 59 + ($parentStepId == null ? 43 : ((Object)$parentStepId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TaskExecutionProgressStepDto(id=" + String.valueOf(this.getId()) + ", executionId=" + String.valueOf(this.getExecutionId()) + ", parentStepId=" + String.valueOf(this.getParentStepId()) + ", name=" + this.getName() + ", startTs=" + this.getStartTs() + ", finishTs=" + this.getFinishTs() + ")";
    }

    @Generated
    public TaskExecutionProgressStepDto() {
    }

    @Generated
    public TaskExecutionProgressStepDto(UUID id, UUID executionId, UUID parentStepId, String name, long startTs, long finishTs) {
        this.id = id;
        this.executionId = executionId;
        this.parentStepId = parentStepId;
        this.name = name;
        this.startTs = startTs;
        this.finishTs = finishTs;
    }
}

