/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.task;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.dao.task.TaskExecutionDto;
import org.thingsboard.trendz.dao.task.TaskExecutionProgressStepDto;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.task.TaskExecutionProgressContent;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.model.TaskExecution;
import org.thingsboard.trendz.service.task.model.TaskExecutionProgress;
import org.thingsboard.trendz.service.task.model.TaskExecutionProgressStep;
import org.thingsboard.trendz.service.task.model.TaskExecutionStatus;
import org.thingsboard.trendz.service.task.model.TaskJobType;
import org.thingsboard.trendz.tools.json.JsonUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="trendz_task_execution")
public class TaskExecutionDto {
    @Id
    private UUID id;
    @Column(name="task_id")
    private UUID taskId;
    @Column(name="tenant_id")
    private UUID tenantId;
    @Column(name="customer_id")
    private UUID customerId;
    @Column(name="user_id")
    private UUID userId;
    @Enumerated(value=EnumType.STRING)
    @Column(name="status")
    private TaskExecutionStatus status;
    @Column(name="created_ts")
    private long createdTs;
    @Column(name="start_ts")
    private long startTs;
    @Column(name="finish_ts")
    private long finishTs;
    @Column(name="duration")
    private long duration;
    @Column(name="json_progress_content")
    private String jsonProgressContent;
    @OneToMany(mappedBy="executionId", cascade={CascadeType.ALL}, fetch=FetchType.EAGER, orphanRemoval=false)
    @OnDelete(action=OnDeleteAction.CASCADE)
    private List<TaskExecutionProgressStepDto> steps;
    @Column(name="job_type")
    @Enumerated(value=EnumType.STRING)
    private TaskJobType jobType;
    @Column(name="json_job")
    private String jsonJob;
    @Column(name="json_result")
    private String jsonResult;

    public TaskExecution toData(Class<? extends TaskJob> jobClass, Class<? extends TaskExecutionProgressContent> progressContentClass) {
        return TaskExecution.builder().id(this.id).taskId(this.taskId).user(new JwtSecurityUser(this.tenantId, this.customerId, this.userId)).status(this.status).createdTs(this.createdTs).startTs(this.startTs).finishTs(this.finishTs).duration(this.duration).taskExecutionProgress(TaskExecutionProgress.builder().content((TaskExecutionProgressContent)JsonUtils.fromJson((String)this.jsonProgressContent, progressContentClass)).rootStep(TaskExecutionDto.mapExecutionSteps((List)this.steps)).build()).jobType(this.jobType).job((TaskJob)JsonUtils.fromJson((String)this.jsonJob, jobClass)).jsonResult(this.jsonResult).build();
    }

    public static TaskExecutionDto from(TaskExecution entity) {
        return TaskExecutionDto.builder().id(entity.getId()).taskId(entity.getTaskId()).tenantId(entity.getUser().getTenantId()).customerId(entity.getUser().getCustomerId()).userId(entity.getUser().getUserId()).status(entity.getStatus()).createdTs(entity.getCreatedTs()).startTs(entity.getStartTs()).finishTs(entity.getFinishTs()).duration(entity.getDuration()).jsonProgressContent(JsonUtils.toJson((Object)entity.getTaskExecutionProgress().getContent())).steps(TaskExecutionDto.mapExecutionSteps((TaskExecutionProgressStep)entity.getTaskExecutionProgress().getRootStep())).jobType(entity.getJobType()).jsonJob(JsonUtils.toJson((Object)entity.getJob())).jsonResult(entity.getJsonResult()).build();
    }

    public static List<TaskExecutionProgressStepDto> mapExecutionSteps(TaskExecutionProgressStep rootStep) {
        if (rootStep == null) {
            return null;
        }
        ArrayList<TaskExecutionProgressStepDto> result = new ArrayList<TaskExecutionProgressStepDto>();
        TaskExecutionDto.traverseAndCollect((TaskExecutionProgressStep)rootStep, result);
        return result;
    }

    public static TaskExecutionProgressStep mapExecutionSteps(List<TaskExecutionProgressStepDto> stepDtoList) {
        if (stepDtoList == null || stepDtoList.isEmpty()) {
            return null;
        }
        HashMap<UUID, TaskExecutionProgressStep> nodeMap = new HashMap<UUID, TaskExecutionProgressStep>();
        for (TaskExecutionProgressStepDto dto : stepDtoList) {
            nodeMap.put(dto.getId(), dto.toData());
        }
        TaskExecutionProgressStep root = null;
        for (TaskExecutionProgressStep node : nodeMap.values()) {
            if (node.getParentStepId().equals(EntityId.NULL_UUID)) {
                if (root == null) {
                    root = node;
                    continue;
                }
                if (root.getId() != null) {
                    TaskExecutionProgressStep dummyRoot = TaskExecutionProgressStep.builder().id(null).name("root").startTs(0L).finishTs(0L).childrenSteps(new ArrayList()).build();
                    dummyRoot.getChildrenSteps().add(root);
                    dummyRoot.getChildrenSteps().add(node);
                    root = dummyRoot;
                    continue;
                }
                root.getChildrenSteps().add(node);
                continue;
            }
            TaskExecutionProgressStep parent = (TaskExecutionProgressStep)nodeMap.get(node.getParentStepId());
            if (parent == null) continue;
            parent.getChildrenSteps().add(node);
        }
        TaskExecutionDto.sortChildrenRecursively(root);
        return root;
    }

    private static void traverseAndCollect(TaskExecutionProgressStep node, List<TaskExecutionProgressStepDto> result) {
        TaskExecutionProgressStepDto dto = TaskExecutionProgressStepDto.from((TaskExecutionProgressStep)node);
        result.add(dto);
        if (node.getChildrenSteps() != null) {
            for (TaskExecutionProgressStep child : node.getChildrenSteps()) {
                TaskExecutionDto.traverseAndCollect((TaskExecutionProgressStep)child, result);
            }
        }
    }

    private static void sortChildrenRecursively(TaskExecutionProgressStep node) {
        if (node == null || node.getChildrenSteps() == null) {
            return;
        }
        Collections.sort(node.getChildrenSteps());
        for (TaskExecutionProgressStep child : node.getChildrenSteps()) {
            TaskExecutionDto.sortChildrenRecursively((TaskExecutionProgressStep)child);
        }
    }

    @Generated
    public static TaskExecutionDtoBuilder builder() {
        return new TaskExecutionDtoBuilder();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public UUID getTaskId() {
        return this.taskId;
    }

    @Generated
    public UUID getTenantId() {
        return this.tenantId;
    }

    @Generated
    public UUID getCustomerId() {
        return this.customerId;
    }

    @Generated
    public UUID getUserId() {
        return this.userId;
    }

    @Generated
    public TaskExecutionStatus getStatus() {
        return this.status;
    }

    @Generated
    public long getCreatedTs() {
        return this.createdTs;
    }

    @Generated
    public long getStartTs() {
        return this.startTs;
    }

    @Generated
    public long getFinishTs() {
        return this.finishTs;
    }

    @Generated
    public long getDuration() {
        return this.duration;
    }

    @Generated
    public String getJsonProgressContent() {
        return this.jsonProgressContent;
    }

    @Generated
    public List<TaskExecutionProgressStepDto> getSteps() {
        return this.steps;
    }

    @Generated
    public TaskJobType getJobType() {
        return this.jobType;
    }

    @Generated
    public String getJsonJob() {
        return this.jsonJob;
    }

    @Generated
    public String getJsonResult() {
        return this.jsonResult;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public void setTaskId(UUID taskId) {
        this.taskId = taskId;
    }

    @Generated
    public void setTenantId(UUID tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setCustomerId(UUID customerId) {
        this.customerId = customerId;
    }

    @Generated
    public void setUserId(UUID userId) {
        this.userId = userId;
    }

    @Generated
    public void setStatus(TaskExecutionStatus status) {
        this.status = status;
    }

    @Generated
    public void setCreatedTs(long createdTs) {
        this.createdTs = createdTs;
    }

    @Generated
    public void setStartTs(long startTs) {
        this.startTs = startTs;
    }

    @Generated
    public void setFinishTs(long finishTs) {
        this.finishTs = finishTs;
    }

    @Generated
    public void setDuration(long duration) {
        this.duration = duration;
    }

    @Generated
    public void setJsonProgressContent(String jsonProgressContent) {
        this.jsonProgressContent = jsonProgressContent;
    }

    @Generated
    public void setSteps(List<TaskExecutionProgressStepDto> steps) {
        this.steps = steps;
    }

    @Generated
    public void setJobType(TaskJobType jobType) {
        this.jobType = jobType;
    }

    @Generated
    public void setJsonJob(String jsonJob) {
        this.jsonJob = jsonJob;
    }

    @Generated
    public void setJsonResult(String jsonResult) {
        this.jsonResult = jsonResult;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskExecutionDto)) {
            return false;
        }
        TaskExecutionDto other = (TaskExecutionDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getCreatedTs() != other.getCreatedTs()) {
            return false;
        }
        if (this.getStartTs() != other.getStartTs()) {
            return false;
        }
        if (this.getFinishTs() != other.getFinishTs()) {
            return false;
        }
        if (this.getDuration() != other.getDuration()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$taskId = this.getTaskId();
        UUID other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !((Object)this$taskId).equals(other$taskId)) {
            return false;
        }
        UUID this$tenantId = this.getTenantId();
        UUID other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        UUID this$customerId = this.getCustomerId();
        UUID other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        UUID this$userId = this.getUserId();
        UUID other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        TaskExecutionStatus this$status = this.getStatus();
        TaskExecutionStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$jsonProgressContent = this.getJsonProgressContent();
        String other$jsonProgressContent = other.getJsonProgressContent();
        if (this$jsonProgressContent == null ? other$jsonProgressContent != null : !this$jsonProgressContent.equals(other$jsonProgressContent)) {
            return false;
        }
        List this$steps = this.getSteps();
        List other$steps = other.getSteps();
        if (this$steps == null ? other$steps != null : !((Object)this$steps).equals(other$steps)) {
            return false;
        }
        TaskJobType this$jobType = this.getJobType();
        TaskJobType other$jobType = other.getJobType();
        if (this$jobType == null ? other$jobType != null : !this$jobType.equals(other$jobType)) {
            return false;
        }
        String this$jsonJob = this.getJsonJob();
        String other$jsonJob = other.getJsonJob();
        if (this$jsonJob == null ? other$jsonJob != null : !this$jsonJob.equals(other$jsonJob)) {
            return false;
        }
        String this$jsonResult = this.getJsonResult();
        String other$jsonResult = other.getJsonResult();
        return !(this$jsonResult == null ? other$jsonResult != null : !this$jsonResult.equals(other$jsonResult));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TaskExecutionDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $createdTs = this.getCreatedTs();
        result = result * 59 + (int)($createdTs >>> 32 ^ $createdTs);
        long $startTs = this.getStartTs();
        result = result * 59 + (int)($startTs >>> 32 ^ $startTs);
        long $finishTs = this.getFinishTs();
        result = result * 59 + (int)($finishTs >>> 32 ^ $finishTs);
        long $duration = this.getDuration();
        result = result * 59 + (int)($duration >>> 32 ^ $duration);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : ((Object)$taskId).hashCode());
        UUID $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        UUID $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        UUID $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        TaskExecutionStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $jsonProgressContent = this.getJsonProgressContent();
        result = result * 59 + ($jsonProgressContent == null ? 43 : $jsonProgressContent.hashCode());
        List $steps = this.getSteps();
        result = result * 59 + ($steps == null ? 43 : ((Object)$steps).hashCode());
        TaskJobType $jobType = this.getJobType();
        result = result * 59 + ($jobType == null ? 43 : $jobType.hashCode());
        String $jsonJob = this.getJsonJob();
        result = result * 59 + ($jsonJob == null ? 43 : $jsonJob.hashCode());
        String $jsonResult = this.getJsonResult();
        result = result * 59 + ($jsonResult == null ? 43 : $jsonResult.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TaskExecutionDto(id=" + String.valueOf(this.getId()) + ", taskId=" + String.valueOf(this.getTaskId()) + ", tenantId=" + String.valueOf(this.getTenantId()) + ", customerId=" + String.valueOf(this.getCustomerId()) + ", userId=" + String.valueOf(this.getUserId()) + ", status=" + String.valueOf(this.getStatus()) + ", createdTs=" + this.getCreatedTs() + ", startTs=" + this.getStartTs() + ", finishTs=" + this.getFinishTs() + ", duration=" + this.getDuration() + ", jsonProgressContent=" + this.getJsonProgressContent() + ", steps=" + String.valueOf(this.getSteps()) + ", jobType=" + String.valueOf(this.getJobType()) + ", jsonJob=" + this.getJsonJob() + ", jsonResult=" + this.getJsonResult() + ")";
    }

    @Generated
    public TaskExecutionDto() {
    }

    @Generated
    public TaskExecutionDto(UUID id, UUID taskId, UUID tenantId, UUID customerId, UUID userId, TaskExecutionStatus status, long createdTs, long startTs, long finishTs, long duration, String jsonProgressContent, List<TaskExecutionProgressStepDto> steps, TaskJobType jobType, String jsonJob, String jsonResult) {
        this.id = id;
        this.taskId = taskId;
        this.tenantId = tenantId;
        this.customerId = customerId;
        this.userId = userId;
        this.status = status;
        this.createdTs = createdTs;
        this.startTs = startTs;
        this.finishTs = finishTs;
        this.duration = duration;
        this.jsonProgressContent = jsonProgressContent;
        this.steps = steps;
        this.jobType = jobType;
        this.jsonJob = jsonJob;
        this.jsonResult = jsonResult;
    }
}

