/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.sql;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.stereotype.Repository;
import org.thingsboard.trendz.dao.sql.SqlDatasourceDto;

@Repository
public interface SqlDatasourceRepository
extends CrudRepository<SqlDatasourceDto, UUID> {
    @Query(value="SELECT d\nFROM datasource d\nWHERE d.tenantId = :tenantId\n")
    public List<SqlDatasourceDto> findAllByTenantId(UUID var1);

    @Query(value="SELECT d\nFROM datasource d\nWHERE d.id = :id\n    AND d.tenantId = :tenantId\n")
    public Optional<SqlDatasourceDto> findByIdAndTenantId(UUID var1, UUID var2);

    @Query(value="DELETE FROM datasource d\nWHERE d.id = :id\n    AND d.tenantId = :tenantId\n")
    @Modifying
    public void deleteByIdAndTenantId(UUID var1, UUID var2);

    @Query(value="SELECT 'BUSINESS_ENTITY' AS TYPE, be.name AS name\nFROM business_entity be\nWHERE be.tenant_id = :tenantId\n    AND CAST((CAST(be.query AS jsonb) ->> 'externalDataSource') AS uuid) = :entityId\n", nativeQuery=true)
    public List<Object[]> findDependedEntities(UUID var1, UUID var2);
}

