/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.sql;

import jakarta.transaction.Transactional;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.TimeStampUUIDGenerator;
import org.thingsboard.trendz.dao.sql.SqlDatasourceDto;
import org.thingsboard.trendz.dao.sql.SqlDatasourceRepository;
import org.thingsboard.trendz.domain.sql.SqlDatasource;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.definition.ChangeEntityValidationInfo;
import org.thingsboard.trendz.service.definition.ChangeEntityValidationItem;

@Service
@Transactional
public class SqlDatasourceDao {
    private final SqlDatasourceRepository datasourceRepository;

    @Autowired
    public SqlDatasourceDao(SqlDatasourceRepository datasourceRepository) {
        this.datasourceRepository = datasourceRepository;
    }

    public SqlDatasource save(JwtSecurityUser user, SqlDatasource sqlDatasource) {
        if (sqlDatasource.getId() == null) {
            sqlDatasource.setId(TimeStampUUIDGenerator.generateId());
        }
        SqlDatasourceDto dto = SqlDatasourceDto.from((JwtSecurityUser)user, (SqlDatasource)sqlDatasource);
        return ((SqlDatasourceDto)this.datasourceRepository.save((Object)dto)).toData();
    }

    public List<SqlDatasource> findAll(JwtSecurityUser user) {
        return this.datasourceRepository.findAllByTenantId(user.getTenantId()).stream().map(SqlDatasourceDto::toData).toList();
    }

    public SqlDatasource findById(UUID tenantId, UUID id) {
        return this.datasourceRepository.findByIdAndTenantId(id, tenantId).map(SqlDatasourceDto::toData).orElseThrow(() -> new IllegalStateException("No datasource found with id " + String.valueOf(id)));
    }

    public boolean delete(JwtSecurityUser user, UUID id) {
        this.datasourceRepository.deleteByIdAndTenantId(id, user.getTenantId());
        return true;
    }

    public List<SqlDatasource> saveAll(List<SqlDatasource> sqlDatasource, JwtSecurityUser user) {
        List<SqlDatasourceDto> dtos = sqlDatasource.stream().map(datasource -> SqlDatasourceDto.from((JwtSecurityUser)user, (SqlDatasource)datasource)).toList();
        return StreamSupport.stream(this.datasourceRepository.saveAll(dtos).spliterator(), false).map(SqlDatasourceDto::toData).toList();
    }

    public ChangeEntityValidationInfo findDependedEntities(JwtSecurityUser user, SqlDatasource entity) {
        UUID tenantId = user.getTenantId();
        Set dependencyItemSet = this.datasourceRepository.findDependedEntities(tenantId, entity.getId()).stream().map(array -> new ChangeEntityValidationItem((String)array[0], (String)array[1])).collect(Collectors.toSet());
        return new ChangeEntityValidationInfo(dependencyItemSet);
    }
}

